/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.CategoryFolderNode;
import org.netbeans.modules.bpel.nodes.ReloadableChildren;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.choosers.FaultNameChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.filter.ChildTypeFilter;
import org.netbeans.modules.bpel.properties.props.PropertyVetoError;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.CustomNodeChooser;
import org.netbeans.modules.soa.ui.form.ValidablePropertyCustomizer;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultNamePropertyCustomizer
extends ValidablePropertyCustomizer
implements CustomNodeChooser<QName>,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Timer inputDelayTimer;
    private QName myFaultName;
    protected PropertyEditor myPropertyEditor;
    private NodeAction okAction;
    private Lookup myLookup;
    private JCheckBox chbShowImportedOnly;
    private JTextField fldLocalPart;
    private JTextField fldNamespace;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblErrorMessage;
    private JPanel pnlChooser;

    public FaultNamePropertyCustomizer(Lookup lookup) {
        this();
        this.myLookup = lookup;
    }

    public FaultNamePropertyCustomizer() {
        this.createContent();
    }

    public void init(PropertyEnv propertyEnv, PropertyEditor propertyEditor) {
        if (this.myPropertyEnv != null) {
            this.myPropertyEnv.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.init(propertyEnv, propertyEditor);
        this.myPropertyEditor = propertyEditor;
        this.myPropertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        this.myPropertyEnv.setState(this.getValidStateManager(true).isValid() ? PropertyEnv.STATE_NEEDS_VALIDATION : PropertyEnv.STATE_INVALID);
        this.setFaultName((QName)propertyEditor.getValue(), null);
        this.initControls();
        Node node = this.getChooserPanel().getExplorerManager().getRootContext();
        CategoryFolderNode categoryFolderNode = NodeUtils.findFirstNode(NodeType.WSDL_FILES_FOLDER, CategoryFolderNode.class, node, 2);
        if (categoryFolderNode != null) {
            this.getChooserPanel().getTreeView().expandNode((Node)categoryFolderNode);
        }
    }

    public void createContent() {
        this.initComponents();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FaultNamePropertyCustomizer.this.setFaultName(FaultNamePropertyCustomizer.this.calculateFaultNameFromText(), actionEvent.getSource());
                FaultNamePropertyCustomizer.this.getValidator().revalidate(true);
            }
        };
        this.inputDelayTimer = new Timer(400, actionListener);
        this.inputDelayTimer.setCoalesce(true);
        this.inputDelayTimer.setRepeats(false);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FaultNamePropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FaultNamePropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FaultNamePropertyCustomizer.this.inputDelayTimer.restart();
            }
        };
        this.fldNamespace.getDocument().addDocumentListener(documentListener);
        this.fldLocalPart.getDocument().addDocumentListener(documentListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FaultNamePropertyCustomizer.this.inputDelayTimer.stop();
                FaultNamePropertyCustomizer.this.setFaultName(FaultNamePropertyCustomizer.this.calculateFaultNameFromText(), focusEvent.getSource());
                FaultNamePropertyCustomizer.this.getValidator().revalidate(true);
            }
        };
        this.fldNamespace.addFocusListener(focusAdapter);
        this.fldLocalPart.addFocusListener(focusAdapter);
        this.getChooserPanel().getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                QName qName;
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (qName = FaultNamePropertyCustomizer.this.getChooserPanel().getSelectedValue()) != null) {
                    FaultNamePropertyCustomizer.this.setFaultName(qName, FaultNamePropertyCustomizer.this.getChooserPanel());
                    FaultNamePropertyCustomizer.this.getValidator().revalidate(true);
                }
            }
        });
        this.getValidStateManager(true).ignoreValidator(this.getChooserPanel().getValidator(), true);
        this.chbShowImportedOnly.setSelected(true);
        this.chbShowImportedOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Lookup lookup = FaultNamePropertyCustomizer.this.getLookup();
                BpelModel bpelModel = (BpelModel)lookup.lookup(BpelModel.class);
                Process process = bpelModel.getProcess();
                NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

                    public boolean accept(Node node) {
                        NodeType nodeType;
                        return node instanceof BpelNode && (nodeType = ((BpelNode)node).getNodeType()) == NodeType.WSDL_FILES_FOLDER;
                    }

                    public boolean drillDeeper(Node node) {
                        NodeType nodeType = ((BpelNode)node).getNodeType();
                        return nodeType == NodeType.PROCESS;
                    }
                };
                Node node = FaultNamePropertyCustomizer.this.getChooserPanel().getExplorerManager().getRootContext();
                List<Node> list = NodeUtils.findNodes(node, searchVisitor, 2);
                for (Node node2 : list) {
                    Children children = node2.getChildren();
                    if (!(children instanceof ReloadableChildren)) continue;
                    ((ReloadableChildren)children).reload();
                }
            }
        });
        this.getChooserPanel().createContent();
        FaultNameChooserPanel faultNameChooserPanel = this.getChooserPanel();
        Util.attachDefaultDblClickAction(faultNameChooserPanel, faultNameChooserPanel);
        SoaUtil.activateInlineMnemonics((Container)((Object)this));
        HelpCtx.setHelpIDString((JComponent)((Object)this), (String)this.getClass().getName());
    }

    protected synchronized FaultNameChooserPanel getChooserPanel() {
        if (this.pnlChooser == null) {
            this.pnlChooser = this.createChooserPanel();
        }
        return (FaultNameChooserPanel)this.pnlChooser;
    }

    protected FaultNameChooserPanel createChooserPanel() {
        return new FaultNameChooserPanel();
    }

    protected void applyNewValues() {
        this.myPropertyEditor.setValue(this.getFaultName());
    }

    private QName calculateFaultNameFromText() {
        String string = this.fldNamespace.getText();
        String string2 = this.fldLocalPart.getText();
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
            return null;
        }
        QName qName = new QName(string, string2);
        return qName;
    }

    private void setFaultName(QName qName, Object object) {
        this.myFaultName = qName;
        if (qName == null) {
            this.fldNamespace.setText("");
            this.fldLocalPart.setText("");
            this.getChooserPanel().setSelectedValue(null);
        } else {
            if (object != this.inputDelayTimer && object != this.fldNamespace && object != this.fldLocalPart) {
                this.fldNamespace.setText(qName.getNamespaceURI());
                this.fldLocalPart.setText(qName.getLocalPart());
            }
            if (object != this.getChooserPanel()) {
                this.getChooserPanel().setSelectedValue(qName);
            }
        }
    }

    private QName getFaultName() {
        return this.myFaultName;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            try {
                this.applyNewValues();
            }
            catch (PropertyVetoError propertyVetoError) {
                this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                PropertyVetoError.defaultProcessing(propertyVetoError);
            }
        }
    }

    public Validator createValidator() {
        return new DefaultValidator((ValidStateManager.Provider)this, ErrorMessagesBundle.class){

            public void doFastValidation() {
            }
        };
    }

    public void setDescriptor(DefaultDialogDescriptor defaultDialogDescriptor) {
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean initControls() {
        Lookup lookup = this.getLookup();
        ChildTypeFilter childTypeFilter = new ChildTypeFilter(){

            public boolean isPairAllowed(NodeType nodeType, NodeType nodeType2) {
                if (FaultNamePropertyCustomizer.this.chbShowImportedOnly.isSelected()) {
                    return !nodeType2.equals((Object)NodeType.WSDL_FILE) && !nodeType2.equals((Object)NodeType.SCHEMA_FILE);
                }
                return true;
            }
        };
        lookup = new ExtendedLookup(lookup, new Object[]{childTypeFilter});
        this.getChooserPanel().setLookup(lookup);
        this.getChooserPanel().initControls();
        this.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    FaultNamePropertyCustomizer.this.lblErrorMessage.setText("");
                } else {
                    FaultNamePropertyCustomizer.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
        this.getValidator().revalidate(true);
        return true;
    }

    public QName getSelectedValue() {
        return this.getFaultName();
    }

    public void setSelectedValue(QName qName) {
        this.setFaultName(qName, null);
        this.getValidator().revalidate(true);
    }

    public Lookup getLookup() {
        if (this.myLookup != null) {
            return this.myLookup;
        }
        if (this.myPropertyEnv != null) {
            Object[] objectArray = this.myPropertyEnv.getBeans();
            BpelNode bpelNode = (BpelNode)((Object)objectArray[0]);
            Lookup lookup = bpelNode.getLookup();
            return lookup;
        }
        return null;
    }

    public boolean afterClose() {
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fldNamespace = new JTextField();
        this.jLabel2 = new JLabel();
        this.fldLocalPart = new JTextField();
        this.pnlChooser = this.getChooserPanel();
        this.chbShowImportedOnly = new JCheckBox();
        this.lblErrorMessage = new JLabel();
        this.jLabel1.setLabelFor(this.fldNamespace);
        this.jLabel1.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_URI"));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_URI"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_URI"));
        this.jLabel2.setLabelFor(this.fldLocalPart);
        this.jLabel2.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Local_Name"));
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Local_Name"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Local_Name"));
        this.pnlChooser.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlChooser);
        this.pnlChooser.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 361, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 225, Short.MAX_VALUE));
        this.chbShowImportedOnly.setText(NbBundle.getMessage(FormBundle.class, (String)"CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbShowImportedOnly.setMargin(new Insets(0, 0, 0, 0));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_CHB_Show_Imported_Files_Only"));
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.lblErrorMessage, -1, 361, Short.MAX_VALUE).add(1, (Component)this.pnlChooser, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.fldNamespace, -1, 252, Short.MAX_VALUE).add((Component)this.fldLocalPart, -1, 252, Short.MAX_VALUE))).add(1, (Component)this.chbShowImportedOnly)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.fldNamespace, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.fldLocalPart, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlChooser, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chbShowImportedOnly).addPreferredGap(0).add((Component)this.lblErrorMessage, -2, 26, -2).addContainerGap()));
    }
}

