/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search;

import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.search.Diagram;
import org.netbeans.modules.bpel.search.Engine;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.api.SearchException;
import org.netbeans.modules.xml.search.api.SearchOption;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Construct
extends Engine {
    public void search(SearchOption searchOption) throws SearchException {
        Diagram diagram = (Diagram)searchOption.getProvider().getRoot();
        diagram.clearHighlighting();
        this.fireSearchStarted(searchOption);
        this.search(diagram, searchOption.useSelection());
        this.fireSearchFinished(searchOption);
    }

    private void search(Diagram diagram, boolean bl) {
        List<Diagram.Element> list = diagram.getElements(bl);
        for (Diagram.Element element : list) {
            BpelEntity bpelEntity = element.getBpelEntity();
            if (!this.acceptsAttribute(bpelEntity) && !this.acceptsComponent(bpelEntity)) continue;
            this.fireSearchFound((SearchElement)new Engine.Element(element));
        }
    }

    private boolean acceptsAttribute(BpelEntity bpelEntity) {
        if (!(bpelEntity instanceof DocumentComponent)) {
            return false;
        }
        NamedNodeMap namedNodeMap = bpelEntity.getPeer().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (this.accepts(node.getNodeName())) {
                return true;
            }
            if (!this.accepts(node.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    private boolean acceptsComponent(BpelEntity bpelEntity) {
        if (!(bpelEntity instanceof DocumentComponent)) {
            return false;
        }
        return this.accepts(bpelEntity.getPeer().getTagName());
    }

    public String getDisplayName() {
        return UI.i18n(Engine.class, (String)"LBL_Construct_Display_Name");
    }

    public String getShortDescription() {
        return UI.i18n(Engine.class, (String)"LBL_Construct_Short_Description");
    }
}

