/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search;

import java.util.List;
import org.netbeans.modules.bpel.search.Diagram;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.api.SearchException;
import org.netbeans.modules.xml.search.api.SearchOption;
import org.netbeans.modules.xml.search.spi.SearchEngine;
import org.netbeans.modules.xml.ui.UI;

public class Engine
extends SearchEngine.Adapter {
    public void search(SearchOption searchOption) throws SearchException {
        Diagram diagram = (Diagram)searchOption.getProvider().getRoot();
        diagram.clearHighlighting();
        this.fireSearchStarted(searchOption);
        this.search(diagram, searchOption.useSelection());
        this.fireSearchFinished(searchOption);
    }

    private void search(Diagram diagram, boolean bl) {
        List<Diagram.Element> list = diagram.getElements(bl);
        for (Diagram.Element element : list) {
            String string = element.getName();
            if (!this.accepts(string)) continue;
            this.fireSearchFound((SearchElement)new Element(element));
        }
    }

    public boolean isApplicable(Object object) {
        return object instanceof Diagram;
    }

    public String getDisplayName() {
        return UI.i18n(Engine.class, (String)"LBL_Engine_Display_Name");
    }

    public String getShortDescription() {
        return UI.i18n(Engine.class, (String)"LBL_Engine_Short_Description");
    }

    protected static class Element
    extends SearchElement.Adapter {
        private Diagram.Element myElement;

        Element(Diagram.Element element) {
            super(element.getName(), element.getName(), null, null);
            this.myElement = element;
            this.highlight();
        }

        public void gotoSource() {
            this.myElement.gotoSource();
        }

        public void gotoVisual() {
            this.myElement.gotoDesign();
        }

        public void highlight() {
            this.myElement.highlight();
        }

        public void unhighlight() {
            this.myElement.unhighlight();
        }
    }
}

