/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.awt.BorderLayout;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.ui.StartPageContent;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class WelcomeComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private static WeakReference<WelcomeComponent> component = new WeakReference<Object>(null);
    private JComponent content;
    private boolean initialized = false;
    private static boolean firstTimeOpen = true;

    private WelcomeComponent() {
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage(WelcomeComponent.class, (String)"LBL_Tab_Title"));
        this.content = null;
        this.initialized = false;
        this.putClientProperty("activateAtStartup", Boolean.TRUE);
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected String preferredID() {
        return "WelcomeComponent";
    }

    private void doInitialize() {
        this.initAccessibility();
        if (null == this.content) {
            WelcomeOptions.getDefault().incrementStartCounter();
            this.content = new StartPageContent();
            this.add(this.content, "Center");
            this.setFocusable(false);
        }
    }

    public static WelcomeComponent findComp() {
        WelcomeComponent welcomeComponent = (WelcomeComponent)((Object)component.get());
        if (welcomeComponent == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("Welcome");
            if (topComponent != null) {
                if (topComponent instanceof WelcomeComponent) {
                    welcomeComponent = (WelcomeComponent)topComponent;
                    component = new WeakReference<WelcomeComponent>(welcomeComponent);
                } else {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + WelcomeComponent.class.getName() + " Returned:" + topComponent.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                    welcomeComponent = WelcomeComponent.createComp();
                }
            } else {
                welcomeComponent = WelcomeComponent.createComp();
            }
        }
        return welcomeComponent;
    }

    public static WelcomeComponent createComp() {
        WelcomeComponent welcomeComponent = (WelcomeComponent)((Object)component.get());
        if (welcomeComponent == null) {
            welcomeComponent = new WelcomeComponent();
            component = new WeakReference<WelcomeComponent>(welcomeComponent);
        }
        return welcomeComponent;
    }

    public int getPersistenceType() {
        return 1;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WelcomeComponent.class, (String)"ACS_Welcome_DESC"));
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        if (null != this.content && this.getComponentCount() == 0) {
            this.add(this.content, "Center");
        }
        super.componentShowing();
        this.setActivatedNodes(new Node[0]);
    }

    protected void componentOpened() {
        super.componentOpened();
        if (firstTimeOpen) {
            firstTimeOpen = false;
            if (!WelcomeOptions.getDefault().isShowOnStartup()) {
                this.close();
            }
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (null != this.content) {
            this.remove(this.content);
        }
    }

    public void requestFocus() {
        if (null != this.content) {
            this.content.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (null != this.content) {
            return this.content.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }
}

