/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Utils {
    private Utils() {
    }

    public static Graphics2D prepareGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map == null && Boolean.getBoolean("swing.aatext")) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (map != null) {
            graphics2D.addRenderingHints(map);
        }
        return graphics2D;
    }

    public static void showURL(String string) {
        try {
            HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
            if (uRLDisplayer != null) {
                uRLDisplayer.showURL(new URL(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int getDefaultFontSize() {
        Integer n = (Integer)UIManager.get("customFontSize");
        if (n != null) {
            return n;
        }
        Font font = UIManager.getFont("TextField.font");
        return font != null ? font.getSize() : 12;
    }

    public static Action findAction(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                Object object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null && (object = instanceCookie.instanceCreate()) instanceof Action) {
                    Action action = (Action)object;
                    return action;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public static Action createSampleProjectAction() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> clazz = Class.forName("org.netbeans.modules.project.ui.actions.NewProject", true, classLoader);
            Method method = clazz.getMethod("newSample", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object instanceof Action) {
                return (Action)object;
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return null;
    }

    public static Color getColor(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.welcome.resources.Bundle");
        try {
            Integer n = Integer.decode(resourceBundle.getString(string));
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            return Color.BLACK;
        }
    }

    public static File getCacheStore() throws IOException {
        File file;
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            file = new File(new File(new File(string, "var"), "cache"), "welcome");
        } else {
            File file2 = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            file = new File(file2, "welcome");
        }
        return file;
    }

    public static String getUrlString(DataObject dataObject) {
        try {
            Method method = dataObject.getClass().getDeclaredMethod("getURLString", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)dataObject, new Object[0]);
            if (null != object) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

