/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lexer.api;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lexer.CSSLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CSSTokenId implements TokenId
{
    EOF("default"),
    S("whitespace_comment"),
    MSE("ms_expression"),
    LBRACE("brace"),
    RBRACE("brace"),
    COMMA("separator"),
    DOT("operator"),
    SEMICOLON("separator"),
    COLON("separator"),
    ASTERISK("operator"),
    SLASH("operator"),
    PLUS("operator"),
    MINUS("operator"),
    EQUALS("operator"),
    GT("operator"),
    LSQUARE("brace"),
    RSQUARE("brace"),
    HASH("hash"),
    STRING("string"),
    RROUND("brace"),
    URL("url"),
    URI("url"),
    CDO("whitespace_comment"),
    CDC("whitespace_comment"),
    INCLUDES("operator"),
    DASHMATCH("operator"),
    IMPORT_SYM("keyword"),
    PAGE_SYM("keyword"),
    MEDIA_SYM("keyword"),
    FONT_FACE_SYM("keyword"),
    CHARSET_SYM("keyword"),
    ATKEYWORD("keyword"),
    IMPORTANT_SYM("keyword"),
    INHERIT("keyword"),
    EMS("number"),
    EXS("number"),
    LENGTH_PX("number"),
    LENGTH_CM("number"),
    LENGTH_MM("number"),
    LENGTH_IN("number"),
    LENGTH_PT("number"),
    LENGTH_PC("number"),
    ANGLE_DEG("number"),
    ANGLE_RAD("number"),
    ANGLE_GRAD("number"),
    TIME_MS("number"),
    TIME_S("number"),
    FREQ_HZ("number"),
    FREQ_KHZ("number"),
    DIMEN("number"),
    PERCENTAGE("number"),
    NUMBER("number"),
    RGB("default"),
    FUNCTION("function"),
    IDENT("identifier"),
    NAME("default"),
    NUM("number"),
    UNICODERANGE("default"),
    RANGE("default"),
    Q16("default"),
    Q15("default"),
    Q14("default"),
    Q13("default"),
    Q12("default"),
    Q11("default"),
    NMSTART("default"),
    NMCHAR("default"),
    SELECTOR_NMSTART("default"),
    SELECTOR_NMCHAR("default"),
    STRING1("string"),
    STRING2("string"),
    NONASCII("default"),
    ESCAPE("default"),
    NL("default"),
    UNICODE("default"),
    HNUM("default"),
    H("default"),
    UNKNOWN("unknown");

    private final String primaryCategory;
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final Language<CSSTokenId> language;

    private CSSTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public static Language<CSSTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    static {
        language = new LanguageHierarchy<CSSTokenId>(){

            protected Collection<CSSTokenId> createTokenIds() {
                return EnumSet.allOf(CSSTokenId.class);
            }

            protected Map<String, Collection<CSSTokenId>> createTokenCategories() {
                HashMap<String, Collection<CSSTokenId>> hashMap = new HashMap<String, Collection<CSSTokenId>>();
                return hashMap;
            }

            protected Lexer<CSSTokenId> createLexer(LexerRestartInfo<CSSTokenId> lexerRestartInfo) {
                return new CSSLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding embedding(Token<CSSTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                if (token.text() == null) {
                    return null;
                }
                if (token.id() == MSE) {
                    Language language = Language.find((String)CSSTokenId.JAVASCRIPT_MIMETYPE);
                    if (language == null) {
                        return null;
                    }
                    String string = ((Object)token.text()).toString();
                    int n = string.lastIndexOf(41);
                    return LanguageEmbedding.create((Language)language, (int)11, (int)(token.length() - n), (boolean)false);
                }
                return null;
            }

            protected String mimeType() {
                return "text/x-css";
            }
        }.language();
    }
}

