/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.parser.ASCII_CharStream;
import org.netbeans.modules.css.parser.CSSParser;
import org.netbeans.modules.css.parser.ParseException;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.css.parser.TokenMgrError;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.openide.util.NbBundle;

public class CssParserAccess {
    private static final String PREFIX = "GENERATED_";
    private static final String ERROR_MESSAGE_PREFIX = NbBundle.getMessage(CssParserAccess.class, (String)"unexpected_symbols");
    private static CssParserAccess DEFAULT = CssParserAccess.newInstance();
    private final CSSParser PARSER = new CSSParser();

    public static CssParserAccess newInstance() {
        return new CssParserAccess();
    }

    public static CssParserAccess getDefault() {
        return DEFAULT;
    }

    private CssParserAccess() {
    }

    public synchronized CssParserResult parse(Reader reader) {
        SimpleNode simpleNode = null;
        List<ParseException> list = new ArrayList<ParseException>(1);
        try {
            this.PARSER.errors().clear();
            this.PARSER.ReInit(new ASCII_CharStream(reader));
            simpleNode = this.PARSER.styleSheet();
            list = this.PARSER.errors();
        }
        catch (ParseException parseException) {
            list.add(parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            list.add(new ParseException(tokenMgrError.getMessage()));
        }
        return new CssParserResult(simpleNode, list);
    }

    public static boolean containsGeneratedCode(String string) {
        return string.contains(PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CssParserResult {
        private List<ParseException> parseExceptions;
        private SimpleNode root;

        private CssParserResult(SimpleNode simpleNode, List<ParseException> list) {
            this.root = simpleNode;
            this.parseExceptions = list;
        }

        public SimpleNode root() {
            return this.root;
        }

        public List<Error> errors(ParserFile parserFile) {
            ArrayList<Error> arrayList = new ArrayList<Error>(this.parseExceptions.size());
            for (ParseException parseException : this.parseExceptions) {
                Error error = this.createError(parseException, parserFile);
                if (error == null) continue;
                arrayList.add(error);
            }
            return arrayList;
        }

        private Error createError(ParseException parseException, ParserFile parserFile) {
            Token token = parseException.currentToken;
            if (token == null) {
                return new DefaultError(parseException.getMessage(), parseException.getMessage(), null, parserFile.getFileObject(), 0, 0, Severity.ERROR);
            }
            Token token2 = token.next;
            int n = token2.offset;
            if (!CssParserAccess.containsGeneratedCode(token.image) && !CssParserAccess.containsGeneratedCode(token2.image)) {
                String string = this.buildErrorMessage(parseException);
                return new DefaultError(string, string, null, parserFile.getFileObject(), n, n, Severity.ERROR);
            }
            return null;
        }

        private String buildErrorMessage(ParseException parseException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ERROR_MESSAGE_PREFIX);
            int n = 0;
            for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
                if (n >= parseException.expectedTokenSequences[i].length) continue;
                n = parseException.expectedTokenSequences[i].length;
            }
            Token token = parseException.currentToken.next;
            stringBuilder.append('\"');
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(token.image);
                if (i < n - 1) {
                    stringBuilder.append(',');
                    stringBuilder.append(' ');
                }
                token = token.next;
            }
            stringBuilder.append('\"');
            return stringBuilder.toString();
        }
    }
}

