/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.util.List;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public class AutoSelectionCanvas
implements MapperSelectionListener {
    private Canvas canvas;
    private TreePath currentPath;
    private Link currentLink;
    private Graph currentGraph;
    private Vertex currentVertex;

    public AutoSelectionCanvas(Canvas canvas) {
        this.canvas = canvas;
        canvas.getSelectionModel().addSelectionListener(this);
    }

    public void mapperSelectionChanged(MapperSelectionEvent mapperSelectionEvent) {
        GraphItem graphItem;
        Mapper mapper = this.canvas.getMapper();
        List<Vertex> list = this.canvas.getSelectionModel().getSelectedVerteces();
        List<Link> list2 = this.canvas.getSelectionModel().getSelectedLinks();
        Graph graph = this.canvas.getSelectionModel().getSelectedGraph();
        TreePath treePath = this.canvas.getSelectionModel().getSelectedPath();
        if (treePath == null) {
            return;
        }
        if (list2 != null && list2.size() > 0) {
            graphItem = list2.get(0);
            mapper.setExpandedGraphState(treePath, true);
            this.parentsExpand(treePath);
            if (((Link)graphItem).getSource() instanceof TreeSourcePin) {
                TreePath treePath2 = ((TreeSourcePin)((Link)graphItem).getSource()).getTreePath();
                treePath2 = this.canvas.getLeftTree().getParentVisiblePathForPath(treePath2);
                this.canvas.getLeftTree().setSelectionPath(treePath2);
            }
        }
        if (!(list == null || list.size() <= 0 || (graphItem = list.get(0)) == this.currentVertex && Utils.equal(treePath, this.currentPath) && graphItem == this.currentVertex)) {
            this.currentVertex = graphItem;
            if (mapper.getNode(treePath, true).isGraphCollapsed()) {
                mapper.setExpandedGraphState(treePath, true);
            }
        }
    }

    private void parentsExpand(TreePath treePath) {
        Mapper mapper = this.canvas.getMapper();
        if (treePath == mapper.getRoot().getTreePath()) {
            return;
        }
        TreePath treePath2 = mapper.getNode(treePath, true).getParent().getTreePath();
        mapper.setExpandedState(treePath2, true);
        this.parentsExpand(treePath2);
    }
}

