/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.CanvasEventHandler;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.CanvasSearchResult;
import org.netbeans.modules.soa.mappercore.CopyMapperAction;
import org.netbeans.modules.soa.mappercore.CustomVertexItemEditor;
import org.netbeans.modules.soa.mappercore.CutMapperAction;
import org.netbeans.modules.soa.mappercore.DefaultCanvasRendererContext;
import org.netbeans.modules.soa.mappercore.DefaultCanvasRendererPrintContext;
import org.netbeans.modules.soa.mappercore.DefaultVertexItemRenderer;
import org.netbeans.modules.soa.mappercore.DeleteMapperAction;
import org.netbeans.modules.soa.mappercore.InplaceEditor;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkConnectAction;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPanel;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.MoveDownCanvasAction;
import org.netbeans.modules.soa.mappercore.MoveLeftCanvasAction;
import org.netbeans.modules.soa.mappercore.MoveRightCanvasAction;
import org.netbeans.modules.soa.mappercore.MoveUpCanvasAction;
import org.netbeans.modules.soa.mappercore.PasteMapperAction;
import org.netbeans.modules.soa.mappercore.ShowPopapMenuAction;
import org.netbeans.modules.soa.mappercore.StartInplaceEditor;
import org.netbeans.modules.soa.mappercore.VertexCanvas;
import org.netbeans.modules.soa.mappercore.VertexItemEditor;
import org.netbeans.modules.soa.mappercore.VertexItemRenderer;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;
import org.netbeans.modules.soa.mappercore.graphics.Grid;
import org.netbeans.modules.soa.mappercore.graphics.VerticalGradient;
import org.netbeans.modules.soa.mappercore.graphics.XRange;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.ScrollPaneWrapper;
import org.netbeans.modules.soa.mappercore.utils.Utils;
import org.openide.actions.CopyAction;
import org.openide.util.NbBundle;

public class Canvas
extends MapperPanel
implements VertexCanvas,
FocusListener,
MapperSelectionListener,
Autoscroll {
    private CanvasEventHandler eventHandler;
    private double graphViewPositionX = 0.0;
    private CanvasScrollPane scrollPane;
    private ScrollPaneWrapper scrollPaneWrapper;
    private Grid grid = new Grid();
    private JLabel textRenderer;
    private CellRendererPane cellRendererPane;
    private VertexItemRenderer vertexItemRenderer = new DefaultVertexItemRenderer();
    private InplaceEditor inplaceEditor;
    private GraphSubset bufferCopyPaste;

    public Canvas(Mapper mapper) {
        super(mapper);
        this.putClientProperty("print.printable", Boolean.TRUE);
        this.putClientProperty("print.order", new Integer(1));
        this.setBackground(Mapper.CANVAS_BACKGROUND_COLOR);
        this.scrollPane = new CanvasScrollPane();
        this.scrollPane.getViewport().setScrollMode(0);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPaneWrapper = new ScrollPaneWrapper(this.scrollPane);
        this.addFocusListener(this);
        this.textRenderer = new JLabel();
        this.cellRendererPane = new CellRendererPane();
        this.cellRendererPane.add(this.textRenderer);
        this.add(this.cellRendererPane);
        this.eventHandler = new CanvasEventHandler(this);
        this.inplaceEditor = new InplaceEditor(this);
        this.getSelectionModel().addSelectionListener(this);
        this.registerAction(new StartInplaceEditor(this));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.registerAction(new MoveRightCanvasAction(this));
        this.registerAction(new MoveLeftCanvasAction(this));
        this.registerAction(new MoveUpCanvasAction(this));
        this.registerAction(new MoveDownCanvasAction(this));
        this.registerAction(new LinkConnectAction(this));
        this.registerAction(new CopyMapperAction(this));
        this.registerAction(new PasteMapperAction(this));
        this.registerAction(new CutMapperAction(this));
        this.registerAction(new DeleteMapperAction(this));
        this.registerAction(new ShowPopapMenuAction(this));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Canvas.class, (String)"ACSN_Canvas"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Canvas.class, (String)"ACSD_Canvas"));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        CanvasSearchResult canvasSearchResult = this.find(mouseEvent.getX(), mouseEvent.getY());
        if (canvasSearchResult == null) {
            return null;
        }
        if (canvasSearchResult.getPinItem() != null) {
            return null;
        }
        GraphItem graphItem = canvasSearchResult.getGraphItem();
        if (graphItem instanceof Vertex) {
            return ((Vertex)graphItem).getName();
        }
        if (graphItem instanceof VertexItem && (string = ((VertexItem)graphItem).getText()) != null && string.length() > 0) {
            return string;
        }
        if (graphItem instanceof Link) {
            return "Link";
        }
        return null;
    }

    public void registerAction(MapperKeyboardAction mapperKeyboardAction) {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        String string = mapperKeyboardAction.getActionKey();
        actionMap.put(string, mapperKeyboardAction);
        KeyStroke[] keyStrokeArray = mapperKeyboardAction.getShortcuts();
        if (keyStrokeArray != null) {
            for (KeyStroke keyStroke : keyStrokeArray) {
                inputMap.put(keyStroke, string);
            }
        }
    }

    public CanvasRendererContext getDefaultRendererContext() {
        return new DefaultCanvasRendererContext(this.getMapper());
    }

    public CanvasRendererContext getRendererContext() {
        LinkTool linkTool = this.getLinkTool();
        return linkTool.isActive() ? linkTool.getCanvasRendererContext() : this.getDefaultRendererContext();
    }

    public GraphSubset getBufferCopyPaste() {
        return this.bufferCopyPaste;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    JComponent getView() {
        return this.scrollPaneWrapper;
    }

    private int getGraphViewPositionX() {
        return this.getGraphViewPositionX(this.getStep());
    }

    private int getGraphViewPositionX(int n) {
        return (int)Math.round(this.graphViewPositionX * (double)n);
    }

    private void setGraphViewPositionX(int n) {
        this.setGraphViewPositionX(n, this.getStep());
    }

    private void setGraphViewPositionX(int n, int n2) {
        this.graphViewPositionX = (double)n / (double)n2;
    }

    JViewport getViewport() {
        return this.scrollPane.getViewport();
    }

    public void print(Graphics graphics) {
        Mapper mapper = this.getMapper();
        mapper.setPrintMode(true);
        super.print(graphics);
        mapper.setPrintMode(false);
    }

    protected void printComponent(Graphics graphics) {
        Mapper mapper = this.getMapper();
        MapperNode mapperNode = this.getRoot();
        if (mapperNode != null) {
            int n = this.getStep();
            int n2 = this.toGraph(0);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            DefaultCanvasRendererPrintContext defaultCanvasRendererPrintContext = new DefaultCanvasRendererPrintContext(mapper);
            this.paintNodeBackground(mapperNode, 0, graphics2D, defaultCanvasRendererPrintContext);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintNodeLinks(mapperNode, false, 0, graphics2D, defaultCanvasRendererPrintContext);
            this.paintNodeVerteces(mapperNode, false, 0, graphics2D, defaultCanvasRendererPrintContext);
            this.paintNodeLinks(mapperNode, true, 0, graphics2D, defaultCanvasRendererPrintContext);
            this.paintNodeVerteces(mapperNode, true, 0, graphics2D, defaultCanvasRendererPrintContext);
            graphics2D.dispose();
        }
    }

    public void setLocation(int n, int n2) {
        int n3 = this.getStep();
        this.setGraphViewPositionX(this.getGraphViewPositionX(n3) - n + this.getX(), n3);
        super.setLocation(n, n2);
    }

    public void setVertexItemRenderer(VertexItemRenderer vertexItemRenderer) {
        if (vertexItemRenderer == null) {
            vertexItemRenderer = new DefaultVertexItemRenderer();
        }
        if (vertexItemRenderer != this.vertexItemRenderer) {
            this.vertexItemRenderer = vertexItemRenderer;
        }
    }

    public void setBufferCopyPaste(GraphSubset graphSubset) {
        GraphSubset graphSubset2 = this.bufferCopyPaste;
        this.bufferCopyPaste = new GraphSubset(graphSubset);
        this.firePropertyChange("mapper-buffer-property", graphSubset2, this.bufferCopyPaste);
    }

    public VertexItemRenderer getVertexItemRenderer() {
        return this.vertexItemRenderer;
    }

    public void paintVertexItemText(TreePath treePath, VertexItem vertexItem, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Component component = this.vertexItemRenderer.getVertexItemRendererComponent(this.getMapper(), treePath, vertexItem);
        this.cellRendererPane.add(component);
        graphics2D.translate(n, n2);
        component.setBounds(0, 0, n3, n4);
        component.paint(graphics2D);
        graphics2D.translate(-n, -n2);
        this.cellRendererPane.remove(component);
    }

    public void setVertexItemEditor(Class clazz, VertexItemEditor vertexItemEditor) {
        this.inplaceEditor.setVertexItemEditor(clazz, vertexItemEditor);
    }

    public void setCustomVertexItemEditor(Class clazz, CustomVertexItemEditor customVertexItemEditor) {
        this.inplaceEditor.setCustomVertexItemEditor(clazz, customVertexItemEditor);
    }

    public VertexItemEditor getVertexItemEditor(Class clazz) {
        return this.inplaceEditor.getVertexItemEditor(clazz);
    }

    public CustomVertexItemEditor getCustomVertexItemEditor(Class clazz) {
        return this.inplaceEditor.getCustomVertexItemEditor(clazz);
    }

    public void startEdit(TreePath treePath, VertexItem vertexItem) {
        this.inplaceEditor.startEdit(treePath, vertexItem);
    }

    public int toGraph(int n) {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return n + this.getGraphViewPositionX() - rectangle.x - rectangle.width;
    }

    public int toCanvas(int n) {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return n - this.getGraphViewPositionX() + rectangle.x + rectangle.width;
    }

    public int toGraphY(int n) {
        MapperNode mapperNode = this.getNodeAt(n);
        int n2 = mapperNode.getY();
        while (mapperNode.getParent() != null) {
            mapperNode = mapperNode.getParent();
            n2 += mapperNode.getY();
        }
        return n2;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Mapper mapper = this.getMapper();
        mapper.resetRepaintSceduled();
        MapperNode mapperNode = this.getRoot();
        if (mapperNode != null) {
            int n = this.getStep();
            int n2 = this.toGraph(0);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            CanvasRendererContext canvasRendererContext = this.getRendererContext();
            this.paintNodeBackground(mapperNode, 0, graphics2D, canvasRendererContext);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintNodeLinks(mapperNode, false, 0, graphics2D, canvasRendererContext);
            this.paintNodeVerteces(mapperNode, false, 0, graphics2D, canvasRendererContext);
            this.paintNodeLinks(mapperNode, true, 0, graphics2D, canvasRendererContext);
            this.paintNodeVerteces(mapperNode, true, 0, graphics2D, canvasRendererContext);
            graphics2D.dispose();
        }
        this.getLinkTool().paintCanvas(this, graphics);
    }

    private void paintNodeBackground(MapperNode mapperNode, int n, Graphics2D graphics2D, CanvasRendererContext canvasRendererContext) {
        int n2;
        int n3 = mapperNode.getContentHeight();
        int n4 = mapperNode.getHeight();
        boolean bl = mapperNode.isLeaf();
        boolean bl2 = mapperNode.isExpanded();
        int n5 = canvasRendererContext.getStep();
        int n6 = canvasRendererContext.getCanvasVisibleMinX();
        int n7 = canvasRendererContext.getCanvasVisibleMaxX();
        int n8 = canvasRendererContext.getGraphX();
        if (canvasRendererContext.isSelected(mapperNode.getTreePath())) {
            VerticalGradient verticalGradient;
            VerticalGradient verticalGradient2 = verticalGradient = this.hasFocus() ? Mapper.SELECTED_BACKGROUND_IN_FOCUS : Mapper.SELECTED_BACKGROUND_NOT_IN_FOCUS;
            verticalGradient.paintGradient(this, graphics2D, n6, n, n7 - n6, (bl ? n4 : (bl2 ? n3 : n4)) - 1);
        }
        if (bl) {
            if (mapperNode.mustDrawLine()) {
                int n9 = n + n3 - 1;
                graphics2D.setPaint(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.drawLine(n6, n9, n7 - 1, n9);
            }
        } else if (bl2) {
            if (mapperNode.mustDrawLine()) {
                int n10 = n + n3 - 1;
                graphics2D.setPaint(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.drawLine(n6, n10, n7 - 1, n10);
            }
            int n11 = mapperNode.getChildCount();
            for (n2 = 0; n2 < n11; ++n2) {
                MapperNode mapperNode2 = mapperNode.getChild(n2);
                this.paintNodeBackground(mapperNode2, n + mapperNode2.getY(), graphics2D, canvasRendererContext);
            }
        } else if (mapperNode.mustDrawLine()) {
            int n12 = n + n3 - 1;
            n2 = n + mapperNode.getHeight() - 1;
            if (mapperNode.mustDrawDottedLine()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setPaint(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.setStroke(Mapper.DASHED_ROW_SEPARATOR_STROKE);
                graphics2D.drawLine(n6, n12, n7 - 1, n12);
                graphics2D.setStroke(stroke);
            }
            graphics2D.setPaint(Mapper.ROW_SEPARATOR_COLOR);
            graphics2D.drawLine(n6, n2, n7 - 1, n2);
        }
        if (mapperNode.isVisibleGraph() && !mapperNode.getGraph().isEmptyOrOneLink()) {
            int n13 = n5 - 1;
            n2 = n13 / 2;
            int n14 = n13 - n2;
            graphics2D.translate(n8, 0);
            this.grid.paintGrid(this, graphics2D, -n8, n + n2 + 1, this.getWidth(), n3 - n13 - 2, n5, !mapperNode.isSelected() && !this.getMapper().getPrintMode());
            graphics2D.translate(-n8, 0);
        }
    }

    void paintNodeLinks(MapperNode mapperNode, boolean bl, int n, Graphics2D graphics2D, CanvasRendererContext canvasRendererContext) {
        block20: {
            Object object;
            Iterator iterator;
            LeftTree leftTree;
            HashMap<Integer, Boolean> hashMap;
            int n2;
            Color color;
            Color color2;
            int n3;
            int n4;
            int n5;
            Mapper mapper;
            int n6;
            boolean bl2;
            block21: {
                bl2 = canvasRendererContext.isSelected(mapperNode.getTreePath());
                n6 = canvasRendererContext.getStep();
                mapper = this.getMapper();
                boolean bl3 = mapperNode.isLeaf();
                boolean bl4 = mapperNode.isExpanded();
                Graph graph = mapperNode.getGraph();
                int n7 = n + (n6 - 1) / 2 + 1;
                n5 = canvasRendererContext.getCanvasVisibleMinX();
                n4 = canvasRendererContext.getCanvasVisibleMaxX();
                n3 = canvasRendererContext.getCanvasVisibleCenterX();
                if (bl2) {
                    color2 = MapperStyle.LINK_COLOR_SELECTED_NODE;
                    color = MapperStyle.LINK_TCOLOR_SELECTED_NODE;
                } else {
                    color2 = MapperStyle.LINK_COLOR_UNSELECTED_NODE;
                    color = MapperStyle.LINK_TCOLOR_UNSELECTED_NODE;
                }
                if (graph != null && bl2 == bl) {
                    if (mapperNode.isGraphExpanded()) {
                        graph.paintLinks(graphics2D, mapperNode.getTreePath(), canvasRendererContext, n7);
                    } else {
                        Object object2;
                        n2 = n + mapperNode.getContentCenterY();
                        if (graph.hasOutgoingLinks()) {
                            object2 = graph.hasConnectedOutgoingLinks() ? color2 : new GradientPaint(n3, 0.0f, color, n4, 0.0f, color2);
                            Link.paintLine(graphics2D, (Paint)object2, null, n3, n2, n4, n2, n6, n5, n4);
                        }
                        if (graph.hasIngoingLinks()) {
                            Object object3;
                            object2 = graph.getIngoingLinks();
                            hashMap = new HashMap<Integer, Boolean>();
                            leftTree = mapper.getLeftTree();
                            iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                Link entry2 = (Link)iterator.next();
                                object3 = ((TreeSourcePin)entry2.getSource()).getTreePath();
                                int n8 = this.yFromMapper(leftTree.yToMapper(leftTree.getCenterY((TreePath)object3)));
                                object = (Boolean)hashMap.get(n8);
                                if (object == null) {
                                    hashMap.put(n8, graph.isConnectedIngoingLink(entry2));
                                    continue;
                                }
                                if (((Boolean)object).booleanValue() || !graph.isConnectedIngoingLink(entry2)) continue;
                                hashMap.put(n8, true);
                            }
                            for (Map.Entry entry : hashMap.entrySet()) {
                                object3 = (Boolean)entry.getValue() != false ? color2 : new GradientPaint(n5, 0.0f, color2, n3, 0.0f, color);
                                Link.paintLine(graphics2D, (Paint)object3, null, n5, (Integer)entry.getKey(), n3, n2, n6, n5, n4);
                            }
                        }
                    }
                }
                if (bl3) break block20;
                if (!bl4) break block21;
                n2 = mapperNode.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    hashMap = mapperNode.getChild(i);
                    this.paintNodeLinks((MapperNode)((Object)hashMap), bl, n + ((MapperNode)((Object)hashMap)).getY(), graphics2D, canvasRendererContext);
                }
                break block20;
            }
            if (bl != bl2) break block20;
            n2 = mapperNode.getHeight();
            int n9 = mapperNode.getContentHeight();
            if (n9 < n2) {
                Object object4;
                hashMap = mapperNode.getChildGraphs();
                leftTree = mapper.getLeftTree();
                iterator = new ArrayList();
                HashMap<Integer, Boolean> hashMap2 = new HashMap<Integer, Boolean>();
                int n10 = 0;
                Iterator iterator2 = hashMap.iterator();
                while (iterator2.hasNext()) {
                    object = (Graph)iterator2.next();
                    if (((Graph)object).hasConnectedOutgoingLinks()) {
                        n10 |= 3;
                    } else if (((Graph)object).hasOutgoingLinks()) {
                        n10 |= 1;
                    }
                    ((Graph)object).getIngoingLinks((List<Link>)((Object)iterator));
                    Iterator iterator3 = iterator.iterator();
                    while (iterator3.hasNext()) {
                        object4 = (Link)iterator3.next();
                        TreePath treePath = ((TreeSourcePin)((Link)object4).getSource()).getTreePath();
                        int n11 = this.yFromMapper(leftTree.yToMapper(leftTree.getCenterY(treePath)));
                        Boolean bl3 = (Boolean)hashMap2.get(n11);
                        if (bl3 == null) {
                            hashMap2.put(n11, ((Graph)object).isConnectedIngoingLink((Link)object4));
                            continue;
                        }
                        if (bl3.booleanValue() || !((Graph)object).isConnectedIngoingLink((Link)object4)) continue;
                        hashMap2.put(n11, true);
                    }
                    iterator.clear();
                }
                int n12 = n + (n9 + n2 - 1) / 2;
                if (n10 != 0) {
                    object = n10 == 3 ? color2 : new GradientPaint(n3, 0.0f, color, n4, 0.0f, color2);
                    Link.paintLine(graphics2D, (Paint)object, null, n3, n12, n4, n12, n6, n5, n4);
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    object4 = (Boolean)entry.getValue() != false ? color2 : new GradientPaint(n5, 0.0f, color2, n3, 0.0f, color);
                    Link.paintLine(graphics2D, (Paint)object4, null, n5, (Integer)entry.getKey(), n3, n12, n6, n5, n4);
                }
            }
        }
    }

    public CanvasSearchResult find(int n, int n2) {
        MapperNode mapperNode = this.getRoot();
        if (mapperNode == null) {
            return null;
        }
        CanvasRendererContext canvasRendererContext = this.getRendererContext();
        CanvasSearchResult canvasSearchResult = null;
        canvasSearchResult = this.findVertexOrVertexItem(n, n2, mapperNode, true, 0, canvasRendererContext);
        if (canvasSearchResult != null) {
            return canvasSearchResult;
        }
        canvasSearchResult = this.findLink(n, n2, mapperNode, true, 0, canvasRendererContext);
        if (canvasSearchResult != null) {
            return canvasSearchResult;
        }
        canvasSearchResult = this.findVertexOrVertexItem(n, n2, mapperNode, false, 0, canvasRendererContext);
        if (canvasSearchResult != null) {
            return canvasSearchResult;
        }
        canvasSearchResult = this.findLink(n, n2, mapperNode, false, 0, canvasRendererContext);
        if (canvasSearchResult != null) {
            return canvasSearchResult;
        }
        MapperNode mapperNode2 = this.getNodeAt(n2);
        if (mapperNode2 != null) {
            canvasSearchResult = new CanvasSearchResult(mapperNode2.getTreePath(), mapperNode2.getGraph(), null, null);
        }
        return canvasSearchResult;
    }

    private CanvasSearchResult findLink(int n, int n2, MapperNode mapperNode, boolean bl, int n3, CanvasRendererContext canvasRendererContext) {
        Graph graph;
        Object object;
        int n4;
        Mapper mapper = this.getMapper();
        CanvasSearchResult canvasSearchResult = null;
        int n5 = canvasRendererContext.getStep();
        int n6 = n3 + (n5 - 1) / 2 + 1;
        double d = 0.5 * (double)n5;
        if (!mapperNode.isLeaf() && mapperNode.isExpanded()) {
            int n7 = mapperNode.getChildCount();
            for (n4 = n7 - 1; n4 >= 0 && (canvasSearchResult = this.findLink(n, n2, (MapperNode)(object = mapperNode.getChild(n4)), bl, n3 + ((MapperNode)object).getY(), canvasRendererContext)) == null; --n4) {
            }
        }
        if (canvasSearchResult == null && mapperNode.isSelected() == bl && (graph = mapperNode.getGraph()) != null && mapperNode.isGraphExpanded()) {
            for (n4 = graph.getLinkCount() - 1; n4 >= 0; --n4) {
                object = graph.getLink(n4);
                if (!(((Link)object).distance(n, n2, canvasRendererContext, n6) <= d)) continue;
                canvasSearchResult = new CanvasSearchResult(mapperNode.getTreePath(), graph, (GraphItem)object, null);
                break;
            }
        }
        return canvasSearchResult;
    }

    private CanvasSearchResult findVertexOrVertexItem(int n, int n2, MapperNode mapperNode, boolean bl, int n3, CanvasRendererContext canvasRendererContext) {
        int n4;
        TreePath treePath = mapperNode.getTreePath();
        CanvasSearchResult canvasSearchResult = null;
        int n5 = canvasRendererContext.getStep();
        int n6 = n3 + (n5 - 1) / 2 + 1;
        Graph graph = mapperNode.getGraph();
        if (graph != null && mapperNode.isGraphExpanded() && mapperNode.isSelected() == bl) {
            n4 = n - canvasRendererContext.getGraphX();
            int n7 = n2 - n6;
            for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
                Link link;
                VertexItem vertexItem;
                int n8;
                Vertex vertex = graph.getVertex(i);
                if (vertex.dontContains(n4, n7, n5)) continue;
                if (vertex instanceof Constant) {
                    for (n8 = vertex.getItemCount() - 1; n8 >= 0; --n8) {
                        vertexItem = vertex.getItem(n8);
                        if (vertexItem.isHairline() || !vertexItem.contains(n4, n7, n5)) continue;
                        canvasSearchResult = new CanvasSearchResult(treePath, graph, vertexItem, null);
                        break;
                    }
                } else if (vertex instanceof Operation) {
                    for (n8 = vertex.getItemCount() - 1; n8 >= 0; --n8) {
                        vertexItem = vertex.getItem(n8);
                        if (!vertexItem.targetPinContains(n4, n7, n5)) continue;
                        link = vertexItem.getIngoingLink();
                        canvasSearchResult = new CanvasSearchResult(treePath, graph, link != null ? link : vertexItem, vertexItem);
                        break;
                    }
                } else {
                    for (n8 = vertex.getItemCount() - 1; n8 >= 0; --n8) {
                        vertexItem = vertex.getItem(n8);
                        if (vertexItem.targetPinContains(n4, n7, n5)) {
                            link = vertexItem.getIngoingLink();
                            canvasSearchResult = new CanvasSearchResult(treePath, graph, link != null ? link : vertexItem, vertexItem);
                        } else {
                            if (vertexItem.isHairline() || !vertexItem.contains(n4, n7, n5)) continue;
                            canvasSearchResult = new CanvasSearchResult(treePath, graph, vertexItem, null);
                        }
                        break;
                    }
                }
                if (canvasSearchResult != null) break;
                if (vertex.contains(n4, n7, n5)) {
                    canvasSearchResult = new CanvasSearchResult(treePath, graph, vertex, null);
                } else if (vertex.sourcePinContains(n4, n7, n5)) {
                    Link link2 = vertex.getOutgoingLink();
                    canvasSearchResult = new CanvasSearchResult(treePath, graph, link2 != null ? link2 : vertex, vertex);
                }
                if (canvasSearchResult != null) break;
            }
        }
        if (canvasSearchResult == null && !mapperNode.isLeaf() && mapperNode.isExpanded()) {
            MapperNode mapperNode2;
            for (n4 = mapperNode.getChildCount() - 1; n4 >= 0 && (canvasSearchResult = this.findVertexOrVertexItem(n, n2, mapperNode2 = mapperNode.getChild(n4), bl, n3 + mapperNode2.getY(), canvasRendererContext)) == null; --n4) {
            }
        }
        return canvasSearchResult;
    }

    void paintNodeVerteces(MapperNode mapperNode, boolean bl, int n, Graphics2D graphics2D, CanvasRendererContext canvasRendererContext) {
        boolean bl2 = Utils.equal(this.getSelectionModel().getSelectedPath(), mapperNode.getTreePath());
        int n2 = canvasRendererContext.getStep();
        boolean bl3 = mapperNode.isLeaf();
        boolean bl4 = mapperNode.isExpanded();
        Graph graph = mapperNode.getGraph();
        int n3 = n + (n2 - 1) / 2 + 1;
        if (graph != null && mapperNode.isGraphExpanded() && bl == bl2) {
            graph.paintVerteces(graphics2D, mapperNode.getTreePath(), canvasRendererContext, n3);
        }
        if (!bl3 && bl4) {
            int n4 = mapperNode.getChildCount();
            for (int i = 0; i < n4; ++i) {
                MapperNode mapperNode2 = mapperNode.getChild(i);
                this.paintNodeVerteces(mapperNode2, bl, n + mapperNode2.getY(), graphics2D, canvasRendererContext);
            }
        }
    }

    public Rectangle getPreferredGraphBounds() {
        JViewport jViewport = this.getViewport();
        Mapper mapper = this.getMapper();
        int n = this.getStep();
        int n2 = this.getGraphViewPositionX(n);
        Dimension dimension = mapper.getPreferredTreeSize();
        if (dimension == null) {
            return new Rectangle(n2 - 10, 0, 10, 10);
        }
        XRange xRange = mapper.getGraphXRange();
        if (xRange == null) {
            return new Rectangle(n2 - 10, 0, 10, dimension.height);
        }
        int n3 = xRange.x * n;
        int n4 = xRange.width * n;
        int n5 = jViewport.getExtentSize().width;
        int n6 = Math.max(100, n5 - n4);
        int n7 = Math.min(n3 - n6, n2 - n5 - 100);
        int n8 = Math.max(n3 + n4 + n6, n2 + 100);
        return new Rectangle(n7, 0, n8 - n7, dimension.height);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    private MapperNode getNode(int n) {
        MapperNode mapperNode = this.getRoot();
        return mapperNode == null ? null : mapperNode.getNode(n);
    }

    public void doLayout() {
        this.cellRendererPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.inplaceEditor.layoutEditor();
    }

    public JLabel getTextRenderer() {
        return this.textRenderer;
    }

    public int getY() {
        if (this.getMapper().getPrintMode()) {
            return 0;
        }
        return super.getY();
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return new Insets(rectangle.y + 16, rectangle.x + 16, this.getHeight() - rectangle.y - rectangle.height + 16, this.getWidth() - rectangle.x - rectangle.width + 16);
    }

    public void autoscroll(Point point) {
        if (this.scrollPane.getViewport() == null) {
            return;
        }
        Insets insets = this.getAutoscrollInsets();
        Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
        if (point.y > this.getHeight() - insets.bottom) {
            rectangle.y = this.getHeight() - insets.bottom + 16 + 2 * this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.y < insets.top) {
            rectangle.y = insets.top - 16 - 2 * this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.x > this.getWidth() - insets.right) {
            rectangle.x = this.getWidth() - insets.right + 16 + 2 * this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        if (point.x < insets.left) {
            rectangle.x = insets.left - 16 - 2 * this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        this.scrollRectToVisible(rectangle);
    }

    public void mapperSelectionChanged(MapperSelectionEvent mapperSelectionEvent) {
        List<Vertex> list = this.getSelectionModel().getSelectedVerteces();
        if (list == null || list.size() == 0) {
            return;
        }
        Vertex vertex = list.get(0);
        int n = this.getGraphViewPositionX();
        int n2 = this.getScrollPane().getViewport().getWidth();
        int n3 = n;
        int n4 = n - n2;
        int n5 = this.getStep();
        int n6 = vertex.getWidth() * n5;
        int n7 = vertex.getX() * n5;
        int n8 = n7 + n6;
        n7 -= 2 * n5;
        if ((n8 += 2 * n5) > n3) {
            n3 = n8;
            n4 = n8 - n2;
        }
        if (n7 < n4) {
            n4 = n7;
            n3 = n7 + n2;
        }
        if (n3 != n) {
            this.setGraphViewPositionX(n3);
            this.invalidate();
            this.getScrollPane().validate();
            this.repaint();
        }
    }

    private class Copy
    extends CopyAction {
        private Copy() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            System.out.println("123445**************");
        }
    }

    private class CanvasViewportLayout
    implements LayoutManager {
        private CanvasViewportLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(32, 32);
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(32, 32);
        }

        public void layoutContainer(Container container) {
            JViewport jViewport = (JViewport)container;
            int n = Canvas.this.getStep();
            Rectangle rectangle = Canvas.this.getPreferredGraphBounds();
            Dimension dimension = rectangle.getSize();
            int n2 = jViewport.getWidth();
            int n3 = jViewport.getHeight();
            int n4 = Canvas.this.getGraphViewPositionX(n);
            dimension.width = Math.max(dimension.width, n2);
            dimension.height = Math.max(dimension.height, n3);
            Point point = jViewport.getViewPosition();
            point.x = Math.max(0, Math.min(n4 - n2 - rectangle.x, dimension.width - n2));
            point.y = Math.max(0, Math.min(point.y, dimension.height - n3));
            jViewport.setViewSize(dimension);
            jViewport.setViewPosition(point);
            Canvas.this.setGraphViewPositionX(n4, n);
        }
    }

    private class CanvasScrollPane
    extends JScrollPane
    implements AdjustmentListener {
        public CanvasScrollPane() {
            super(Canvas.this, 21, 32);
            this.getViewport().setLayout(new CanvasViewportLayout());
            this.getHorizontalScrollBar().addAdjustmentListener(this);
        }

        public void doLayout() {
            int n = Canvas.this.getStep();
            JScrollBar jScrollBar = this.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.getVerticalScrollBar();
            JViewport jViewport = this.getViewport();
            jScrollBar.setVisible(true);
            jScrollBar2.setVisible(false);
            Insets insets = this.getInsets();
            int n2 = Canvas.this.getGraphViewPositionX(n);
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = Math.max(0, this.getWidth() - insets.left - insets.right);
            int n6 = Math.max(0, this.getHeight() - insets.top - insets.bottom);
            int n7 = Math.min(jScrollBar.getPreferredSize().height, n6);
            jScrollBar.setBounds(n3, n4 + (n6 -= n7), n5, n7);
            Border border = this.getViewportBorder();
            if (border != null) {
                insets = border.getBorderInsets(this);
                n3 += insets.left;
                n4 += insets.top;
                n5 = Math.max(0, n5 - insets.left - insets.right);
                n6 = Math.max(0, n6 - insets.top - insets.bottom);
            }
            jViewport.setBounds(n3, n4, n5, n6);
            Canvas.this.setGraphViewPositionX(n2, n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(32, 32);
        }

        public Dimension getMinimumSize() {
            return new Dimension(32, 32);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!adjustmentEvent.getValueIsAdjusting()) {
                Canvas.this.revalidate();
                Canvas.this.repaint();
            }
        }
    }
}

