/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredTreeModel
implements TreeModel,
TreeModelListener {
    private TreeModel treeModel;
    private Map<Object, List<Object>> childrenMap = new HashMap<Object, List<Object>>();
    private List<TreeModelListener> listeners;
    private HashMap<Object, Set<Object>> insertedChildrenMap = new HashMap();
    private boolean filter;

    public FilteredTreeModel(TreeModel treeModel, boolean bl) {
        this.filter = bl;
        this.treeModel = treeModel;
        treeModel.addTreeModelListener(this);
    }

    @Override
    public Object getRoot() {
        return this.treeModel == null ? null : this.treeModel.getRoot();
    }

    protected abstract boolean accept(Object var1, Object var2);

    private boolean isInsertedChild(Object object, Object object2) {
        Set<Object> set = this.insertedChildrenMap.get(object);
        return set != null && set.contains(object2);
    }

    private List<Object> getChildren(Object object) {
        List<Object> list = this.childrenMap.get(object);
        if (list == null) {
            list = new ArrayList<Object>();
            int n = this.treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = this.treeModel.getChild(object, i);
                if (!this.accept(object, object2) && !this.isInsertedChild(object, object2)) continue;
                list.add(object2);
            }
            this.childrenMap.put(object, list);
        }
        return list;
    }

    private void registerInsertedChildren(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        Object object = treePath.getLastPathComponent();
        Set<Object> set = this.insertedChildrenMap.get(object);
        if (set == null) {
            set = new HashSet<Object>();
            this.insertedChildrenMap.put(object, set);
        }
        for (Object object2 : objectArray) {
            set.add(object2);
        }
    }

    private void resetChildren(Object object) {
        this.childrenMap.remove(object);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.filter ? this.getChildren(object).get(n) : this.treeModel.getChild(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        if (this.filter) {
            List<Object> list = this.getChildren(object);
            return list == null ? 0 : list.size();
        }
        return this.treeModel.getChildCount(object);
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.treeModel.isLeaf(object);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        if (this.treeModel != null) {
            this.treeModel.valueForPathChanged(treePath, object);
        }
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (this.filter) {
            List<Object> list = this.getChildren(object);
            return list == null ? -1 : list.indexOf(object2);
        }
        return this.treeModel.getIndexOfChild(object, object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TreeModelListener>();
        }
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.lastIndexOf(treeModelListener);
        if (n >= 0) {
            this.listeners.remove(n);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    private boolean hasListeners() {
        return this.listeners != null;
    }

    private TreeModelListener[] getListeners() {
        return this.listeners == null ? null : this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
    }

    private TreeModelEvent filterTreeModelEvent(TreeModelEvent treeModelEvent) {
        Object object;
        int n;
        if (!this.filter) {
            return new TreeModelEvent((Object)this, treeModelEvent.getTreePath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = treeModelEvent.getPath();
        if (objectArray2 == null) {
            return null;
        }
        List<Object> list = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object2 = objectArray2[i];
            if (this.isLeaf(object2)) {
                return null;
            }
            if (list != null && !list.contains(object2)) {
                return null;
            }
            list = this.getChildren(object2);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (!list.contains(object)) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        n = arrayList.size();
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            object[i] = list.indexOf(arrayList.get(i));
        }
        return new TreeModelEvent((Object)this, treeModelEvent.getTreePath(), (int[])object, arrayList.toArray(new Object[n]));
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (!this.hasListeners()) {
            return;
        }
        TreeModelEvent treeModelEvent2 = this.filterTreeModelEvent(treeModelEvent);
        if (treeModelEvent2 != null) {
            TreeModelListener[] treeModelListenerArray = this.getListeners();
            for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
                treeModelListenerArray[i].treeNodesChanged(treeModelEvent2);
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.resetChildren(treeModelEvent.getTreePath().getLastPathComponent());
        this.registerInsertedChildren(treeModelEvent);
        if (!this.hasListeners()) {
            return;
        }
        TreeModelEvent treeModelEvent2 = this.filterTreeModelEvent(treeModelEvent);
        if (treeModelEvent2 != null) {
            TreeModelListener[] treeModelListenerArray = this.getListeners();
            for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
                treeModelListenerArray[i].treeNodesInserted(treeModelEvent2);
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (!this.hasListeners()) {
            return;
        }
        TreeModelEvent treeModelEvent2 = this.filterTreeModelEvent(treeModelEvent);
        if (treeModelEvent2 != null) {
            TreeModelListener[] treeModelListenerArray = this.getListeners();
            for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
                treeModelListenerArray[i].treeNodesRemoved(treeModelEvent2);
            }
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        int n;
        Object object;
        Object object2;
        if (!this.hasListeners()) {
            return;
        }
        if (this.filter) {
            object2 = treeModelEvent.getPath();
            object = null;
            for (n = 0; n < ((Object[])object2).length; ++n) {
                Object object3 = object2[n];
                if (object != null && !object.contains(object3)) {
                    return;
                }
                object = this.getChildren(object3);
            }
        }
        object2 = new TreeModelEvent((Object)this, treeModelEvent.getTreePath());
        object = this.getListeners();
        for (n = ((TreeModelListener[])object).length - 1; n >= 0; --n) {
            object[n].treeStructureChanged((TreeModelEvent)object2);
        }
    }

    public void dispose() {
        this.treeModel.removeTreeModelListener(this);
    }
}

