/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public class LinkToolCanvasRendererContext
implements CanvasRendererContext {
    private LinkTool linkTool;
    private CanvasRendererContext defaultContext;

    public LinkToolCanvasRendererContext(LinkTool linkTool) {
        this.defaultContext = linkTool.getCanvas().getDefaultRendererContext();
        this.linkTool = linkTool;
    }

    private CanvasRendererContext getDefaultRendererContext() {
        return this.defaultContext;
    }

    public JLabel getTextRenderer() {
        return this.defaultContext.getTextRenderer();
    }

    public boolean isSelected(TreePath treePath) {
        return this.defaultContext.isSelected(treePath);
    }

    public boolean isSelected(TreePath treePath, GraphItem graphItem) {
        return this.defaultContext.isSelected(treePath, graphItem);
    }

    public boolean paintVertex(TreePath treePath, Vertex vertex) {
        return true;
    }

    public boolean paintLink(TreePath treePath, Link link) {
        if (link != this.linkTool.getOldLink()) {
            return true;
        }
        return !Utils.equal(treePath, this.linkTool.getOldTreePath());
    }

    public boolean paintVertexItemPin(TreePath treePath, VertexItem vertexItem) {
        return this.linkTool.getActivePins().contains(treePath, vertexItem) && this.linkTool.getTargetPin() != vertexItem;
    }

    public boolean paintVertexPin(TreePath treePath, Vertex vertex) {
        return this.linkTool.getActivePins().contains(treePath, vertex) && this.linkTool.getSourcePin() != vertex;
    }

    public int getStep() {
        return this.defaultContext.getStep();
    }

    public Mapper getMapper() {
        return this.defaultContext.getMapper();
    }

    public Canvas getCanvas() {
        return this.defaultContext.getCanvas();
    }

    public LeftTree getLeftTree() {
        return this.defaultContext.getLeftTree();
    }

    public RightTree getRightTree() {
        return this.defaultContext.getRightTree();
    }

    public int getCanvasVisibleMinX() {
        return this.defaultContext.getCanvasVisibleMinX();
    }

    public int getCanvasVisibleMaxX() {
        return this.defaultContext.getCanvasVisibleMaxX();
    }

    public int getGraphX() {
        return this.defaultContext.getGraphX();
    }

    public int getCanvasVisibleCenterX() {
        return this.defaultContext.getCanvasVisibleCenterX();
    }
}

