/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.graphics.XRange;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphListener;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.utils.MapperTreePath;
import org.netbeans.modules.soa.mappercore.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapperNode
implements GraphListener {
    private Mapper mapper;
    private boolean collapsed;
    private boolean leaf;
    private Object value;
    private MapperNode parent;
    private List<MapperNode> children;
    private int y;
    private int indent;
    private int height;
    private int contentHeight;
    private int labelWidth;
    private int labelHeight;
    private String text;
    private Icon icon;
    private boolean valid = false;
    private Graph graph;
    private boolean graphCollapsed = false;
    private Set<Graph> childGraphs;
    private TreePath treePath;

    public MapperNode(Mapper mapper, MapperNode mapperNode, Object object) {
        this.value = object;
        this.mapper = mapper;
        this.parent = mapperNode;
        this.collapsed = mapperNode != null;
        this.treePath = mapperNode == null ? new TreePath(object) : new MapperTreePath(mapperNode.getTreePath(), object);
        this.updateNode();
        this.updateChildGraphs();
    }

    private Mapper getMapper() {
        return this.mapper;
    }

    private RightTree getRightTree() {
        return this.mapper.getRightTree();
    }

    private MapperModel getModel() {
        return this.mapper.getFilteredModel();
    }

    MapperNode getParent() {
        return this.parent;
    }

    Object getValue() {
        return this.value;
    }

    boolean isDnDSelected() {
        return Utils.equal(this.mapper.getSelectedDndPath(), this.treePath);
    }

    boolean isSelected() {
        return Utils.equal(this.mapper.getSelected(), this.treePath);
    }

    boolean isLeaf() {
        return this.leaf;
    }

    boolean isCollapsed() {
        return this.collapsed;
    }

    boolean isExpanded() {
        return !this.collapsed;
    }

    boolean isGraphCollapsed() {
        return this.graphCollapsed;
    }

    boolean isGraphExpanded() {
        return !this.graphCollapsed;
    }

    int getY() {
        return this.y;
    }

    int getHeight() {
        return this.height;
    }

    int getIndent() {
        return this.indent;
    }

    int getContentHeight() {
        return this.contentHeight;
    }

    int getContentCenterY() {
        return (this.contentHeight - 1) / 2;
    }

    boolean isValid() {
        return this.valid;
    }

    boolean isLoaded() {
        return this.leaf || this.children != null;
    }

    int getLabelWidth() {
        return this.labelWidth;
    }

    int getLabelHeight() {
        return this.labelHeight;
    }

    Graph getGraph() {
        return this.graph;
    }

    Set<Graph> getChildGraphs() {
        return this.getChildGraphs(null);
    }

    Set<Graph> getChildGraphs(Set<Graph> set) {
        if (set == null) {
            set = new HashSet<Graph>();
        }
        if (this.childGraphs != null) {
            set.addAll(this.childGraphs);
        }
        return set;
    }

    MapperNode getNode(int n) {
        if (n < 0 || n >= this.height) {
            return null;
        }
        if (this.isLeaf()) {
            return this;
        }
        if (n >= this.contentHeight && !this.isCollapsed()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                MapperNode mapperNode = this.getChild(i);
                MapperNode mapperNode2 = mapperNode.getNode(n - mapperNode.getY());
                if (mapperNode2 == null) continue;
                return mapperNode2;
            }
        }
        return this;
    }

    TreePath getTreePath() {
        return this.treePath;
    }

    int yToNode(int n) {
        for (MapperNode mapperNode = this; mapperNode != null; mapperNode = mapperNode.getParent()) {
            n -= mapperNode.getY();
        }
        return n;
    }

    int yToView(int n) {
        for (MapperNode mapperNode = this; mapperNode != null; mapperNode = mapperNode.getParent()) {
            n += mapperNode.getY();
        }
        return n;
    }

    void setCollapsed(boolean bl) {
        if (this.collapsed != bl) {
            this.collapsed = bl;
            this.updateChildGraphs();
            this.invalidate();
            this.getMapper().repaint();
        }
    }

    void setExpanded(boolean bl) {
        this.setCollapsed(!bl);
    }

    void setGraphCollapsed(boolean bl) {
        if (this.graphCollapsed != bl) {
            this.graphCollapsed = bl;
            this.invalidate();
            this.getMapper().repaint();
        }
    }

    void setGraphExpanded(boolean bl) {
        this.setGraphCollapsed(!bl);
    }

    int getChildCount() {
        this.loadChildren();
        return this.leaf ? 0 : this.children.size();
    }

    MapperNode getChild(int n) {
        this.loadChildren();
        return this.children.get(n);
    }

    int getChildIndex(MapperNode mapperNode) {
        if (!this.isLoaded()) {
            return -1;
        }
        return this.children.indexOf(mapperNode);
    }

    private void loadChildren() {
        if (this.isLoaded()) {
            return;
        }
        this.updateChildren();
    }

    void updateNode() {
        MapperModel mapperModel = this.getModel();
        boolean bl = this.leaf;
        this.leaf = mapperModel.isLeaf(this.value);
        if (bl != this.leaf) {
            this.removeAllChildren();
        }
        Graph graph = this.graph;
        this.graph = mapperModel.getGraph(this.getTreePath());
        if (graph != this.graph) {
            if (graph != null) {
                graph.removeGraphListener(this);
            }
            if (this.graph != null) {
                this.graph.addGraphListener(this);
            }
        }
    }

    void updateChildGraphs() {
        MapperModel mapperModel = this.getModel();
        HashSet<Graph> hashSet = new HashSet<Graph>();
        Set<Graph> set = new HashSet<Graph>();
        if (this.childGraphs != null) {
            hashSet.addAll(this.childGraphs);
        }
        if (!this.leaf && this.collapsed || this.parent == null && !this.leaf) {
            set = Utils.findGraphs(mapperModel, this.getTreePath(), set);
        }
        if (set != null && !set.isEmpty()) {
            if (this.childGraphs != null) {
                this.childGraphs.clear();
            } else {
                this.childGraphs = new HashSet<Graph>();
            }
            this.childGraphs.addAll(set);
        } else {
            this.childGraphs = null;
        }
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.retainAll(set);
        hashSet.removeAll(hashSet2);
        set.removeAll(hashSet2);
        for (Graph graph : hashSet) {
            graph.removeGraphListener(this);
        }
        for (Graph graph : set) {
            graph.addGraphListener(this);
        }
        if (!hashSet.isEmpty() || !set.isEmpty()) {
            this.invalidate();
            this.repaint();
        }
    }

    private void removeAllChildren() {
        if (this.children != null) {
            for (MapperNode mapperNode : this.children) {
                mapperNode.removeNode();
            }
        }
    }

    private void removeNode() {
        if (this.graph != null) {
            this.graph.removeGraphListener(this);
            this.graph = null;
        }
        if (this.childGraphs != null) {
            for (Graph graph : this.childGraphs) {
                graph.removeGraphListener(this);
            }
            this.childGraphs.clear();
            this.childGraphs = null;
        }
        this.removeAllChildren();
    }

    void updateChildren() {
        MapperModel mapperModel = this.mapper.getFilteredModel();
        List<Object> list = Collections.emptyList();
        if (this.children != null) {
            list = this.children;
        }
        int n = mapperModel.getChildCount(this.value);
        ArrayList<MapperNode> arrayList = new ArrayList<MapperNode>(n);
        for (int i = 0; i < n; ++i) {
            Object object = mapperModel.getChild(this.value, i);
            MapperNode mapperNode = null;
            for (int j = 0; j < list.size(); ++j) {
                if (((MapperNode)list.get(j)).getValue() != object) continue;
                mapperNode = (MapperNode)list.remove(j);
                break;
            }
            if (mapperNode == null) {
                mapperNode = new MapperNode(this.mapper, this, object);
            }
            arrayList.add(i, mapperNode);
        }
        this.children = arrayList;
    }

    void insertChildren(TreeModelEvent treeModelEvent) {
        if (this.isLoaded()) {
            MapperModel mapperModel = this.getModel();
            int[] nArray = treeModelEvent.getChildIndices();
            Arrays.sort(nArray);
            for (int n : nArray) {
                if (this.children == null) {
                    this.children = new ArrayList<MapperNode>();
                }
                this.children.add(n, new MapperNode(this.mapper, this, mapperModel.getChild(this.value, n)));
            }
        }
    }

    void removeChildren(TreeModelEvent treeModelEvent) {
        if (this.isLoaded()) {
            int[] nArray = treeModelEvent.getChildIndices();
            Arrays.sort(nArray);
            for (int n : nArray) {
                this.children.remove(n);
            }
        }
    }

    void validate() {
        if (this.valid) {
            return;
        }
        this.layout();
        if (this.isLoaded()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                this.getChild(i).validate();
            }
        }
        this.valid = true;
    }

    void invalidate() {
        if (this.valid) {
            this.valid = false;
            MapperNode mapperNode = this.getParent();
            if (mapperNode != null) {
                mapperNode.invalidate();
            } else {
                this.mapper.invalidateNodes();
            }
        }
    }

    void invalidateTree() {
        this.invalidate();
        if (this.isLoaded()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                this.getChild(i).invalidate();
            }
        }
    }

    void repaint() {
        this.mapper.repaintNodes();
    }

    void layout() {
        int n = this.getHeight();
        int n2 = this.getIndent();
        int n3 = n2 + this.mapper.getTotalIndent();
        Dimension dimension = this.getLabelSize();
        if (this.parent == null) {
            this.contentHeight = 0;
        } else {
            this.contentHeight = Math.max(dimension.height + 4, this.getGraphHeight()) + 1;
            this.labelHeight = dimension.height;
            this.labelWidth = dimension.width;
        }
        int n4 = this.contentHeight;
        if (!this.isLeaf() && this.isExpanded()) {
            int n5 = this.getChildCount();
            for (int i = 0; i < n5; ++i) {
                MapperNode mapperNode = this.getChild(i);
                int n6 = mapperNode.getPreferredHeight();
                mapperNode.setBounds(n4, n6, n3);
                n4 += n6;
            }
        }
    }

    int getPreferredHeight() {
        return this.getPreferredSize().height;
    }

    Dimension getPreferredSize() {
        Dimension dimension = this.getLabelSize();
        int n = dimension.width;
        int n2 = this.getParent() == null ? 0 : Math.max(this.getGraphHeight(), dimension.height + 4) + 1;
        int n3 = this.mapper.getTotalIndent();
        if (!this.isLeaf()) {
            if (this.isExpanded()) {
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    Dimension dimension2 = this.getChild(i).getPreferredSize();
                    n = Math.max(n, dimension2.width + n3);
                    n2 += dimension2.height;
                }
            } else if (this.hasNonEmptyChildGraphs()) {
                Dimension dimension3 = this.getChildrenLabelSize();
                n2 += dimension3.height + 3;
                n = Math.max(n, dimension3.width + n3);
            }
        }
        return new Dimension(n, n2);
    }

    private boolean hasNonEmptyChildGraphs() {
        if (this.childGraphs != null) {
            for (Graph graph : this.childGraphs) {
                if (graph.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    XRange getGraphXRange() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        if (this.graph != null && this.isGraphExpanded()) {
            n = this.graph.getX();
            n2 = n + this.graph.getWidth();
        }
        if (!this.isLeaf() && this.isExpanded()) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                XRange xRange = this.getChild(i).getGraphXRange();
                if (xRange == null) continue;
                n = Math.min(n, xRange.x);
                n2 = Math.max(n2, xRange.x + xRange.width);
            }
        }
        return n <= n2 ? new XRange(n, n2 - n) : null;
    }

    boolean isVisibleGraph() {
        if (this.graph == null) {
            return false;
        }
        if (this.graph.isEmpty()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.isGraphExpanded();
    }

    private boolean isVisible() {
        if (this == this.getMapper().getRoot()) {
            return true;
        }
        if (this.getParent().isCollapsed()) {
            return false;
        }
        return this.getParent().isVisible();
    }

    int getGraphHeight() {
        int n = this.mapper.getStepSize();
        int n2 = n - 1;
        int n3 = n2 / 2;
        int n4 = n2 - n3;
        return this.isVisibleGraph() && !this.getGraph().isEmptyOrOneLink() ? Math.max(2, this.graph.getHeight()) * n + n2 + 2 : 0;
    }

    Dimension getLabelSize() {
        Dimension dimension = this.getRightTree().getCellRendererComponent(this).getPreferredSize();
        return new Dimension(Math.max(16, dimension.width), Math.max(16, dimension.height));
    }

    Dimension getChildrenLabelSize() {
        return this.mapper.getRightTree().getChildrenLabel().getPreferredSize();
    }

    void setBounds(int n, int n2, int n3) {
        this.y = n;
        if (this.height != n2 || this.indent != n3) {
            this.indent = n3;
            this.height = n2;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean mustDrawLine() {
        if (this.getParent() == null) {
            return false;
        }
        MapperNode mapperNode = this.getNextVisibleNode(this);
        if (this.getGraph() != null && !this.getGraph().isEmptyOrOneLink() || mapperNode != null && mapperNode.getGraph() != null && !mapperNode.getGraph().isEmptyOrOneLink()) {
            return true;
        }
        if (this.isSelected() || mapperNode != null && mapperNode.isSelected() || this.isDnDSelected() || mapperNode != null && mapperNode.isDnDSelected()) {
            return true;
        }
        return this.isCollapsed() && this.getHeight() != this.getContentHeight() || mapperNode != null && mapperNode.isCollapsed() && mapperNode.getHeight() != mapperNode.getContentHeight();
    }

    public boolean mustDrawDottedLine() {
        return this.isCollapsed() && this.getHeight() != this.getContentHeight();
    }

    public MapperNode getNextVisibleNode() {
        return this.getNextVisibleNode(this);
    }

    public MapperNode getPrevVisibleNode() {
        return this.getPrevVisibleNode(this);
    }

    private MapperNode getPrevVisibleNode(MapperNode mapperNode) {
        if (mapperNode == this.mapper.getRoot()) {
            return null;
        }
        if (mapperNode == this) {
            int n = mapperNode.getParent().getChildIndex(mapperNode);
            if (n > 0) {
                if (mapperNode.getParent().getChild(n - 1).isCollapsed() || mapperNode.getParent().getChild(n - 1).isLeaf()) {
                    return mapperNode.getParent().getChild(n - 1);
                }
                return this.getPrevVisibleNode(mapperNode.getParent().getChild(n - 1));
            }
            return mapperNode.getParent();
        }
        if (mapperNode.getChild(mapperNode.getChildCount() - 1).isLeaf() || mapperNode.getChild(mapperNode.getChildCount() - 1).isCollapsed()) {
            return mapperNode.getChild(mapperNode.getChildCount() - 1);
        }
        return this.getPrevVisibleNode(mapperNode.getChild(mapperNode.getChildCount() - 1));
    }

    private MapperNode getNextVisibleNode(MapperNode mapperNode) {
        int n;
        int n2;
        MapperNode mapperNode2 = this.mapper.getRoot();
        if (mapperNode == mapperNode2 && (mapperNode != this || mapperNode2.isLeaf() || mapperNode2.isCollapsed() || mapperNode2.getChildCount() < 1)) {
            return null;
        }
        MapperNode mapperNode3 = null;
        mapperNode3 = mapperNode.isCollapsed() || mapperNode.isLeaf() ? ((n2 = mapperNode.getParent().getChildIndex(mapperNode)) + 1 < mapperNode.getParent().getChildCount() ? mapperNode.getParent().getChild(n2 + 1) : this.getNextVisibleNode(mapperNode.getParent())) : (mapperNode == this && mapperNode.getChildCount() > 0 ? mapperNode.getChild(0) : ((n = mapperNode.getParent().getChildIndex(mapperNode)) + 1 < mapperNode.getParent().getChildCount() ? mapperNode.getParent().getChild(n + 1) : this.getNextVisibleNode(mapperNode.getParent())));
        return mapperNode3;
    }

    @Override
    public void graphBoundsChanged(Graph graph) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void graphLinksChanged(Graph graph) {
        this.getRightTree().getLeftTree().repaint();
        this.repaint();
    }

    @Override
    public void graphContentChanged(Graph graph) {
        this.repaint();
    }
}

