/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class MoveDownCanvasAction
extends MapperKeyboardAction {
    public MoveDownCanvasAction(Canvas canvas) {
        super(canvas);
    }

    public String getActionKey() {
        return "press-move-down-action";
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(40, 192)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        Object object2;
        SelectionModel selectionModel = this.canvas.getSelectionModel();
        TreePath treePath = selectionModel.getSelectedPath();
        if (treePath == null) {
            return;
        }
        Mapper mapper = this.canvas.getMapper();
        Graph graph = selectionModel.getSelectedGraph();
        if (graph == null || graph.isEmpty()) {
            MapperNode mapperNode = mapper.getNode(treePath, true);
            MapperNode mapperNode2 = mapperNode.getNextVisibleNode();
            if (mapperNode2 == null) {
                return;
            }
            mapper.setSelectedNode(mapperNode2);
            return;
        }
        List<Vertex> list = selectionModel.getSelectedVerteces();
        List<Link> list2 = selectionModel.getSelectedLinks();
        VertexItem vertexItem = selectionModel.getSelectedVertexItem();
        if (this.isControlPress(actionEvent) && this.isShiftPress(actionEvent)) {
            if (list2 != null && list2.size() > 0) {
                Link link = list2.get(0);
                List<Link> list3 = graph.getIngoingLinks();
                if (!list3.contains(link)) {
                    return;
                }
                int n2 = list3.indexOf(link);
                if (n2 == list3.size() - 1) {
                    return;
                }
                selectionModel.setSelected(treePath, list3.get(n2 + 1));
            }
            return;
        }
        if (this.isShiftPress(actionEvent)) {
            if (this.canvas.getScrollPane().getViewport() == null) {
                return;
            }
            object2 = this.canvas.getAutoscrollInsets();
            n = this.canvas.getScrollPane().getViewport().getViewRect().x;
            object = new Rectangle(n, 0, 1, 1);
            ((Rectangle)object).y = this.canvas.getHeight() - ((Insets)object2).bottom + 16 + 2 * this.canvas.getScrollPane().getVerticalScrollBar().getUnitIncrement();
            this.canvas.scrollRectToVisible((Rectangle)object);
        }
        if (this.isControlPress(actionEvent)) {
            if (list != null && list.size() > 0) {
                object2 = list.get(0);
                if (((Vertex)object2).getItemCount() < 1) {
                    return;
                }
                selectionModel.setSelected(treePath, ((Vertex)object2).getItem(0));
                return;
            }
            if (list2 != null && list2.size() > 0) {
                object2 = list2.get(0);
                TargetPin targetPin = ((Link)object2).getTarget();
                if (targetPin instanceof Graph) {
                    return;
                }
                object = (VertexItem)targetPin;
                Vertex vertex = ((VertexItem)object).getVertex();
                for (int i = vertex.getItemIndex((VertexItem)object) + 1; i < vertex.getItemCount(); ++i) {
                    object2 = vertex.getItem(i).getIngoingLink();
                    if (object2 == null) continue;
                    selectionModel.setSelected(treePath, (GraphItem)object2);
                    break;
                }
                return;
            }
            if (vertexItem != null) {
                object2 = vertexItem.getVertex();
                n = ((Vertex)object2).getItemIndex(vertexItem);
                if (n >= ((Vertex)object2).getItemCount() - 1) {
                    selectionModel.setSelected(treePath, (GraphItem)object2);
                    return;
                }
                object = ((Vertex)object2).getItem(n + 1);
                selectionModel.setSelected(treePath, (GraphItem)object);
                return;
            }
            object2 = mapper.getNode(treePath, true);
            MapperNode mapperNode = ((MapperNode)object2).getNextVisibleNode();
            if (mapperNode == null) {
                return;
            }
            mapper.setSelectedNode(mapperNode);
        }
        if (this.isNothingPress(actionEvent)) {
            object2 = selectionModel.getSelectedPath();
            if (object2 != null) {
                MapperNode mapperNode = mapper.getNode((TreePath)object2, true);
                object = mapperNode.getNextVisibleNode();
                if (object != null) {
                    selectionModel.setSelected(((MapperNode)object).getTreePath());
                }
            } else if (mapper.getRoot() != null && mapper.getRoot().getChildCount() > 0) {
                mapper.setSelectedNode(mapper.getRoot().getChild(0));
            }
        }
    }

    private boolean isControlPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 2) != 0;
    }

    private boolean isShiftPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 1) != 0;
    }

    private boolean isNothingPress(ActionEvent actionEvent) {
        return actionEvent.getModifiers() == 0;
    }
}

