/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.demo.DemoMapperModel;

public class Main
extends JFrame
implements ActionListener {
    DemoMapperModel model;
    Mapper mapper;
    JButton remove = new JButton("Remove");
    JButton add = new JButton("Add Child");
    JTextField name = new JTextField(10);
    JButton expand = new JButton("Expand All NEG");
    JButton collapse = new JButton("Collapse All");
    JButton hide = new JButton("Hide Others");

    public Main() {
        this.model = new DemoMapperModel();
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.expand.addActionListener(this);
        this.collapse.addActionListener(this);
        this.hide.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new LineBorder(Color.GRAY));
        jPanel.add(this.name);
        jPanel.add(this.add);
        jPanel.add(this.remove);
        jPanel.add(this.expand);
        jPanel.add(this.collapse);
        jPanel.add(this.hide);
        this.mapper = new Mapper(this.model);
        this.getContentPane().add(this.mapper);
        this.getContentPane().add((Component)jPanel, "North");
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] stringArray) {
        System.setProperty("swing.aatext", "true");
        new Main().setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.add) {
            String string = this.name.getText().trim();
            if (string.equals("")) {
                return;
            }
            TreePath treePath = this.mapper.getSelectionModel().getSelectedPath();
            if (treePath == null) {
                return;
            }
            this.model.addChild(treePath, string);
        } else if (actionEvent.getSource() == this.remove) {
            TreePath treePath = this.mapper.getSelectionModel().getSelectedPath();
            if (treePath == null) {
                return;
            }
            if (treePath.getParentPath() == null) {
                return;
            }
            this.model.remove(treePath);
        } else if (actionEvent.getSource() == this.expand) {
            this.mapper.expandNonEmptyGraphs();
        } else if (actionEvent.getSource() == this.collapse) {
            this.mapper.collapseAll(2);
        } else if (actionEvent.getSource() == this.hide) {
            this.mapper.hideOtherPathes(2);
        }
    }
}

