/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.graphics.RRectangle;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public abstract class Vertex
implements SourcePin,
GraphItem {
    private Graph graph;
    private List<VertexItem> items;
    private Link outgoingLink;
    private int x;
    private int y;
    private int width;
    private int height = 2;
    private Icon icon;
    private String name;
    private String resultText;
    private Object dataObject;
    final long uid;
    private static long nextUID = 0L;

    Vertex(Object object, Icon icon) {
        this(object, icon, null, null);
    }

    Vertex(Object object, Icon icon, String string, String string2) {
        this.icon = icon;
        this.name = string;
        this.resultText = string2;
        this.uid = nextUID++;
        this.dataObject = object;
        this.setWidth(10);
        this.layout();
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public String getResultText() {
        return this.resultText;
    }

    public void setResultText(String string) {
        if (!Utils.equal(this.resultText, string)) {
            this.resultText = string;
            this.fireGraphContentChanged();
        }
    }

    public void moveOnTop() {
        this.graph.moveOnTop(this);
    }

    public int getPinX() {
        return this.width;
    }

    public int getPinY() {
        return this.height / 2;
    }

    public int getPinGlobalX() {
        return this.getX() + this.getPinX();
    }

    public int getPinGlobalY() {
        return this.getY() + this.getPinY();
    }

    public Link getOutgoingLink() {
        return this.outgoingLink;
    }

    public void setOutgoingLink(Link link) {
        if (this.outgoingLink != link) {
            this.outgoingLink = link;
        }
    }

    public String getName() {
        return this.name;
    }

    public Graph getGraph() {
        return this.graph;
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public boolean isInGraph() {
        return this.graph != null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinimumWidth() {
        return 6;
    }

    public int getMaximumWidth() {
        return 20;
    }

    public boolean dontContains(int n, int n2, int n3) {
        int n4 = this.y * n3;
        int n5 = n4 + this.height * n3 + 1;
        if (n2 < n4 || n5 < n2) {
            return true;
        }
        int n6 = this.x * n3;
        int n7 = n6 + this.width * n3 + 1;
        return n < (n6 -= n3) || (n7 += n3) < n;
    }

    public boolean contains(int n, int n2, int n3) {
        return this.createShape(n3).contains(0.5 + (double)n - (double)(this.x * n3), 0.5 + (double)n2 - (double)(this.y * n3));
    }

    public boolean sourcePinContains(int n, int n2, int n3) {
        return 0 <= (n -= (this.x + this.width) * n3) && n <= n3 && 0 <= (n2 -= this.getPinGlobalY() * n3 - n3 / 2) && n2 <= n3;
    }

    public abstract RRectangle createShape(int var1);

    public void setLocation(int n, int n2) {
        n2 = Math.max(0, n2);
        if (this.x != n || this.y != n2) {
            this.x = n;
            this.y = n2;
            this.invalidateGraphBounds();
        }
    }

    public void setWidth(int n) {
        n = Math.max(this.getMinimumWidth(), Math.min(n, this.getMaximumWidth()));
        if (this.width != n) {
            this.width = n;
            this.layout();
            this.invalidateGraphBounds();
        }
    }

    void setHeight(int n) {
        if (this.height != n) {
            this.height = n;
            this.invalidateGraphBounds();
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBounds(int n) {
        return new Rectangle(this.x * n, this.y * n, this.width * n, this.height * n);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public VertexItem getItem(int n) {
        return this.items.get(n);
    }

    public int getItemIndex(VertexItem vertexItem) {
        return this.items == null ? -1 : this.items.indexOf(vertexItem);
    }

    public void addItem(VertexItem vertexItem) {
        this.addItem(vertexItem, -1);
    }

    public void addItem(VertexItem vertexItem, int n) {
        this.checkItem(vertexItem);
        if (this.items == null) {
            this.items = new ArrayList<VertexItem>();
            this.items.add(vertexItem);
        } else {
            int n2 = this.items.size();
            if (n < 0 || n >= n2) {
                this.items.add(vertexItem);
                n = n2;
            } else {
                this.items.add(n, vertexItem);
            }
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (i == n || this.items.get(i) != vertexItem) continue;
                this.items.remove(i);
                break;
            }
        }
        this.layout();
    }

    public void removeItem(VertexItem vertexItem) {
        this.checkItem(vertexItem);
        int n = this.getItemIndex(vertexItem);
        if (n >= 0) {
            this.items.remove(n);
            if (this.items.isEmpty()) {
                this.items = null;
            }
        }
        this.layout();
    }

    private void checkItem(VertexItem vertexItem) {
        if (vertexItem == null) {
            throw new IllegalArgumentException();
        }
        if (vertexItem.getVertex() != this) {
            throw new IllegalArgumentException();
        }
    }

    public abstract void paint(Graphics2D var1, TreePath var2, CanvasRendererContext var3, int var4);

    public void paintSourcePin(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        Link link = this.getOutgoingLink();
        int n2 = canvasRendererContext.getStep();
        int n3 = canvasRendererContext.getGraphX() + this.getPinGlobalX() * n2;
        int n4 = n + this.getPinGlobalY() * n2;
        if (canvasRendererContext.paintVertexPin(treePath, this)) {
            int n5 = n3 + 2;
            int n6 = n3 + n2 + 1;
            int n7 = n2 - 1;
            int n8 = n4 - n7 / 2;
            int n9 = n8 + n7;
            int n10 = (n6 - n5) / 3;
            int n11 = Math.min(n10, 2) * 2;
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(canvasRendererContext.isSelected(treePath, this) ? MapperStyle.SELECTION_COLOR : MapperStyle.ICON_COLOR);
            graphics2D.fillRoundRect(n5, n8, n6 - n5, n9 - n8, n11, n11);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n5 + n10, (float)n8 + 0.5f);
            generalPath.lineTo(n6 - n10, 0.5f * (float)(n8 + n9));
            generalPath.lineTo(n5 + n10, (float)n9 - 0.5f);
            graphics2D.setPaint(MapperStyle.PIN_FOREGROUND_COLOR);
            graphics2D.draw(generalPath);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        } else if (link != null && canvasRendererContext.paintLink(treePath, link)) {
            Color color = MapperStyle.LINK_COLOR_UNSELECTED_NODE;
            if (canvasRendererContext.isSelected(treePath)) {
                color = canvasRendererContext.isSelected(treePath, link) ? MapperStyle.SELECTION_COLOR : MapperStyle.LINK_COLOR_SELECTED_NODE;
            }
            Link.paintSourceDecoration(graphics2D, new Point(n3, n4), color, n2);
        }
    }

    public Point getSourcePinPoint(int n, int n2, int n3) {
        return new Point(n + this.getPinGlobalX() * n3, n2 + this.getPinGlobalY() * n3);
    }

    public void layout() {
        this.fireGraphContentChanged();
    }

    void invalidateGraphBounds() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.invalidateBounds();
        }
    }

    void invalidateGraphLinks() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.invalidateLinks();
        }
    }

    void fireGraphContentChanged() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.fireGraphContentChanged();
        }
    }
}

