/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xslt.tmap.TMapDataObject;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class TMapDataLoader
extends UniFileLoader {
    public static final String MIME_TYPE = "text/x-tmap+xml";
    public static final String LOADER_NAME = "LBL_loader_name";
    public static final String ACTION_CONTEXT = "Loaders/text/x-tmap+xml/Actions";
    private static final long serialVersionUID = 1L;

    public TMapDataLoader() {
        super("org.netbeans.modules.xslt.tmap.TMapDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(TMapDataLoader.class, (String)LOADER_NAME);
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(MIME_TYPE);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new TMapDataObject(fileObject, this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = null;
        String string = fileObject.getNameExt();
        if (string != null && string.equals("transformmap.xml")) {
            fileObject2 = this.isXsltProjectContext(fileObject) ? fileObject : null;
        }
        return fileObject2;
    }

    private boolean isXsltProjectContext(FileObject fileObject) {
        boolean bl = false;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project == null ? null : Util.getProjectSource(project);
        bl = fileObject2 != null && fileObject2.equals(fileObject.getParent());
        return bl;
    }

    protected String actionsContext() {
        return ACTION_CONTEXT;
    }
}

