/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.netbeans.modules.xslt.tmap.model.api.ExNamespaceContext;
import org.netbeans.modules.xslt.tmap.model.impl.InvalidNamespaceException;
import org.netbeans.modules.xslt.tmap.model.impl.TMapComponentAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExNamespaceContextImpl
implements ExNamespaceContext {
    static final String DEFAULT_NS = "ns";
    private TMapComponentAbstract myComponent;

    public ExNamespaceContextImpl(TMapComponentAbstract tMapComponentAbstract) {
        this.myComponent = tMapComponentAbstract;
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.myComponent.lookupNamespaceURI(string);
    }

    @Override
    public String getPrefix(String string) {
        String string2 = this.myComponent.getPeer().lookupPrefix(string);
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public Iterator getPrefixes(String string) {
        assert (string != null);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (TMapComponentAbstract tMapComponentAbstract = this.myComponent; tMapComponentAbstract != null; tMapComponentAbstract = (TMapComponentAbstract)tMapComponentAbstract.getParent()) {
            this.fillPrefixes(tMapComponentAbstract, string, linkedList);
        }
        return linkedList.iterator();
    }

    @Override
    public Iterator<String> getPrefixes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (TMapComponentAbstract tMapComponentAbstract = this.myComponent; tMapComponentAbstract != null; tMapComponentAbstract = (TMapComponentAbstract)tMapComponentAbstract.getParent()) {
            this.fillPrefixes(tMapComponentAbstract, null, linkedList);
        }
        return linkedList.iterator();
    }

    @Override
    public String addNamespace(String string) throws InvalidNamespaceException {
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidNamespaceException invalidNamespaceException = new InvalidNamespaceException(uRISyntaxException.getMessage());
            throw invalidNamespaceException;
        }
        if (this.getPrefix(string) != null) {
            return this.getPrefix(string);
        }
        int n = this.findAppropriateIndex(null, string);
        String string2 = DEFAULT_NS + ++n;
        TMapComponentAbstract tMapComponentAbstract = this.getRoot();
        tMapComponentAbstract.addPrefix(string2, string);
        return string2;
    }

    @Override
    public void addNamespace(String string, String string2) throws InvalidNamespaceException {
        try {
            new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidNamespaceException invalidNamespaceException = new InvalidNamespaceException(uRISyntaxException.getMessage());
            throw invalidNamespaceException;
        }
        if (!Utils.isValidNCName((String)string)) {
            throw new InvalidNamespaceException("Prefix : '" + string + "' is not acceptable as prefix fot namespace.");
        }
        this.findAppropriateIndex(string, string2);
        this.getRoot().addPrefix(string, string2);
    }

    private void fillPrefixes(TMapComponentAbstract tMapComponentAbstract, String string, List<String> list) {
        Map map = tMapComponentAbstract.getPrefixes();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (string == null) {
                list.add(string2);
            }
            if (string3 == null || !string3.equals(string)) continue;
            list.add(string2);
        }
    }

    private int findAppropriateIndex(String string, String string2) throws InvalidNamespaceException {
        Iterator<String> iterator = this.getPrefixes();
        int n = 0;
        while (iterator.hasNext()) {
            String string3;
            String string4 = iterator.next();
            if (string != null && string.equals(string4)) {
                string3 = this.getNamespaceURI(string);
                if (string3.equals(string2)) {
                    return 0;
                }
                throw new InvalidNamespaceException("Element's scope already have prefix " + string + " and it declared " + "with different namespace uri");
            }
            if (!string4.startsWith(DEFAULT_NS)) continue;
            string3 = string4.substring(2);
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    private TMapComponentAbstract getRoot() {
        TMapComponentAbstract tMapComponentAbstract = this.myComponent;
        while (tMapComponentAbstract.getParent() != null) {
            tMapComponentAbstract = (TMapComponentAbstract)tMapComponentAbstract.getParent();
        }
        return tMapComponentAbstract;
    }
}

