/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.nodes.LogicalTreeHandler;
import org.netbeans.modules.xslt.tmap.nodes.NavigatorNodeFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ProxyLookup;

public class TMapLogicalPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private static final String DELETE = "delete";
    private static final KeyStroke DELETE_KEYSTROKE = KeyStroke.getKeyStroke(127, 0);
    private JLabel myMsgLabel;
    private ExplorerManager myExplorerManager;
    private LogicalTreeHandler myTreeHandler;
    private Lookup myContextLookup;
    private TMapModel myModel;
    private Lookup myLookup;

    public TMapLogicalPanel() {
        this.initComponent();
    }

    public void navigate(Lookup lookup, TMapModel tMapModel) {
        if (lookup == null || tMapModel == null) {
            return;
        }
        this.myModel = tMapModel;
        this.myContextLookup = lookup;
        this.showWaitMsg();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                TMapLogicalPanel.this.showNavTree();
            }
        });
        thread.start();
    }

    protected TMapModel getModel() {
        return this.myModel;
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    protected Lookup getContextLookup() {
        return this.myContextLookup;
    }

    public Lookup getLookup() {
        return this.myLookup;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.myMsgLabel = new JLabel();
        this.add((Component)this.myMsgLabel, "Center");
    }

    public void showWaitMsg() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showingWaitMessage();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TMapLogicalPanel.this.showingWaitMessage();
                }
            });
        }
    }

    private void showingWaitMessage() {
        this.removeAll();
        this.myMsgLabel.setText(NbBundle.getMessage(TMapLogicalPanel.class, (String)"LBL_Wait"));
        this.add((Component)this.myMsgLabel, "Center");
        this.repaint();
    }

    private void showNavTree() {
        final BeanTreeView beanTreeView = this.getBeanTreeView();
        if (beanTreeView == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TMapLogicalPanel.this.removeAll();
                TMapLogicalPanel.this.add((Component)beanTreeView);
                TMapLogicalPanel.this.revalidate();
            }
        });
    }

    protected boolean initNavTree() {
        this.myExplorerManager = new ExplorerManager();
        if (!Model.State.VALID.equals((Object)this.myModel.getState())) {
            return false;
        }
        this.initActionMap();
        Lookup lookup = this.getContextLookup();
        Node node = NavigatorNodeFactory.getInstance().getTransformMapNode(this.myModel, lookup);
        if (node == null) {
            return false;
        }
        this.myExplorerManager.setRootContext(node);
        return true;
    }

    protected BeanTreeView getBeanTreeView() {
        boolean bl = this.initNavTree();
        if (!bl) {
            return null;
        }
        BeanTreeView beanTreeView = null;
        if (this.myTreeHandler != null) {
            this.myTreeHandler.removeListeners();
            this.myTreeHandler = null;
        }
        this.myTreeHandler = new LogicalTreeHandler(this.myExplorerManager, this.myModel, this.getContextLookup());
        beanTreeView = this.myTreeHandler.getBeanTreeView();
        return beanTreeView;
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(DELETE, ExplorerUtils.actionDelete((ExplorerManager)this.myExplorerManager, (boolean)true));
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(DELETE_KEYSTROKE, DELETE);
        this.myLookup = new ProxyLookup(new Lookup[]{this.myContextLookup, ExplorerUtils.createLookup((ExplorerManager)this.myExplorerManager, (ActionMap)actionMap)});
    }
}

