/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.nodes.properties;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xslt.tmap.model.api.Import;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.VariableReference;
import org.openide.util.Lookup;

public final class ResolverUtility {
    private static final Logger LOGGER = Logger.getLogger(ResolverUtility.class.getName());

    public static String qName2DisplayText(QName qName) {
        return ResolverUtility.qName2DisplayText(qName, null);
    }

    public static String qName2DisplayText(QName qName, TMapComponent tMapComponent) {
        if (qName == null) {
            return "";
        }
        String string = qName.getPrefix();
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = qName.getNamespaceURI();
            if (tMapComponent != null && string2 != null && string2.length() != 0) {
                string = tMapComponent.getNamespaceContext().getPrefix(string2);
            }
        }
        if (string == null || string.length() == 0) {
            if (string2 != null && string2.length() != 0) {
                String string3 = qName.getLocalPart() + "{" + string2 + "}";
                return string3;
            }
            string = "";
        } else {
            string = string + ":";
        }
        String string4 = string + qName.getLocalPart();
        return string4;
    }

    public static String encodeLocation(String string) {
        return string.replace(" ", "%20");
    }

    public static String decodeLocation(String string) {
        return string.replace("%20", " ");
    }

    public static boolean isModelImported(Model model, Lookup lookup) {
        TMapModel tMapModel = (TMapModel)lookup.lookup(TMapModel.class);
        return ResolverUtility.isModelImported(model, tMapModel);
    }

    public static boolean isModelImported(Model model, TMapModel tMapModel) {
        if (model == SchemaModelFactory.getDefault().getPrimitiveTypesModel()) {
            return true;
        }
        for (Import import_ : tMapModel.getTransformMap().getImports()) {
            try {
                if (model != import_.getImportModel()) continue;
                return true;
            }
            catch (CatalogModelException catalogModelException) {
                LOGGER.log(Level.INFO, "exception on imported model resolving");
                return false;
            }
        }
        return false;
    }

    public static String getNameByRef(Reference reference) {
        if (reference == null) {
            return null;
        }
        String string = null;
        Referenceable referenceable = null;
        try {
            referenceable = reference.get();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (referenceable != null) {
            if (referenceable instanceof VariableReference) {
                string = ((VariableReference)referenceable).getReferencedVariable().getName();
            } else if (referenceable instanceof Named) {
                string = ((Named)referenceable).getName();
            }
        } else {
            string = reference.getRefString();
        }
        return string;
    }
}

