/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.catalogsupport.util.ProjectReferenceUtility;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultProjectCatalogSupport
extends ProjectCatalogSupport {
    public Project project;
    public AntProjectHelper helper;
    public ReferenceHelper refHelper;
    private static String[] sourceTypes = new String[]{"xml", "java", "doc_root", "web_inf", "PHPSOURCE", "ruby"};

    public DefaultProjectCatalogSupport(Project project) {
        this(project, null, null);
    }

    public DefaultProjectCatalogSupport(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.helper = antProjectHelper;
        this.refHelper = referenceHelper;
    }

    public static DefaultProjectCatalogSupport getInstance(FileObject fileObject) {
        DefaultProjectCatalogSupport defaultProjectCatalogSupport;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (defaultProjectCatalogSupport = (DefaultProjectCatalogSupport)((Object)project.getLookup().lookup(DefaultProjectCatalogSupport.class))) != null) {
            return defaultProjectCatalogSupport;
        }
        return new DefaultProjectCatalogSupport(project);
    }

    public boolean supportsCrossProject() {
        return this.helper != null;
    }

    public URI constructProjectProtocol(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            String string = DefaultProjectCatalogSupport.getUsableProjectName(project);
            String string2 = DefaultProjectCatalogSupport.getRelativePath(project.getProjectDirectory(), fileObject);
            try {
                return new URI("nb-uri", string, string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isProjectProtocol(URI uRI) {
        return "nb-uri".equals(uRI.getScheme());
    }

    public FileObject resolveProjectProtocol(URI uRI) {
        if (this.supportsCrossProject() && this.isProjectProtocol(uRI)) {
            String string = uRI.getSchemeSpecificPart();
            String string2 = this.helper.getProperties("nbproject/project.properties").getProperty("project.".concat(string));
            if (string2 != null) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                File file2 = new File(file.toURI().resolve(string2));
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
                if (fileObject == null) {
                    return null;
                }
                return fileObject.getFileObject(uRI.getFragment());
            }
        }
        return null;
    }

    public boolean needsCatalogEntry(FileObject fileObject, FileObject fileObject2) {
        assert (fileObject != null && fileObject2 != null);
        if (this.project != FileOwnerQuery.getOwner((FileObject)fileObject2)) {
            return true;
        }
        FileObject fileObject3 = this.getSourceFolder(fileObject);
        return fileObject3 != null && !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2);
    }

    public URI createCatalogEntry(FileObject fileObject, FileObject fileObject2) throws IOException, CatalogModelException {
        assert (fileObject != null && fileObject2 != null);
        CatalogWriteModel catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(this.project.getProjectDirectory());
        assert (catalogWriteModel != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        URI uRI = null;
        URI uRI2 = null;
        try {
            uRI2 = this.getReferenceURI(fileObject, fileObject2);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        if (this.project != project) {
            if (!this.getProjectReferences().contains(project) && this.supportsCrossProject()) {
                ProjectReferenceUtility.addProjectReference(this.refHelper, project);
            }
            uRI = this.constructProjectProtocol(fileObject2);
        } else {
            try {
                uRI = new URI(DefaultProjectCatalogSupport.getRelativePath(catalogWriteModel.getCatalogFileObject(), fileObject2));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        catalogWriteModel.addURI(uRI2, uRI);
        return uRI2;
    }

    public URI getReferenceURI(FileObject fileObject, FileObject fileObject2) throws URISyntaxException {
        String string;
        String string2;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        FileObject fileObject3 = this.getSourceFolder(fileObject);
        if (fileObject3 == null) {
            fileObject3 = fileObject;
        }
        String string3 = string2 = (string = DefaultProjectCatalogSupport.getRelativePath(fileObject.getParent(), fileObject3)).trim().equals("") ? "" : string.concat("/");
        if (this.project != project) {
            FileObject fileObject4 = DefaultProjectCatalogSupport.getSourceFolder(project, fileObject2);
            if (fileObject4 == null) {
                throw new IllegalArgumentException(fileObject2.getPath() + " is not in target project source");
            }
            String string4 = DefaultProjectCatalogSupport.getRelativePath(fileObject4, fileObject2);
            return new URI(string2.concat(DefaultProjectCatalogSupport.getUsableProjectName(project)).concat("/").concat(string4));
        }
        FileObject fileObject5 = this.getSourceFolder(fileObject2);
        if (fileObject5 == null) {
            throw new IllegalArgumentException(fileObject2.getPath() + " is not in project source");
        }
        String string5 = DefaultProjectCatalogSupport.getRelativePath(fileObject5, fileObject2);
        return new URI(string2.concat(string5));
    }

    public Set getProjectReferences() {
        SubprojectProvider subprojectProvider = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
        return subprojectProvider.getSubprojects();
    }

    private FileObject getSourceFolder(FileObject fileObject) {
        return DefaultProjectCatalogSupport.getSourceFolder(this.project, fileObject);
    }

    private static FileObject getSourceFolder(Project project, FileObject fileObject) {
        Sources sources = ProjectUtils.getSources((Project)project);
        assert (sources != null);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (String string : sourceTypes) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            arrayList.addAll(Arrays.asList(sourceGroupArray));
        }
        assert (arrayList.size() > 0);
        for (SourceGroup sourceGroup : arrayList) {
            if (!FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroup.getRootFolder();
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("src/conf");
        if (fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return fileObject2;
        }
        return null;
    }

    private static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = FileUtil.toFile((FileObject)fileObject2);
        String string = file.toURI().toString();
        String string2 = file2.toURI().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer.nextToken().equals(string3)) break;
            if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) continue;
            if (stringTokenizer.hasMoreElements()) {
                string3 = "..";
                stringTokenizer.nextToken();
                continue;
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                continue;
            }
            string3 = "";
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = "../".concat(string3);
            stringTokenizer.nextToken();
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string3 = string3.concat("/").concat(stringTokenizer2.nextToken());
        }
        return string3;
    }

    private static String getUsableProjectName(Project project) {
        return PropertyUtils.getUsablePropertyName((String)ProjectUtils.getInformation((Project)project).getName()).replace('.', '_');
    }

    public boolean removeCatalogEntry(URI uRI) throws IOException {
        CatalogWriteModel catalogWriteModel = null;
        try {
            catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(this.project.getProjectDirectory());
        }
        catch (CatalogModelException catalogModelException) {
            return false;
        }
        boolean bl = false;
        for (CatalogEntry catalogEntry : catalogWriteModel.getCatalogEntries()) {
            URI uRI2 = null;
            try {
                uRI2 = new URI(catalogEntry.getSource());
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            if (!uRI2.equals(uRI)) continue;
            bl = true;
            break;
        }
        if (bl) {
            catalogWriteModel.removeURI(uRI);
            return true;
        }
        return false;
    }
}

