/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.wizard.ProviderControl;
import org.netbeans.modules.cnd.discovery.wizard.SelectObjectFilesWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.util.NbBundle;

public final class SelectObjectFilesPanel
extends JPanel {
    private SelectObjectFilesWizard wizard;
    private List<ProviderControl> controls = new ArrayList<ProviderControl>();
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel providerPanel;

    public SelectObjectFilesPanel(SelectObjectFilesWizard selectObjectFilesWizard) {
        this.wizard = selectObjectFilesWizard;
        this.initComponents();
    }

    void read(DiscoveryDescriptor discoveryDescriptor) {
        DiscoveryProvider discoveryProvider = discoveryDescriptor.getProvider();
        if (discoveryProvider != null) {
            this.providerPanel.removeAll();
            this.controls.clear();
            boolean bl = true;
            for (String string : discoveryProvider.getPropertyKeys()) {
                ProviderProperty providerProperty = discoveryProvider.getProperty(string);
                switch (providerProperty.getKind()) {
                    case MakeLogFile: 
                    case BinaryFile: 
                    case Folder: 
                    case BinaryFiles: {
                        ProviderControl providerControl = new ProviderControl(providerProperty, discoveryDescriptor, this.providerPanel, this.wizard);
                        this.controls.add(providerControl);
                        if (!bl) break;
                        this.instructionsTextArea.setText(providerProperty.getDescription());
                        bl = false;
                        break;
                    }
                }
            }
        }
    }

    void store(DiscoveryDescriptor discoveryDescriptor) {
        for (ProviderControl providerControl : this.controls) {
            providerControl.store();
        }
        discoveryDescriptor.setInvokeProvider(true);
    }

    boolean valid() {
        if (this.controls.size() == 0) {
            return false;
        }
        for (ProviderControl providerControl : this.controls) {
            if (providerControl.valid()) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.providerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(100, 100));
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("BuildActionsInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.providerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.providerPanel, gridBagConstraints);
    }

    private String getString(String string) {
        return NbBundle.getBundle(SelectObjectFilesPanel.class).getString(string);
    }
}

