/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Exceptions;

public final class PropertyHelper {
    private Project project;
    private UpdateHelper updateHelper;

    public PropertyHelper(Project project, UpdateHelper updateHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
    }

    public String getProperty(String string, String string2) {
        return this.getProperties(string).getProperty(string2);
    }

    public void setProperty(String string, String string2, String string3) {
        assert (ProjectManager.mutex().isWriteAccess()) : "You must have write access to ProjectManager.mutex(). You can also use @see #saveProperty if you only need to save one property";
        EditableProperties editableProperties = this.getProperties(string);
        editableProperties.setProperty(string2, string3);
        this.putProperties(string, editableProperties);
    }

    public void saveProperty(final String string, final String string2, final String string3) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                PropertyHelper.this.setProperty(string, string2, string3);
                PropertyHelper.this.save();
            }
        });
    }

    public void save() {
        assert (ProjectManager.mutex().isWriteAccess()) : "You must have write access to ProjectManager.mutex().";
        try {
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private EditableProperties getProperties(String string) {
        return this.updateHelper.getProperties(string);
    }

    private void putProperties(String string, EditableProperties editableProperties) {
        this.updateHelper.putProperties(string, editableProperties);
    }
}

