/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class SourceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        EjbJarProject ejbJarProject = (EjbJarProject)project.getLookup().lookup(EjbJarProject.class);
        assert (ejbJarProject != null);
        return new SourcesNodeList(ejbJarProject);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1517163112L;
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(SourceNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private final String nodeName;
        private final Project project;
        Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (this.actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    this.actions = new Action[actionArray.length + 2];
                    System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                    this.actions[actionArray.length] = null;
                    this.actions[actionArray.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(bl);
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
        }

        public int hashCode() {
            int n = 5;
            String string = this.group.getDisplayName();
            n = 79 * n + (this.fileObject != null ? this.fileObject.hashCode() : 0);
            n = 79 * n + (string != null ? string.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            if (!(this.fileObject == sourceGroupKey.fileObject || this.fileObject != null && this.fileObject.equals(sourceGroupKey.fileObject))) {
                return false;
            }
            String string = this.group.getDisplayName();
            String string2 = sourceGroupKey.group.getDisplayName();
            boolean bl2 = string == null;
            boolean bl3 = bl = string2 == null;
            return bl2 == bl && string.equals(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private final EjbJarProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(EjbJarProject ejbJarProject) {
            this.project = ejbJarProject;
        }

        public List<SourceGroupKey> keys() {
            FileObject fileObject = this.project.getProjectDirectory();
            if (fileObject != null && !fileObject.isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>(sourceGroupArray.length);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new SourceGroupKey(sourceGroupArray[i]));
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            return new PackageViewFilterNode(sourceGroupKey.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

