/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.tool.ide.completion.AntlrSimpleHQLLexer;
import org.hibernate.tool.ide.completion.EntityNameReference;
import org.hibernate.tool.ide.completion.SimpleHQLLexer;

public class HQLAnalyzer {
    private static String[] hqlKeywords = new String[]{"between", "class", "delete", "desc", "distinct", "elements", "escape", "exists", "false", "fetch", "from", "full", "group", "having", "in", "indices", "inner", "insert", "into", "is", "join", "left", "like", "new", "not", "null", "or", "order", "outer", "properties", "right", "select", "set", "some", "true", "union", "update", "versioned", "where", "and", "or", "as", "on", "with", "both", "empty", "leading", "member", "object", "of", "trailing"};
    private static String[] builtInFunctions = new String[]{"substring", "locate", "trim", "length", "bit_length", "coalesce", "nullif", "abs", "mod", "sqrt", "upper", "lower", "cast", "extract", "second", "minute", "hour", "day", "month", "year", "str", "sign", "acos", "asin", "atan", "cos", "cosh", "exp", "ln", "sin", "sinh", "stddev", "sqrt", "tan", "tanh", "variance", "round", "trunc", "ceil", "floor", "chr", "initcap", "lower", "ltrim", "rtrim", "soundex", "upper", "ascii", "length", "to_char", "to_date", "current_date", "current_time", "current_timestamp", "lastday", "sysday", "systimestamp", "uid", "user", "rowid", "rownum", "concat", "instr", "instrb", "lpad", "replace", "rpad", "substr", "substrb", "translate", "substring", "locate", "bit_length", "coalesce", "atan2", "log", "mod", "nvl", "nvl2", "power", "add_months", "months_between", "next_day", "max", "min"};

    protected SimpleHQLLexer getLexer(char[] chars, int end) {
        return new AntlrSimpleHQLLexer(chars, end);
    }

    protected SimpleHQLLexer getLexer(char[] chars) {
        return new AntlrSimpleHQLLexer(chars, chars.length);
    }

    public boolean shouldShowEntityNames(String query, int cursorPosition) {
        return this.shouldShowEntityNames(query.toCharArray(), cursorPosition);
    }

    public boolean shouldShowEntityNames(char[] chars, int cursorPosition) {
        SimpleHQLLexer lexer = this.getLexer(chars, cursorPosition);
        int tokenId = -1;
        boolean show = false;
        while ((tokenId = lexer.nextTokenId()) != 1) {
            if ((tokenId == 22 || tokenId == 13 || tokenId == 51) && lexer.getTokenOffset() + lexer.getTokenLength() < cursorPosition) {
                show = true;
                continue;
            }
            if (tokenId == 15 || tokenId == 7 || tokenId == 96 || tokenId == 120 || tokenId == 124) continue;
            show = false;
        }
        return show;
    }

    public List getVisibleSubQueries(char[] chars, int position) {
        SubQueryList sqList = this.getSubQueries(chars, position);
        ArrayList<SubQuery> visible = new ArrayList<SubQuery>();
        Iterator iter = sqList.subQueries.iterator();
        while (iter.hasNext()) {
            SubQuery sq = (SubQuery)iter.next();
            if (sqList.caretDepth < sq.depth || sq.startOffset > position && sq.endOffset < position) continue;
            visible.add(sq);
        }
        return visible;
    }

    public List getVisibleEntityNames(char[] chars, int position) {
        List sqs = this.getVisibleSubQueries(chars, position);
        ArrayList entityReferences = new ArrayList();
        Iterator iter = sqs.iterator();
        while (iter.hasNext()) {
            SubQuery sq = (SubQuery)iter.next();
            entityReferences.addAll(sq.getEntityNames());
        }
        return entityReferences;
    }

    protected SubQueryList getSubQueries(char[] query, int position) {
        SubQuery sq;
        SimpleHQLLexer syntax = this.getLexer(query);
        int numericId = -1;
        ArrayList<SubQuery> subQueries = new ArrayList<SubQuery>();
        int depth = 0;
        int caretDepth = 0;
        HashMap<Integer, SubQuery> level2SubQuery = new HashMap<Integer, SubQuery>();
        SubQuery current = null;
        block3: while ((numericId = syntax.nextTokenId()) != 1) {
            boolean tokenAdded = false;
            if (numericId == 98) {
                ++depth;
                if (position > syntax.getTokenOffset()) {
                    caretDepth = depth;
                }
            } else if (numericId == 99) {
                SubQuery currentDepthQuery = (SubQuery)level2SubQuery.get(new Integer(depth));
                if (currentDepthQuery != null && currentDepthQuery.depth == depth) {
                    currentDepthQuery.endOffset = syntax.getTokenOffset();
                    currentDepthQuery.tokenIds.add(new Integer(numericId));
                    currentDepthQuery.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
                    subQueries.add(currentDepthQuery);
                    level2SubQuery.remove(new Integer(depth));
                    tokenAdded = true;
                }
                --depth;
                if (position > syntax.getTokenOffset()) {
                    caretDepth = depth;
                }
            }
            switch (numericId) {
                case 13: 
                case 22: 
                case 45: 
                case 51: {
                    if (!level2SubQuery.containsKey(new Integer(depth))) {
                        current = new SubQuery();
                        current.depth = depth;
                        current.startOffset = syntax.getTokenOffset();
                        level2SubQuery.put(new Integer(depth), current);
                    }
                    current.tokenIds.add(new Integer(numericId));
                    current.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
                    continue block3;
                }
            }
            if (tokenAdded) continue;
            sq = (SubQuery)level2SubQuery.get(new Integer(depth));
            int i = depth;
            while (sq == null && i >= 0) {
                sq = (SubQuery)level2SubQuery.get(new Integer(i--));
            }
            if (sq == null) continue;
            sq.tokenIds.add(new Integer(numericId));
            sq.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
        }
        Iterator iter = level2SubQuery.values().iterator();
        while (iter.hasNext()) {
            sq = (SubQuery)iter.next();
            sq.endOffset = syntax.getTokenOffset() + syntax.getTokenLength();
            subQueries.add(sq);
        }
        Collections.sort(subQueries);
        SubQueryList sql = new SubQueryList();
        sql.caretDepth = caretDepth;
        sql.subQueries = subQueries;
        return sql;
    }

    public static String getEntityNamePrefix(char[] chars, int position) {
        char c;
        StringBuffer buff = new StringBuffer();
        for (int i = position - 1; i >= 0 && ((c = chars[i]) == '.' || Character.isJavaIdentifierPart(c)); --i) {
            buff.insert(0, c);
        }
        return buff.toString();
    }

    static String[] getHQLKeywords() {
        return hqlKeywords;
    }

    static String[] getHQLFunctionNames() {
        return builtInFunctions;
    }

    static {
        Arrays.sort(builtInFunctions);
        Arrays.sort(hqlKeywords);
    }

    static class SubQueryList {
        int caretDepth;
        List subQueries;

        SubQueryList() {
        }
    }

    public static class SubQuery
    implements Comparable {
        private List tokenIds = new ArrayList();
        private List tokenText = new ArrayList();
        private int startOffset;
        private int endOffset;
        private int depth;

        public int compareTo(Object s) {
            return this.startOffset - ((SubQuery)s).startOffset;
        }

        public int getTokenCount() {
            return this.tokenIds.size();
        }

        public int getToken(int i) {
            return ((Number)this.tokenIds.get(i)).intValue();
        }

        public String getTokenText(int i) {
            return (String)this.tokenText.get(i);
        }

        public List getEntityNames() {
            boolean afterFrom = false;
            boolean afterJoin = false;
            StringBuffer tableNames = new StringBuffer();
            StringBuffer joins = new StringBuffer();
            int i = 0;
            boolean cont = true;
            int lastToken = 1;
            Iterator iter = this.tokenIds.iterator();
            while (iter.hasNext()) {
                Integer typeInteger = (Integer)iter.next();
                int type = typeInteger;
                if (!cont) break;
                if (!(afterFrom || type != 22 && type != 51 && type != 13)) {
                    afterFrom = true;
                } else if (afterJoin) {
                    switch (type) {
                        case 24: 
                        case 25: 
                        case 41: 
                        case 53: {
                            cont = false;
                            break;
                        }
                        case 28: 
                        case 32: 
                        case 33: 
                        case 42: 
                        case 44: {
                            joins.append(",");
                            break;
                        }
                        case 96: {
                            joins.append(",");
                            break;
                        }
                        case 15: {
                            joins.append(".");
                            break;
                        }
                        case 120: {
                            if (lastToken != 15) {
                                joins.append(" ");
                            }
                            joins.append(this.tokenText.get(i));
                        }
                    }
                } else if (afterFrom) {
                    switch (type) {
                        case 24: 
                        case 25: 
                        case 41: 
                        case 46: 
                        case 53: {
                            cont = false;
                            break;
                        }
                        case 96: {
                            tableNames.append(",");
                            break;
                        }
                        case 15: {
                            tableNames.append(".");
                            break;
                        }
                        case 120: {
                            if (lastToken != 15) {
                                tableNames.append(" ");
                            }
                            tableNames.append(this.tokenText.get(i));
                            break;
                        }
                        case 32: {
                            tableNames.append(",");
                            afterJoin = true;
                            break;
                        }
                    }
                }
                ++i;
                lastToken = type;
            }
            ArrayList tables = new ArrayList();
            this.addEntityReferences(tables, tableNames);
            this.addEntityReferences(tables, joins);
            return tables;
        }

        private void addEntityReferences(List tables, StringBuffer tableNames) {
            StringTokenizer tableTokenizer = new StringTokenizer(tableNames.toString(), ",");
            while (tableTokenizer.hasMoreTokens()) {
                String table = tableTokenizer.nextToken().trim();
                if (table.indexOf(32) == -1 && table.length() > 0) {
                    tables.add(new EntityNameReference(table, table));
                    continue;
                }
                StringTokenizer aliasTokenizer = new StringTokenizer(table, " ");
                if (aliasTokenizer.countTokens() < 2) continue;
                String type = aliasTokenizer.nextToken().trim();
                String alias = aliasTokenizer.nextToken().trim();
                if (type.length() <= 0 || alias.length() <= 0) continue;
                tables.add(new EntityNameReference(type, alias));
            }
        }
    }
}

