/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataAccessor;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCTable;
import org.netbeans.modules.db.metadata.model.spi.SchemaImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCSchema
extends SchemaImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCSchema.class.getName());
    protected final JDBCCatalog jdbcCatalog;
    protected final String name;
    protected final boolean _default;
    protected final boolean synthetic;
    protected Map<String, Table> tables;

    public JDBCSchema(JDBCCatalog jDBCCatalog, String string, boolean bl, boolean bl2) {
        this.jdbcCatalog = jDBCCatalog;
        this.name = string;
        this._default = bl;
        this.synthetic = bl2;
    }

    @Override
    public final Catalog getParent() {
        return this.jdbcCatalog.getCatalog();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isDefault() {
        return this._default;
    }

    @Override
    public final boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public final Collection<Table> getTables() {
        return this.initTables().values();
    }

    @Override
    public final Table getTable(String string) {
        return MetadataUtilities.find(string, this.initTables());
    }

    public String toString() {
        return "JDBCSchema[name='" + this.name + "',default=" + this._default + ",synthetic=" + this.synthetic + "]";
    }

    protected JDBCTable createJDBCTable(String string) {
        return new JDBCTable(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Table> linkedHashMap = new LinkedHashMap<String, Table>();
        try {
            ResultSet resultSet = this.jdbcCatalog.getJDBCMetadata().getDmd().getTables(this.jdbcCatalog.getName(), this.name, "%", new String[]{"TABLE", "SYSTEM TABLE"});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    Table table = this.createJDBCTable(string).getTable();
                    linkedHashMap.put(string, table);
                    LOGGER.log(Level.FINE, "Created table {0}", table);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.tables = Collections.unmodifiableMap(linkedHashMap);
    }

    private Map<String, Table> initTables() {
        if (this.tables != null) {
            return this.tables;
        }
        this.createTables();
        return this.tables;
    }

    public final JDBCCatalog getJDBCCatalog() {
        return this.jdbcCatalog;
    }

    public final void refreshTable(String string) {
        if (this.tables == null) {
            return;
        }
        Table table = MetadataUtilities.find(string, this.tables);
        if (table == null) {
            return;
        }
        ((JDBCTable)MetadataAccessor.getDefault().getTableImpl(table)).refresh();
    }
}

