/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.Undefined;
import org.mozilla.nb.javascript.UniqueTag;
import org.mozilla.nb.javascript.serialize.ScriptableOutputStream;

public class ScriptableInputStream
extends ObjectInputStream {
    private Scriptable scope;
    private ClassLoader classLoader;

    public ScriptableInputStream(InputStream inputStream, Scriptable scriptable) throws IOException {
        super(inputStream);
        this.scope = scriptable;
        this.enableResolveObject(true);
        Context context = Context.getCurrentContext();
        if (context != null) {
            this.classLoader = context.getApplicationClassLoader();
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (this.classLoader != null) {
            try {
                return this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.resolveClass(objectStreamClass);
    }

    protected Object resolveObject(Object object) throws IOException {
        if (object instanceof ScriptableOutputStream.PendingLookup) {
            String string = ((ScriptableOutputStream.PendingLookup)object).getName();
            if ((object = ScriptableOutputStream.lookupQualifiedName(this.scope, string)) == Scriptable.NOT_FOUND) {
                throw new IOException("Object " + string + " not found upon " + "deserialization.");
            }
        } else if (object instanceof UniqueTag) {
            object = ((UniqueTag)object).readResolve();
        } else if (object instanceof Undefined) {
            object = ((Undefined)object).readResolve();
        }
        return object;
    }
}

