/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.gotodeclaration.type.CppTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.type.TracingTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.util.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppTypeProvider
implements TypeProvider {
    private boolean isCancelled = false;
    private static final boolean PROCESS_LIBRARIES = true;
    private static final boolean TRACE = Boolean.getBoolean("cnd.type.provider.trace");

    public CppTypeProvider() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.ctor\n", new Object[0]);
        }
    }

    public String name() {
        return "C/C++";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CppTypeProvider.class, (String)"TYPE_PROVIDER_DISPLAY_NAME");
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        CsmSelect.CsmFilter csmFilter;
        this.isCancelled = false;
        Project project = context.getProject();
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        if (TRACE) {
            System.err.printf("CppTypeProvider.getTypeNames(%s, %s, %s)\n", project, string, searchType);
        }
        if ((csmFilter = NameMatcherFactory.createNameFilter(string, searchType)) == null) {
            return;
        }
        if (project == null) {
            Collection collection = CsmModelAccessor.getModel().projects();
            if (!collection.isEmpty()) {
                HashSet<TypeDescriptor> hashSet = new HashSet<TypeDescriptor>();
                for (CsmProject csmProject : collection) {
                    this.processProject(csmProject, hashSet, csmFilter);
                }
                for (CsmProject csmProject : collection) {
                    if (this.isCancelled) break;
                    HashSet<CsmProject> hashSet2 = new HashSet<CsmProject>();
                    this.processProjectLibs(csmProject, hashSet, csmFilter, hashSet2);
                }
                result.addResult(new ArrayList<TypeDescriptor>(hashSet));
            }
        } else {
            HashSet<TypeDescriptor> hashSet = new HashSet<TypeDescriptor>();
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
            this.processProject(csmProject, hashSet, csmFilter);
            this.processProjectLibs(csmProject, hashSet, csmFilter, new HashSet<CsmProject>());
            result.addResult(new ArrayList<TypeDescriptor>(hashSet));
        }
    }

    public void cancel() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cancel\n", new Object[0]);
        }
        this.isCancelled = true;
    }

    public void cleanup() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cleanup\n", new Object[0]);
        }
    }

    private static TypeDescriptor createTypeDescriptor(CsmClassifier csmClassifier) {
        CppTypeDescriptor cppTypeDescriptor = new CppTypeDescriptor(csmClassifier);
        return TRACE ? new TracingTypeDescriptor(cppTypeDescriptor) : cppTypeDescriptor;
    }

    private void processProjectLibs(CsmProject csmProject, Set<TypeDescriptor> set, CsmSelect.CsmFilter csmFilter, Set<CsmProject> set2) {
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            if (this.isCancelled) {
                return;
            }
            if (!csmProject2.isArtificial() || set2.contains(csmProject2)) continue;
            set2.add(csmProject2);
            this.processProject(csmProject2, set, csmFilter);
        }
    }

    private void processProject(CsmProject csmProject, Set<TypeDescriptor> set, CsmSelect.CsmFilter csmFilter) {
        if (TRACE) {
            System.err.printf("processProject %s\n", csmProject.getName());
        }
        this.processNamespace(csmProject.getGlobalNamespace(), set, csmFilter);
    }

    private void processNamespace(CsmNamespace csmNamespace, Set<TypeDescriptor> set, CsmSelect.CsmFilter csmFilter) {
        if (TRACE) {
            System.err.printf("processNamespace %s\n", csmNamespace.getQualifiedName());
        }
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
        while (iterator.hasNext()) {
            if (this.isCancelled) {
                return;
            }
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            this.processDeclaration(csmDeclaration, set);
        }
        for (CsmDeclaration csmDeclaration : csmNamespace.getNestedNamespaces()) {
            if (this.isCancelled) {
                return;
            }
            this.processNamespace((CsmNamespace)csmDeclaration, set, csmFilter);
        }
    }

    private void processDeclaration(CsmDeclaration csmDeclaration, Set<TypeDescriptor> set) {
        switch (csmDeclaration.getKind()) {
            case CLASS: 
            case UNION: 
            case STRUCT: {
                CsmClass csmClass = (CsmClass)csmDeclaration;
                set.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)csmClass));
                if (this.isCancelled) break;
                for (CsmMember csmMember : csmClass.getMembers()) {
                    if (this.isCancelled) continue;
                    this.processDeclaration((CsmDeclaration)csmMember, set);
                }
                break;
            }
            case ENUM: 
            case TYPEDEF: {
                set.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)csmDeclaration));
                break;
            }
        }
    }
}

