/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.jdesktop.application.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    private static Map<Project, ActionManager> ams;
    private static ActionManager emptyActionManager;
    private Map<String, List<ProxyAction>> actions;
    private List<ProxyAction> actionList;
    private Map<String, List<RADComponent>> boundComponents = new HashMap<String, List<RADComponent>>();
    private List<PropertyChangeListener> pcls;
    private List<ActionChangedListener> acls;
    private FileObject root;
    private Project project;
    private List<FileObject> scanQueue = Collections.synchronizedList(new ArrayList());
    private Timer rescanTimer = new Timer(5000, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList arrayList;
            if (ActionManager.this.scanQueue.isEmpty()) {
                return;
            }
            List list = ActionManager.this.scanQueue;
            synchronized (list) {
                arrayList = new ArrayList(ActionManager.this.scanQueue);
                ActionManager.this.scanQueue.clear();
            }
            for (FileObject fileObject : arrayList) {
                List list2;
                if (fileObject == null || !fileObject.isValid()) continue;
                String string = AppFrameworkSupport.getClassNameForFile(fileObject);
                if (ActionManager.this.actions.containsKey(string)) {
                    list2 = (List)ActionManager.this.actions.get(string);
                    for (ProxyAction proxyAction : list2) {
                        Iterator iterator = ActionManager.this.actionList.iterator();
                        while (iterator.hasNext()) {
                            if (!ActionManager.this.actionsMatch((ProxyAction)iterator.next(), proxyAction)) continue;
                            iterator.remove();
                        }
                    }
                    ActionManager.this.actions.remove(string);
                }
                ActionManager.getActionsFromFile(fileObject, ActionManager.this.actions);
                if (ActionManager.this.actions.containsKey(string)) {
                    list2 = (List)ActionManager.this.actions.get(string);
                    ActionManager.this.actionList.addAll(list2);
                }
                ActionManager.this.fireStructureChanged();
            }
        }
    });
    private static final String TASK_CLASS_TEMPLATE = "    private class MyTask extends org.jdesktop.application.Task<Object, Void> {\n        MyTask(org.jdesktop.application.Application app) {\n            // Runs on the EDT.  Copy GUI state that\n            // doInBackground() depends on from parameters\n            // to MyTask fields, here.\n            super(app);\n__CTOR_CODE__        }\n        @Override protected Object doInBackground() {\n            // Your Task's code here.  This method runs\n            // on a background thread, so don't reference\n            // the Swing GUI from here.\n            return null;  // return your result\n        }\n        @Override protected void succeeded(Object result) {\n            // Runs on the EDT.  Update the GUI based on\n            // the result computed by doInBackground().\n        }\n    }\n";
    private static Set<FormModel> registeredForms;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionManager getActionManager(FileObject fileObject) {
        Project project;
        ActionManager actionManager;
        if (ams == null) {
            ams = Collections.synchronizedMap(new HashMap());
        }
        if ((actionManager = ams.get(project = ActionManager.getProject(fileObject))) != null || !AppFrameworkSupport.isFrameworkEnabledProject(fileObject)) return actionManager;
        Class<ActionManager> clazz = ActionManager.class;
        synchronized (ActionManager.class) {
            if (ams.get(project) != null) return actionManager;
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            actionManager = new ActionManager(project, fileObject2);
            ams.put(project, actionManager);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return actionManager;
        }
    }

    public static ActionManager getActionManager(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            return ActionManager.getActionManager(sourceGroupArray[0].getRootFolder());
        }
        return null;
    }

    private static void addProject(Project project) {
        ActionManager actionManager = ActionManager.getActionManager(project);
        if (actionManager != null) {
            actionManager.rescan();
        }
    }

    private static void removeProject(Project project) {
        if (ams != null) {
            ActionManager actionManager = ams.get(project);
            actionManager.rescanTimer.stop();
            ams.remove(project);
        }
    }

    public static ActionManager getEmptyActionManager() {
        return emptyActionManager;
    }

    public static Set<Project> getKnownProjects() {
        if (ams == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ams.keySet());
    }

    public static boolean clearClosedProjects(Project[] projectArray) {
        boolean bl = false;
        Set<Project> set = ActionManager.getKnownProjects();
        set = new HashSet<Project>(set);
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Project project : projectArray) {
            if (!set.contains(project)) {
                hashSet.add(project);
            }
            set.remove(project);
        }
        if (set.size() > 0) {
            for (Project project : set) {
                ActionManager.removeProject(project);
            }
            bl = true;
        }
        if (hashSet.size() > 0) {
            for (Project project : hashSet) {
                ActionManager.addProject(project);
            }
            bl = true;
        }
        return bl;
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject getApplicationClassFile() {
        String string = AppFrameworkSupport.getApplicationClassName(this.getRoot());
        return string == null ? null : this.getFileForClass(string);
    }

    private ActionManager(Project project, FileObject fileObject) {
        this.project = project;
        this.root = fileObject;
        this.actionList = new ArrayList<ProxyAction>();
        this.pcls = new ArrayList<PropertyChangeListener>();
        this.acls = new ArrayList<ActionChangedListener>();
        this.actions = new HashMap<String, List<ProxyAction>>();
        this.rescanTimer.start();
    }

    public FileObject getRoot() {
        return this.root;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcls.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcls.remove(propertyChangeListener);
    }

    public void addActionChangedListener(ActionChangedListener actionChangedListener) {
        this.acls.add(actionChangedListener);
    }

    public void removeActionChangedListener(ActionChangedListener actionChangedListener) {
        this.acls.remove(actionChangedListener);
    }

    public void rescan() {
        this.actions = new HashMap<String, List<ProxyAction>>();
        FileObject fileObject = this.getRoot();
        if (fileObject != null) {
            ActionManager.scanFolderForActions(fileObject, this.actions);
        }
        this.actionList.clear();
        for (String string : this.actions.keySet()) {
            this.actionList.addAll((Collection<ProxyAction>)this.actions.get(string));
        }
        this.fireStructureChanged();
    }

    public void lazyRescan(FileObject fileObject) {
        if (!this.scanQueue.contains(fileObject)) {
            this.scanQueue.add(fileObject);
        }
    }

    public List<ProxyAction> getAllActions() {
        return this.actionList;
    }

    public Collection<String> getAllClasses() {
        return this.actions.keySet();
    }

    public List<ProxyAction> getActions(String string, boolean bl) {
        List<ProxyAction> list;
        if (bl) {
            ActionManager.getActionsFromFile(this.getFileForClass(string), this.actions);
        }
        return (list = this.actions.get(string)) != null ? list : Collections.emptyList();
    }

    public static List<ProxyAction> getActions(FileObject fileObject, boolean bl) {
        ActionManager actionManager = ActionManager.getActionManager(fileObject);
        if (bl) {
            ActionManager.getActionsFromFile(fileObject, actionManager.actions);
        }
        return actionManager.getActions(AppFrameworkSupport.getClassNameForFile(fileObject), false);
    }

    void jumpToActionSource(ProxyAction proxyAction) {
        FileObject fileObject = this.getFileForClass(proxyAction.getClassname());
        try {
            Integer n = (Integer)new ActionMethodTask<Integer>(fileObject, proxyAction.getMethodName()){

                @Override
                Integer run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                    return (int)compilationController.getTrees().getSourcePositions().getStartPosition(compilationController.getCompilationUnit(), methodTree);
                }
            }.execute();
            int n2 = n;
            Line line = null;
            EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)fileObject).getCookie(EditorCookie.class);
            if (editorCookie != null) {
                if (editorCookie.getDocument() == null) {
                    editorCookie.openDocument();
                }
                editorCookie.open();
                StyledDocument styledDocument = editorCookie.getDocument();
                String string = styledDocument.getText(n2, styledDocument.getLength() - n2);
                int n3 = string.indexOf(123);
                if (n3 >= 0) {
                    while (++n3 < string.length()) {
                        if (string.charAt(n3) <= ' ') continue;
                        n2 += n3;
                        break;
                    }
                }
                Line.Set set = editorCookie.getLineSet();
                int n4 = styledDocument.getParagraphElement(0).getParentElement().getElementIndex(n2);
                line = set.getCurrent(n4);
            }
            if (line == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                line.show(2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ActionMethodTask.class.getName()).log(Level.INFO, null, exception);
        }
    }

    boolean isExistingMethod(String string, String string2) {
        FileObject fileObject = this.getFileForClass(string);
        try {
            Boolean bl = (Boolean)new ActionMethodTask<Boolean>(fileObject, string2){

                @Override
                Boolean run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                    return true;
                }
            }.execute();
            return Boolean.TRUE.equals(bl);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return false;
        }
    }

    boolean createActionMethod(final ProxyAction proxyAction) {
        if (this.isExistingMethod(proxyAction.getClassname(), proxyAction.getMethodName())) {
            return true;
        }
        try {
            String string;
            String string2;
            final FileObject fileObject = this.getFileForClass(proxyAction.getClassname());
            if (proxyAction.isTaskEnabled()) {
                string2 = ActionManager.taskNameForAction(proxyAction);
                string = this.getNonExistingTaskName(proxyAction.getClassname(), string2);
            } else {
                string2 = null;
                string = null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    Tree tree;
                    int n;
                    Tree tree2;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    for (Tree tree32 : compilationUnitTree.getTypeDecls()) {
                        if (tree32.getKind() != Tree.Kind.CLASS) continue;
                        tree2 = (ClassTree)tree32;
                        if (!fileObject.getName().equals(tree2.getSimpleName().toString())) continue;
                        classTree = tree2;
                        break;
                    }
                    if (classTree == null) {
                        return;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    AnnotationTree annotationTree = ActionManager.createAnnotation(proxyAction, treeMaker, workingCopy);
                    ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(annotationTree));
                    if (proxyAction.isTaskEnabled()) {
                        n = AppFrameworkSupport.isViewClass(classTree, (CompilationController)workingCopy);
                        tree2 = treeMaker.Method(modifiersTree, (CharSequence)proxyAction.getMethodName(), (Tree)treeMaker.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{\n" + ActionManager.getTaskInstantiationCode(string2, fileObject, n != 0) + "}", null);
                    } else {
                        tree2 = treeMaker.Method(modifiersTree, (CharSequence)proxyAction.getMethodName(), (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), treeMaker.Block(Collections.emptyList(), false), null);
                    }
                    n = -1;
                    List<? extends Tree> list = classTree.getMembers();
                    int n2 = list.size();
                    ListIterator<? extends Tree> listIterator = list.listIterator(n2);
                    while (listIterator.hasPrevious()) {
                        tree = listIterator.previous();
                        if (tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.CLASS) {
                            n = n2;
                            break;
                        }
                        --n2;
                    }
                    tree = n < 0 ? treeMaker.addClassMember(classTree, tree2) : treeMaker.insertClassMember(classTree, n, tree2);
                    workingCopy.rewrite((Tree)classTree, tree);
                }
            });
            modificationResult.commit();
            if (string != null) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return false;
                }
                if (editorCookie.getDocument() == null) {
                    editorCookie.openDocument();
                }
                StyledDocument styledDocument = editorCookie.getDocument();
                Integer n = (Integer)new ActionMethodTask<Integer>(fileObject, proxyAction.getMethodName()){

                    @Override
                    Integer run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                        return (int)compilationController.getTrees().getSourcePositions().getEndPosition(compilationController.getCompilationUnit(), methodTree);
                    }
                }.execute();
                Element element = styledDocument.getDefaultRootElement();
                int n2 = element.getElement(element.getElementIndex(n + 1)).getStartOffset();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n").append(this.getTaskClassImplCode(string, null)).append("\n");
                styledDocument.insertString(n2, stringBuilder.toString(), null);
            }
            this.generateProperties(proxyAction, fileObject);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return false;
        }
    }

    private static String taskNameForAction(ProxyAction proxyAction) {
        String string = proxyAction.getId();
        return string.substring(0, 1).toUpperCase() + string.substring(1) + "Task";
    }

    private String getNonExistingTaskName(String string, final String string2) {
        FileObject fileObject = this.getFileForClass(string);
        try {
            String string3 = (String)new ClassTask<String>(fileObject){

                @Override
                String run(CompilationController compilationController, ClassTree classTree, TypeElement typeElement) {
                    for (TypeElement typeElement2 : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
                        if (!typeElement2.getSimpleName().toString().equals(string2)) continue;
                        return null;
                    }
                    return string2;
                }
            }.execute();
            return string3;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return string2;
        }
    }

    private static AnnotationTree createAnnotation(ProxyAction proxyAction, TreeMaker treeMaker, WorkingCopy workingCopy) {
        LinkedList<AssignmentTree> linkedList = new LinkedList<AssignmentTree>();
        for (String string : ProxyAction.getAnnotationAttributeNames()) {
            ExpressionTree expressionTree;
            if (!proxyAction.isAnnotationAttributeSet(string)) continue;
            Object object = proxyAction.getAnnotationAttributeValue(string);
            if (object instanceof String) {
                expressionTree = treeMaker.Literal(object);
            } else {
                if (!(object instanceof ProxyAction.BlockingType)) continue;
                expressionTree = treeMaker.MemberSelect((ExpressionTree)treeMaker.MemberSelect(treeMaker.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), (CharSequence)"BlockingScope"), (CharSequence)object.toString());
            }
            IdentifierTree identifierTree = treeMaker.Identifier((CharSequence)string);
            AssignmentTree assignmentTree = treeMaker.Assignment((ExpressionTree)identifierTree, expressionTree);
            linkedList.add(assignmentTree);
        }
        return treeMaker.Annotation((Tree)treeMaker.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Action")), linkedList);
    }

    private static String getTaskInstantiationCode(String string, FileObject fileObject, boolean bl) {
        return "return new " + string + "(" + (bl ? "getApplication()" : AppFrameworkSupport.getApplicationCode(fileObject)) + ");\n";
    }

    private String getTaskClassImplCode(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && !string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if (string2.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = "            ";
            int n = 0;
            boolean bl = true;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\n') {
                    if (bl) {
                        stringBuilder.append("\n");
                    } else {
                        stringBuilder.append(string2.substring(n, i + 1));
                    }
                    bl = true;
                    n = i + 1;
                    continue;
                }
                if (c <= ' ' || !bl) continue;
                stringBuilder.append(string3);
                bl = false;
                n = i;
            }
            string2 = stringBuilder.toString();
        }
        return TASK_CLASS_TEMPLATE.replace("__CTOR_CODE__", string2).replace("MyTask", string);
    }

    public List<RADComponent> getBoundComponents(ProxyAction proxyAction) {
        if (!this.boundComponents.containsKey(this.getKey(proxyAction))) {
            return new ArrayList<RADComponent>();
        }
        return this.boundComponents.get(this.getKey(proxyAction));
    }

    public void removeAllBoundComponents(FormModel formModel) {
        for (String string : this.boundComponents.keySet()) {
            List<RADComponent> list = this.boundComponents.get(string);
            Iterator<RADComponent> iterator = list.iterator();
            while (iterator.hasNext()) {
                RADComponent rADComponent = iterator.next();
                if (rADComponent == null || rADComponent.getFormModel() != formModel) continue;
                iterator.remove();
            }
        }
    }

    public void addNewAction(ProxyAction proxyAction) {
        List<ProxyAction> list = this.actions.get(proxyAction.getClassname());
        if (list == null) {
            list = new ArrayList<ProxyAction>();
            this.actions.put(proxyAction.getClassname(), list);
        }
        list.add(proxyAction);
        this.actionList.add(proxyAction);
        this.fireStructureChanged();
    }

    private boolean safeReplace(List<ProxyAction> list, ProxyAction proxyAction) {
        for (int i = 0; i < this.actionList.size(); ++i) {
            ProxyAction proxyAction2 = this.actionList.get(i);
            if (!this.actionsMatch(proxyAction, proxyAction2)) continue;
            this.actionList.remove(proxyAction2);
            this.actionList.add(i, proxyAction);
            return true;
        }
        return false;
    }

    public void updateAction(ProxyAction proxyAction) {
        List<ProxyAction> list = this.getActions(proxyAction.getClassname(), false);
        boolean bl = false;
        for (ProxyAction object2 : list) {
            if (!object2.getId().equals(proxyAction.getId())) continue;
            int rADComponent = list.indexOf(object2);
            if (rADComponent >= 0) {
                list.remove(rADComponent);
                list.add(rADComponent, proxyAction);
            }
            for (int rADProperty = 0; rADProperty < this.actionList.size(); ++rADProperty) {
                ProxyAction illegalAccessException = this.actionList.get(rADProperty);
                if (!this.actionsMatch(proxyAction, illegalAccessException)) continue;
                this.actionList.remove(illegalAccessException);
                this.actionList.add(rADProperty, proxyAction);
            }
            bl = true;
            break;
        }
        if (this.getFileForClass(proxyAction.getClassname()) == null) {
            bl = this.safeReplace(this.actionList, proxyAction);
        }
        if (!bl) {
            if (this.getFileForClass(proxyAction.getClassname()) != null) {
                list.add(proxyAction);
            }
            this.actionList.add(proxyAction);
        }
        if (this.getFileForClass(proxyAction.getClassname()) != null) {
            this.updateActionMethod(proxyAction, this.getFileForClass(proxyAction.getClassname()));
        }
        this.fireActionChanged(proxyAction);
        List<RADComponent> list2 = this.getBoundComponents(proxyAction);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            RADProperty rADProperty;
            RADComponent rADComponent = (RADComponent)iterator.next();
            if (rADComponent == null || (rADProperty = rADComponent.getBeanProperty("action")) == null) continue;
            try {
                if (!(rADProperty.getValue() instanceof ProxyAction)) continue;
                rADProperty.setValue(null);
                rADProperty.setValue((Object)proxyAction);
            }
            catch (IllegalAccessException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void updateActionMethod(final ProxyAction proxyAction, final FileObject fileObject) {
        try {
            String[] stringArray;
            String string;
            String string2;
            if (proxyAction.isTaskEnabled()) {
                string2 = ActionManager.taskNameForAction(proxyAction);
                string = this.getNonExistingTaskName(proxyAction.getClassname(), string2);
                stringArray = new String[1];
            } else {
                string2 = null;
                string = null;
                stringArray = null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    MethodTree methodTree;
                    Tree tree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    for (Tree object22 : compilationUnitTree.getTypeDecls()) {
                        if (object22.getKind() != Tree.Kind.CLASS) continue;
                        tree = (ClassTree)object22;
                        if (!fileObject.getName().equals(tree.getSimpleName().toString())) continue;
                        classTree = tree;
                        break;
                    }
                    if (classTree == null) {
                        return;
                    }
                    Trees trees = workingCopy.getTrees();
                    TypeElement typeElement = (TypeElement)trees.getElement(trees.getPath(compilationUnitTree, classTree));
                    tree = null;
                    ExecutableElement executableElement = null;
                    AnnotationTree annotationTree = null;
                    for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        if (!executableElement2.getSimpleName().toString().equals(proxyAction.getMethodName()) || !executableElement2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                        methodTree = trees.getTree(executableElement2);
                        for (AnnotationTree annotationTree2 : methodTree.getModifiers().getAnnotations()) {
                            TypeElement typeElement2 = (TypeElement)trees.getElement(trees.getPath(compilationUnitTree, annotationTree2.getAnnotationType()));
                            if (!typeElement2.getQualifiedName().toString().equals("org.jdesktop.application.Action")) continue;
                            annotationTree = annotationTree2;
                            break;
                        }
                        if (annotationTree == null) continue;
                        tree = methodTree;
                        executableElement = executableElement2;
                        break;
                    }
                    if (tree == null) {
                        return;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    AnnotationTree annotationTree3 = ActionManager.createAnnotation(proxyAction, treeMaker, workingCopy);
                    workingCopy.rewrite(annotationTree, (Tree)annotationTree3);
                    if (ActionManager.isAsyncActionMethod(executableElement) != proxyAction.isTaskEnabled()) {
                        BlockTree blockTree = tree.getBody();
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, blockTree);
                        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, blockTree);
                        String string3 = ActionManager.getMethodBodyWithoutBraces(workingCopy.getText().substring(n, n2));
                        if (proxyAction.isTaskEnabled()) {
                            if (string != null) {
                                stringArray[0] = string3;
                                string3 = "";
                            } else {
                                string3 = ActionManager.getCommentedBodyText(string3);
                            }
                            boolean bl = AppFrameworkSupport.isViewClass(classTree, (CompilationController)workingCopy);
                            methodTree = treeMaker.Method(tree.getModifiers(), (CharSequence)tree.getName(), (Tree)treeMaker.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), "{\n" + ActionManager.getTaskInstantiationCode(string2, fileObject, bl) + string3 + "}", null);
                        } else {
                            methodTree = treeMaker.Method(tree.getModifiers(), (CharSequence)tree.getName(), (Tree)treeMaker.PrimitiveType(TypeKind.VOID), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), "{\n" + ActionManager.getCommentedBodyText(string3) + "}", null);
                        }
                        workingCopy.rewrite(tree, (Tree)methodTree);
                    }
                }
            });
            modificationResult.commit();
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            if (editorCookie.getDocument() == null) {
                editorCookie.openDocument();
            }
            StyledDocument styledDocument = editorCookie.getDocument();
            if (string != null) {
                Integer n = (Integer)new ActionMethodTask<Integer>(fileObject, proxyAction.getMethodName()){

                    @Override
                    Integer run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                        return (int)compilationController.getTrees().getSourcePositions().getEndPosition(compilationController.getCompilationUnit(), methodTree);
                    }
                }.execute();
                Element element = styledDocument.getDefaultRootElement();
                int n2 = element.getElement(element.getElementIndex(n) + 1).getStartOffset();
                styledDocument.insertString(n2, "\n" + this.getTaskClassImplCode(string, stringArray[0]), null);
            }
            this.generateProperties(proxyAction, fileObject);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    private void generateProperties(ProxyAction proxyAction, FileObject fileObject) {
        String string;
        if (proxyAction.isAnnotationAttributeSet("enabledProperty") && !ActionManager.findBooleanProperty(string = (String)proxyAction.getAnnotationAttributeValue("enabledProperty"), fileObject)) {
            ActionManager.generatePropertyGetterAndSetter(string, fileObject);
        }
        if (proxyAction.isAnnotationAttributeSet("selectedProperty") && !ActionManager.findBooleanProperty(string = (String)proxyAction.getAnnotationAttributeValue("selectedProperty"), fileObject)) {
            ActionManager.generatePropertyGetterAndSetter(string, fileObject);
        }
    }

    private static boolean findBooleanProperty(String string, FileObject fileObject) {
        List<String> list = ActionManager.findBooleanProperties(fileObject);
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean generatePropertyGetterAndSetter(String string, FileObject fileObject) {
        try {
            Object object;
            int n;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return false;
            }
            if (editorCookie.getDocument() == null) {
                editorCookie.openDocument();
            }
            StyledDocument styledDocument = editorCookie.getDocument();
            if (editorCookie instanceof FormEditorSupport) {
                styledDocument = editorCookie.getDocument();
                n = ((FormEditorSupport)editorCookie).getVariablesSection().getStartPosition().getOffset();
            } else {
                object = (Integer)new ClassTask<Integer>(fileObject){

                    @Override
                    Integer run(CompilationController compilationController, ClassTree classTree, TypeElement typeElement) {
                        return (int)compilationController.getTrees().getSourcePositions().getEndPosition(compilationController.getCompilationUnit(), classTree);
                    }
                }.execute();
                Element element = styledDocument.getDefaultRootElement();
                n = element.getElement(element.getElementIndex((Integer)object)).getStartOffset();
            }
            object = ActionManager.getPropertyGetterAndSetterBodyText(string);
            styledDocument.insertString(n, ((String)object).toString(), null);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return false;
        }
    }

    private static String getPropertyGetterAndSetterBodyText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "    ";
        String string3 = "is" + string.substring(0, 1).toUpperCase() + string.substring(1);
        String string4 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        stringBuilder.append(string2 + "private boolean " + string + " = false;\n");
        stringBuilder.append(string2 + "public boolean " + string3 + "() {\n");
        stringBuilder.append(string2 + string2 + "return " + string + ";\n");
        stringBuilder.append(string2 + "}\n");
        stringBuilder.append("\n");
        stringBuilder.append(string2 + "public void " + string4 + "(boolean b) {\n");
        stringBuilder.append(string2 + string2 + "boolean old = " + string3 + "();\n");
        stringBuilder.append(string2 + string2 + "this." + string + " = b;\n");
        stringBuilder.append(string2 + string2 + "firePropertyChange(\"" + string + "\", old, " + string3 + "());\n");
        stringBuilder.append(string2 + "}\n\n");
        return stringBuilder.toString();
    }

    private static String getCommentedBodyText(String string) {
        string = ActionManager.getMethodBodyWithoutBraces(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\n' && i + 1 != string.length()) continue;
            stringBuilder.append("// ");
            stringBuilder.append(string.substring(n, i + 1));
            n = i + 1;
        }
        return stringBuilder.toString();
    }

    private static String getMethodBodyWithoutBraces(String string) {
        char c;
        int n;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < string.length() && ((c = string.charAt(n)) <= ' ' || c == '{' && n2 < 0); ++n) {
            if (c == '\n' && n2 >= 0) {
                n2 = n + 1;
                break;
            }
            if (c != '{') continue;
            n2 = n + 1;
        }
        for (n = string.length() - 1; n >= 0 && ((c = string.charAt(n)) <= ' ' || c == '}' && n3 < 0); --n) {
            if (c == '\n' && n2 >= 0) {
                n3 = n + 1;
                break;
            }
            if (c != '}') continue;
            n3 = n;
        }
        return string.substring(n2 >= 0 ? n2 : 0, n3 >= 0 ? n3 : string.length());
    }

    private static int[] getAnnotationPositions(ProxyAction proxyAction, FileObject fileObject) throws IOException {
        return (int[])new ActionMethodTask<int[]>(fileObject, proxyAction.getMethodName()){

            @Override
            int[] run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                Trees trees = compilationController.getTrees();
                ModifiersTree modifiersTree = methodTree.getModifiers();
                for (AnnotationTree annotationTree : modifiersTree.getAnnotations()) {
                    TypeElement typeElement = (TypeElement)trees.getElement(trees.getPath(compilationUnitTree, annotationTree.getAnnotationType()));
                    if (!typeElement.getQualifiedName().toString().equals("org.jdesktop.application.Action")) continue;
                    SourcePositions sourcePositions = trees.getSourcePositions();
                    return new int[]{(int)sourcePositions.getStartPosition(compilationUnitTree, annotationTree), (int)sourcePositions.getEndPosition(compilationUnitTree, annotationTree)};
                }
                return null;
            }
        }.execute();
    }

    public void deleteAction(ProxyAction proxyAction) {
        FileObject fileObject;
        Object object;
        String string = proxyAction.getClassname();
        FileObject fileObject2 = this.getFileForClass(string);
        DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(fileObject2, true);
        Collection<String> collection = designResourceMap.collectKeys(proxyAction.getId() + "\\..*", true);
        for (String object22 : collection) {
            object = designResourceMap.getResourceValue(object22, String.class);
            if (object == null) continue;
            designResourceMap.removeResourceValue((ResourceValueImpl)object);
        }
        Iterator<Object> iterator = this.getActions(string, false).iterator();
        while (iterator.hasNext()) {
            ProxyAction proxyAction2 = (ProxyAction)iterator.next();
            if (!proxyAction2.getId().equals(proxyAction.getId())) continue;
            iterator.remove();
            object = this.actionList.iterator();
            while (object.hasNext()) {
                ProxyAction proxyAction3 = (ProxyAction)object.next();
                if (!this.actionsMatch(proxyAction3, proxyAction2)) continue;
                object.remove();
            }
            break block3;
        }
        if (this.hasFormFile(fileObject2) && (fileObject = this.getFormFile(fileObject2)).canRead()) {
            try {
                object = this.getFormModel(fileObject);
                this.deleteAction(proxyAction, (FormModel)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ActionManager.deleteActionAnnotation(proxyAction, fileObject2);
    }

    private static void deleteActionAnnotation(ProxyAction proxyAction, FileObject fileObject) {
        try {
            int n;
            int[] nArray = ActionManager.getAnnotationPositions(proxyAction, fileObject);
            if (nArray == null) {
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            StyledDocument styledDocument = editorCookie.getDocument();
            int n2 = nArray[0];
            int n3 = nArray[1];
            String string = styledDocument.getText(n2, n3 - n2);
            Element element = styledDocument.getDefaultRootElement();
            Element element2 = element.getElement(element.getElementIndex(n2));
            int n4 = element2.getStartOffset();
            if (styledDocument.getText(n4, (n = element2.getEndOffset()) - n4).trim().equals(string)) {
                n2 = n4;
                n3 = n;
            }
            styledDocument.remove(n2, n3 - n2);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public void addRADComponent(ProxyAction proxyAction, RADComponent rADComponent) {
        if (rADComponent == null) {
            return;
        }
        if (!this.boundComponents.containsKey(this.getKey(proxyAction))) {
            this.boundComponents.put(this.getKey(proxyAction), new ArrayList());
        }
        if (this.boundComponents.get(this.getKey(proxyAction)).contains(rADComponent)) {
            return;
        }
        this.boundComponents.get(this.getKey(proxyAction)).add(rADComponent);
        this.fireActionChanged(proxyAction);
    }

    void removeRADComponent(ProxyAction proxyAction, RADComponent rADComponent) {
        if (this.boundComponents.containsKey(this.getKey(proxyAction))) {
            this.boundComponents.get(this.getKey(proxyAction)).remove(rADComponent);
        }
        this.fireActionChanged(proxyAction);
    }

    private static Project getProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project;
    }

    private static void scanFolderForActions(FileObject fileObject, Map<String, List<ProxyAction>> map) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                ActionManager.scanFolderForActions(fileObject2, map);
                continue;
            }
            if (!fileObject2.getExt().equalsIgnoreCase("java")) continue;
            ActionManager.getActionsFromFile(fileObject2, map);
        }
    }

    private static void getActionsFromFile(FileObject fileObject, Map<String, List<ProxyAction>> map) {
        try {
            List list = (List)new ClassTask<List<ProxyAction>>(fileObject){

                @Override
                List<ProxyAction> run(CompilationController compilationController, ClassTree classTree, TypeElement typeElement) {
                    Iterable<Tree> iterable;
                    LinkedList<TypeElement> linkedList = new LinkedList<TypeElement>();
                    Tree tree = classTree.getExtendsClause();
                    if (tree != null) {
                        iterable = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
                        Object object = compilationController.getTrees().getElement((TreePath)iterable);
                        while (object != null && object.getKind() == ElementKind.CLASS) {
                            TypeElement typeElement2 = (TypeElement)object;
                            linkedList.add(0, typeElement2);
                            TypeMirror typeMirror = typeElement2.getSuperclass();
                            object = typeMirror.getKind() == TypeKind.DECLARED ? ((DeclaredType)typeMirror).asElement() : null;
                        }
                    }
                    linkedList.add(typeElement);
                    iterable = null;
                    for (TypeElement typeElement2 : linkedList) {
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                            Action action;
                            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || (action = executableElement.getAnnotation(Action.class)) == null) continue;
                            String string = executableElement.getSimpleName().toString();
                            if (action.name() != null && !"".equals(action.name())) {
                                string = action.name();
                            }
                            ProxyAction proxyAction = new ProxyAction(typeElement2.getQualifiedName().toString(), string, executableElement.getSimpleName().toString());
                            ActionManager.initActionFromAnnotation(proxyAction, executableElement, action);
                            if (iterable == null) {
                                iterable = new ArrayList();
                            }
                            iterable.add(proxyAction);
                        }
                    }
                    return iterable;
                }
            }.execute();
            if (list != null && !list.isEmpty()) {
                String string = AppFrameworkSupport.getClassNameForFile(fileObject);
                map.put(string, list);
                for (ProxyAction proxyAction : list) {
                    proxyAction.setResourceMap(ResourceUtils.getDesignResourceMap(fileObject, true));
                    proxyAction.loadFromResourceMap();
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    static List<String> findBooleanProperties(FileObject fileObject) {
        try {
            return (List)new ClassTask<List<String>>(fileObject){

                @Override
                List<String> run(CompilationController compilationController, ClassTree classTree, TypeElement typeElement) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        String string;
                        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !TypeKind.BOOLEAN.equals((Object)executableElement.getReturnType().getKind()) || !(string = executableElement.getSimpleName().toString()).startsWith("is")) continue;
                        arrayList.add(string.substring(2, 3).toLowerCase() + string.substring(3));
                    }
                    return arrayList;
                }
            }.execute();
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    static void initActionFromSource(final ProxyAction proxyAction, FileObject fileObject) {
        try {
            new ActionMethodTask<Object>(fileObject, proxyAction.getMethodName()){

                @Override
                Object run(CompilationController compilationController, MethodTree methodTree, ExecutableElement executableElement) {
                    Action action = executableElement.getAnnotation(Action.class);
                    if (action != null) {
                        ActionManager.initActionFromAnnotation(proxyAction, executableElement, action);
                    }
                    return null;
                }
            }.execute();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    static void initActionFromAnnotation(ProxyAction proxyAction, ExecutableElement executableElement, Action action) {
        boolean bl = ActionManager.isAsyncActionMethod(executableElement);
        proxyAction.setTaskEnabled(bl);
        proxyAction.setEnabledName(action.enabledProperty());
        proxyAction.setSelectedName(action.selectedProperty());
        proxyAction.setBlockingType(ProxyAction.BlockingType.valueOf(action.block().toString()));
    }

    private static boolean isAsyncActionMethod(ExecutableElement executableElement) {
        TypeMirror typeMirror = executableElement.getReturnType();
        return typeMirror.getKind() != TypeKind.VOID;
    }

    private void deleteAction(ProxyAction proxyAction, FormModel formModel) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        List list = formModel.getComponentList();
        for (RADComponent rADComponent : list) {
            ProxyAction proxyAction2;
            RADProperty rADProperty = rADComponent.getBeanProperty("action");
            if (rADProperty == null || !this.actionsMatch(proxyAction2 = (ProxyAction)rADProperty.getValue(), proxyAction)) continue;
            rADProperty.setValue(null);
        }
    }

    FileObject getFileForClass(String string) {
        return AppFrameworkSupport.getFileForClass(this.getRoot(), string);
    }

    private FormModel getFormModel(FileObject fileObject) throws DataObjectNotFoundException {
        FormDataObject formDataObject = (FormDataObject)FormDataObject.find((FileObject)fileObject);
        if (!formDataObject.getFormEditor().isOpened()) {
            formDataObject.getFormEditor().loadForm();
        }
        FormModel formModel = formDataObject.getFormEditor().getFormModel();
        return formModel;
    }

    private boolean hasFormFile(FileObject fileObject) {
        return fileObject.existsExt("form");
    }

    private FileObject getFormFile(FileObject fileObject) {
        return fileObject.getParent().getFileObject(fileObject.getName() + ".form");
    }

    public boolean actionsMatch(ProxyAction proxyAction, ProxyAction proxyAction2) {
        if (proxyAction == null || proxyAction2 == null) {
            return false;
        }
        return proxyAction.getId().equals(proxyAction2.getId()) && proxyAction.getClassname().equals(proxyAction2.getClassname());
    }

    private String getKey(ProxyAction proxyAction) {
        if (proxyAction == null) {
            return "null";
        }
        String string = new String(proxyAction.getId() + ":" + proxyAction.getClassname()).intern();
        return string;
    }

    private void fireStructureChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(ActionManager.this, "allActions", null, ActionManager.this.actions);
                for (PropertyChangeListener propertyChangeListener : ActionManager.this.pcls) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        });
    }

    private void fireActionChanged(final ProxyAction proxyAction) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (ActionChangedListener actionChangedListener : ActionManager.this.acls) {
                    actionChangedListener.actionChanged(proxyAction);
                }
            }
        });
    }

    public static void registerFormModel(FormModel formModel, final FileObject fileObject) {
        if (formModel == null) {
            return;
        }
        if (fileObject == null) {
            return;
        }
        if (registeredForms.contains(formModel)) {
            return;
        }
        formModel.addFormModelListener(new FormModelListener(){

            public void formChanged(FormModelEvent[] formModelEventArray) {
                if (formModelEventArray != null) {
                    for (FormModelEvent formModelEvent : formModelEventArray) {
                        if (formModelEvent.getChangeType() != 3) continue;
                        ActionManager actionManager = ActionManager.getActionManager(fileObject);
                        if (actionManager != null) {
                            actionManager.removeAllBoundComponents(formModelEvent.getFormModel());
                        }
                        final 16 var7_7 = this;
                        final FormModel formModel = formModelEvent.getFormModel();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                formModel.removeFormModelListener(var7_7);
                                registeredForms.remove(formModel);
                            }
                        });
                    }
                }
            }
        });
        registeredForms.add(formModel);
    }

    static {
        emptyActionManager = new ActionManager(null, null);
        registeredForms = new HashSet<FormModel>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ActionMethodTask<T>
    extends ClassTask<T> {
        String methodName;

        ActionMethodTask(FileObject fileObject, String string) {
            super(fileObject);
            this.methodName = string;
        }

        @Override
        T run(CompilationController compilationController, ClassTree classTree, TypeElement typeElement) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!executableElement.getSimpleName().toString().equals(this.methodName) || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                MethodTree methodTree = compilationController.getTrees().getTree(executableElement);
                return this.run(compilationController, methodTree, executableElement);
            }
            return null;
        }

        abstract T run(CompilationController var1, MethodTree var2, ExecutableElement var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ClassTask<T>
    implements CancellableTask<CompilationController> {
        FileObject sourceFile;
        private T result;

        ClassTask(FileObject fileObject) {
            this.sourceFile = fileObject;
        }

        T execute() throws IOException {
            JavaSource.forFileObject((FileObject)this.sourceFile).runUserActionTask((Task)this, true);
            return this.result;
        }

        abstract T run(CompilationController var1, ClassTree var2, TypeElement var3);

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
                if (tree.getKind() != Tree.Kind.CLASS) continue;
                ClassTree classTree = (ClassTree)tree;
                if (!this.sourceFile.getName().equals(classTree.getSimpleName().toString())) continue;
                TreePath treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), classTree);
                TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
                this.result = this.run(compilationController, classTree, typeElement);
                return;
            }
        }
    }

    public static interface ActionChangedListener {
        public void actionChanged(ProxyAction var1);
    }
}

