/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.swingapp.templates.AppProjectGenerator;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.netbeans.modules.swingapp.templates.ConfigureProjectVisualPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewAppWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private WizardDescriptor wizard;
    private int panelIndex;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private WizardDescriptor.InstantiatingIterator appShellIterator;
    private EventListenerList listenerList;
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    void setAppShellIterator(WizardDescriptor.InstantiatingIterator instantiatingIterator) {
        if (this.appShellIterator != null) {
            this.appShellIterator.removeChangeListener((ChangeListener)this);
            this.appShellIterator.uninitialize(this.wizard);
        }
        this.appShellIterator = instantiatingIterator;
        if (this.appShellIterator != null) {
            this.appShellIterator.initialize(this.wizard);
            this.appShellIterator.addChangeListener((ChangeListener)this);
        }
        if (this.panelIndex >= this.panels.length) {
            this.panelIndex = this.panels.length - 1;
        }
        this.initSteps();
        this.updateSteps();
        this.fireStateChanged();
    }

    WizardDescriptor.InstantiatingIterator getAppShellIterator() {
        return this.appShellIterator;
    }

    private void updateSteps() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        jComponent.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
        jComponent.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, this.panelIndex);
    }

    private void initSteps() {
        Object object;
        String[] stringArray = new String[]{NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name")};
        if (this.appShellIterator != null && (object = ((JComponent)this.appShellIterator.current().getComponent()).getClientProperty(WIZARD_PANEL_CONTENT_DATA)) instanceof String[]) {
            String[] stringArray2;
            for (String string : stringArray2 = (String[])object) {
                if (string != stringArray[0]) continue;
                this.steps = stringArray2;
                return;
            }
            this.steps = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, this.steps, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, this.steps, stringArray.length, stringArray2.length);
            return;
        }
        this.steps = stringArray;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.panelIndex = 0;
        this.panels = new WizardDescriptor.Panel[]{new ConfigureProjectPanel(this)};
        this.initSteps();
        this.updateSteps();
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.panelIndex < this.panels.length ? this.panels[this.panelIndex] : this.appShellIterator.current();
    }

    public boolean hasNext() {
        if (this.panelIndex + 1 < this.panels.length) {
            return true;
        }
        if (this.appShellIterator != null) {
            return this.panelIndex + 1 == this.panels.length ? true : this.appShellIterator.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
        if (this.panelIndex > this.panels.length) {
            this.appShellIterator.nextPanel();
        }
        this.updateSteps();
    }

    public void previousPanel() {
        --this.panelIndex;
        if (this.panelIndex >= this.panels.length) {
            this.appShellIterator.previousPanel();
        }
        this.updateSteps();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    public Set instantiate() throws IOException {
        LogRecord logRecord;
        Object object;
        File file = (File)this.wizard.getProperty("projdir");
        if (file == null) {
            return null;
        }
        final File file2 = FileUtil.normalizeFile((File)file);
        FileObject fileObject = (FileObject)this.wizard.getProperty("appshell");
        String[] stringArray = NewAppWizardIterator.getTemplateNames(fileObject);
        String string = file2.getName();
        String string2 = (String)this.wizard.getProperty("appname");
        String[] stringArray2 = NewAppWizardIterator.getSubstituteNames(string, string2);
        FileObject fileObject2 = AppProjectGenerator.createProjectFromTemplate(fileObject, file2, stringArray, stringArray2);
        ProjectChooser.setProjectsFolder((File)file2.getParentFile());
        FileObject fileObject3 = AppProjectGenerator.getGeneratedFile(fileObject2, "src/applicationpackage/ShellApp.java", stringArray, stringArray2);
        FileObject fileObject4 = AppProjectGenerator.getGeneratedFile(fileObject2, "src/applicationpackage/ShellView.java", stringArray, stringArray2);
        this.wizard.putProperty("mainForm", (Object)fileObject4);
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        Set set = null;
        if (this.appShellIterator != null) {
            set = this.appShellIterator.instantiate();
        } else {
            object = Logger.getLogger("org.netbeans.ui.metrics.swingapp");
            logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CREATE_JDA");
            logRecord.setLoggerName(((Logger)object).getName());
            logRecord.setParameters(new Object[]{"JDA_APP_TYPE_BASIC"});
            ((Logger)object).log(logRecord);
        }
        linkedHashSet.add(fileObject2);
        if (fileObject3 != null) {
            linkedHashSet.add(fileObject3);
        }
        if (set != null) {
            linkedHashSet.addAll(set);
        }
        NewAppWizardIterator.collectForms(fileObject2.getFileObject("src"), linkedHashSet);
        if (fileObject4 != null) {
            linkedHashSet.remove(fileObject4);
            linkedHashSet.add(fileObject4);
        }
        SharableLibrariesUtils.setLastProjectSharable(((object = (String)this.wizard.getProperty("sharedLibraries")) != null ? 1 : 0) != 0);
        if (object != null) {
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separatorChar;
            }
            object = (String)object + "nblibraries.properties";
            logRecord = FileOwnerQuery.getOwner((FileObject)fileObject4);
            if (logRecord == null) {
                Object object2 = object;
                OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener((String)object2, fileObject4){
                    final /* synthetic */ String val$finalLibrariesLocation;
                    final /* synthetic */ FileObject val$mainFormFO;
                    {
                        this.val$finalLibrariesLocation = string;
                        this.val$mainFormFO = fileObject;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                            File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                            if (!file2.equals(file)) continue;
                            NewAppWizardIterator.enableShareableLibraries(this.val$finalLibrariesLocation, FileOwnerQuery.getOwner((FileObject)this.val$mainFormFO));
                            break;
                        }
                        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    }
                });
            } else {
                NewAppWizardIterator.enableShareableLibraries((String)object, (Project)logRecord);
            }
        }
        return linkedHashSet;
    }

    private static void enableShareableLibraries(String string, Project project) {
        try {
            FileObject fileObject = project.getProjectDirectory();
            Method method = project.getClass().getMethod("getAntProjectHelper", new Class[0]);
            AntProjectHelper antProjectHelper = (AntProjectHelper)method.invoke((Object)project, new Object[0]);
            method = project.getClass().getMethod("getReferenceHelper", new Class[0]);
            ReferenceHelper referenceHelper = (ReferenceHelper)method.invoke((Object)project, new Object[0]);
            antProjectHelper.setLibrariesLocation(string);
            NewAppWizardIterator.copyRequiredLibraries(antProjectHelper, referenceHelper, fileObject);
            ProjectManager.getDefault().saveProject(project);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
    }

    public static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, FileObject fileObject) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("test");
        FileObject[] fileObjectArray = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/execute").getRoots();
        List<FileObject> list = Arrays.asList(fileObjectArray);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list2 = library.getContent("classpath");
            if (list2.size() <= 0) continue;
            boolean bl = true;
            for (URL uRL : list2) {
                if (list.contains(URLMapper.findFileObject((URL)uRL))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            linkedList.add(library.getName());
        }
        linkedList.add("CopyLibs");
        for (String string : linkedList) {
            if (referenceHelper.getProjectLibraryManager().getLibrary(string) != null) continue;
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary(string));
        }
    }

    private static void collectForms(FileObject fileObject, Set<FileObject> set) {
        if (fileObject == null || !fileObject.isFolder()) {
            return;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                NewAppWizardIterator.collectForms(fileObject2, set);
            }
            if (!fileObject2.getExt().equalsIgnoreCase("java") || !fileObject2.existsExt("form")) continue;
            try {
                fileObject2.setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
                set.add(fileObject2);
            }
            catch (IOException iOException) {
                Logger.getLogger(NewAppWizardIterator.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    private static String[] getTemplateNames(FileObject fileObject) {
        return new String[]{fileObject.getName(), "applicationpackage", "ShellApp", "ShellView", "ShellAboutBox", "UTF-\\u0038"};
    }

    private static String[] getSubstituteNames(String string, String string2) {
        String string3;
        int n = string2.lastIndexOf(46);
        String string4 = string2.substring(0, n);
        if (!(string2 = string2.substring(n + 1)).endsWith(string3 = "Application") && !string2.endsWith(string3 = "App")) {
            string3 = null;
        }
        String string5 = string3 != null ? string2.substring(0, string2.length() - string3.length()) : string2;
        return new String[]{string, string4, string2, string5 + "View", string5 + "AboutBox", FileEncodingQuery.getDefaultEncoding().name()};
    }
}

