/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.DefaultDBFactory;
import org.netbeans.modules.dbschema.nodes.TableElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class TableChildren
extends Children.Keys {
    protected static HashMap propToFilter;
    protected DBElement element;
    protected TableElementFilter filter;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;
    private static Comparator comparator;

    public TableChildren(DBElement dBElement) {
        this(DefaultDBFactory.READ_ONLY, dBElement);
    }

    public TableChildren(DBElementNodeFactory dBElementNodeFactory, DBElement dBElement) {
        this.element = dBElement;
        this.factory = dBElementNodeFactory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return TableElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof TableElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (TableElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        this.refreshAllKeys();
        if (this.wPropL == null) {
            this.propL = new DBElementListener();
            this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        }
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof ColumnElement) {
            return new Node[]{this.factory.createColumnNode((ColumnElement)object)};
        }
        if (object instanceof ColumnPairElement) {
            return new Node[]{this.factory.createColumnPairNode((ColumnPairElement)object)};
        }
        if (this.element instanceof TableElement) {
            boolean bl = this.isViewSupport((TableElement)this.element);
            if (((TableElement)this.element).isTableOrView() || bl) {
                if (object instanceof IndexElement) {
                    return new Node[]{this.factory.createIndexNode((IndexElement)object)};
                }
                if (object instanceof ForeignKeyElement) {
                    return new Node[]{this.factory.createForeignKeyNode((ForeignKeyElement)object)};
                }
            }
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(63);
    }

    protected void refreshKeys(int n) {
        int[] nArray = this.getOrder();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) != 0 || this.cpl[i] == null) {
                this.cpl[i] = this.getKeysOfType(nArray[i]);
                linkedList.addAll(this.cpl[i]);
                continue;
            }
            linkedList.addAll(this.cpl[i]);
        }
        this.setKeys(linkedList);
    }

    protected Collection getKeysOfType(int n) {
        LinkedList linkedList = new LinkedList();
        DBMemberElement[] dBMemberElementArray = null;
        DBMemberElement[] dBMemberElementArray2 = null;
        if (this.element instanceof TableElement) {
            dBMemberElementArray = ((TableElement)this.element).getColumns();
        }
        if (this.element instanceof IndexElement) {
            dBMemberElementArray = ((IndexElement)this.element).getColumns();
        }
        if (this.element instanceof ForeignKeyElement) {
            dBMemberElementArray2 = ((ForeignKeyElement)this.element).getColumnPairs();
        }
        if ((n & 4) != 0) {
            if (dBMemberElementArray != null) {
                this.filterModifiers(dBMemberElementArray, linkedList);
            } else if (dBMemberElementArray2 != null) {
                this.filterModifiers(dBMemberElementArray2, linkedList);
            }
        }
        if (this.element instanceof TableElement) {
            boolean bl = this.isViewSupport((TableElement)this.element);
            if (((TableElement)this.element).isTableOrView() || bl) {
                if ((n & 8) != 0) {
                    this.filterModifiers(((TableElement)this.element).getIndexes(), linkedList);
                }
                if ((n & 0x10) != 0) {
                    this.filterModifiers(((TableElement)this.element).getKeys(), linkedList);
                }
            }
        }
        if (this.filter == null || this.filter.isSorted()) {
            Collections.sort(linkedList, comparator);
        }
        return linkedList;
    }

    private boolean isViewSupport(TableElement tableElement) {
        String string = tableElement.getDeclaringSchema().getDatabaseProductName();
        boolean bl = false;
        if (string != null) {
            bl = (string = string.toLowerCase()).indexOf("oracle") != -1 || string.indexOf("microsoft sql server") != -1;
        }
        return bl;
    }

    private void filterModifiers(DBMemberElement[] dBMemberElementArray, Collection collection) {
        int n = dBMemberElementArray.length;
        for (int i = 0; i < n; ++i) {
            collection.add(dBMemberElementArray[i]);
        }
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? TableElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    static {
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof DBMemberElement) {
                    if (object2 instanceof DBMemberElement) {
                        return ((DBMemberElement)object).getName().getName().compareToIgnoreCase(((DBMemberElement)object2).getName().getName());
                    }
                    return -1;
                }
                if (object2 instanceof DBMemberElement) {
                    return 1;
                }
                return 0;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("tables", new Integer(3));
        propToFilter.put("columns", new Integer(4));
        propToFilter.put("columnPairs", new Integer(32));
        propToFilter.put("indexes", new Integer(8));
        propToFilter.put("keys", new Integer(16));
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Integer n = (Integer)propToFilter.get(propertyChangeEvent.getPropertyName());
            if (n != null) {
                TableChildren.this.refreshKeys(n);
            }
        }
    }
}

