/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        int n2 = caret.getDot();
        if (c == ' ' && n2 >= 2) {
            try {
                String string = baseDocument.getText(n2 - 2, 2);
                if ("%=".equals(string) && n2 >= 3) {
                    string = baseDocument.getText(n2 - 3, 3);
                }
                if ("<%".equals(string) || "<%=".equals(string)) {
                    baseDocument.insertString(n2, "  ", null);
                    caret.setDot(n2 + 1);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return false;
        }
        if (n2 > 0 && (c == '%' || c == '>')) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n2);
            try {
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                    String string;
                    Token token = tokenSequence.token();
                    if (token.id() == YamlTokenId.TEXT && baseDocument.getText(n2 - 1, 1).charAt(0) == '<') {
                        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n2, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2));
                        if (n3 == -1) {
                            baseDocument.insertString(n2, "%%>", null);
                            caret.setDot(n2 + 1);
                            return true;
                        }
                    } else if (token.id() == YamlTokenId.DELIMITER) {
                        int n4;
                        String string2 = ((Object)token.text()).toString();
                        if (string2.endsWith("%>")) {
                            int n5 = c == '%' ? n2 : n2 - 1;
                            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n5, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)"%>")) {
                                caret.setDot(n2 + 1);
                                return true;
                            }
                        } else if (string2.endsWith("<") && (n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n2, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2))) == -1) {
                            baseDocument.insertString(n2, "%%>", null);
                            caret.setDot(n2 + 1);
                            return true;
                        }
                    } else if ((token.id() == YamlTokenId.RUBY || token.id() == YamlTokenId.RUBY_EXPR) && n2 >= 1 && n2 <= baseDocument.getLength() - 3 && "% %>".equals(string = baseDocument.getText(n2 - 1, 4))) {
                        baseDocument.remove(n2 - 1, 2);
                        caret.setDot(n2 + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        return false;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        String string;
        if (c == '%' && n > 0 && n <= document.getLength() - 2 && "<%>".equals(string = document.getText(n - 1, 3))) {
            document.remove(n, 2);
            return true;
        }
        return false;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        char c;
        int n2;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n3 == n && n4 == n) {
            return -1;
        }
        int n5 = YamlKeystrokeHandler.getLineIndent(baseDocument, n);
        String string = baseDocument.getText(n3, n - n3);
        String string2 = baseDocument.getText(n, n4 + 1 - n);
        if (string.trim().endsWith(":") && string2.trim().length() == 0) {
            n5 += YamlKeystrokeHandler.getIndentSize(baseDocument);
        }
        int n6 = 0;
        String string3 = baseDocument.getText(n3, n4 + 1 - n3);
        int n7 = string3.length();
        for (n2 = n - n3; n2 < n7 && ((c = string3.charAt(n2)) == ' ' || c == '\t'); ++n2) {
            ++n6;
        }
        if (n6 > 0) {
            baseDocument.remove(n, n6);
        }
        String string4 = YamlKeystrokeHandler.getIndentString(n5);
        n2 = n + string4.length();
        baseDocument.insertString(n, string4, null);
        caret.setDot(n);
        return n2 + 1;
    }

    public OffsetRange findMatching(Document document, int n) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(CompilationInfo compilationInfo, int n) {
        YamlParserResult yamlParserResult = (YamlParserResult)compilationInfo.getEmbeddedResult("text/x-yaml", 0);
        if (yamlParserResult == null) {
            return Collections.emptyList();
        }
        List<? extends StructureItem> list = yamlParserResult.getItems();
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        for (StructureItem structureItem : list) {
            this.addRanges(arrayList, n, structureItem);
        }
        Collections.reverse(arrayList);
        arrayList.add(new OffsetRange(0, compilationInfo.getDocument().getLength()));
        return arrayList;
    }

    private void addRanges(List<OffsetRange> list, int n, StructureItem structureItem) {
        int n2 = (int)structureItem.getPosition();
        int n3 = (int)structureItem.getEndPosition();
        if (n >= n2 && n <= n3) {
            list.add(new OffsetRange(n2, n3));
            for (StructureItem structureItem2 : structureItem.getNestedItems()) {
                this.addRanges(list, n, structureItem2);
            }
        }
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        return -1;
    }

    public static int getLineIndent(BaseDocument baseDocument, int n) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2) ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
            int n4 = Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getIndentSize(BaseDocument baseDocument) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-yaml")).lookup(Preferences.class);
        return preferences.getInt("spaces-per-tab", 4);
    }

    public static void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    public static String getIndentString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        YamlKeystrokeHandler.indent(stringBuilder, n);
        return stringBuilder.toString();
    }
}

