/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolTip;

public class MethodParamsTipPaintComponent
extends JToolTip {
    private int drawX;
    private int drawY;
    private int drawHeight;
    private int drawWidth;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private FontMetrics fontMetrics;
    private List params;
    private int idx;

    public MethodParamsTipPaintComponent(List list, int n) {
        this.params = list;
        this.idx = n;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(this.getForeground());
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        this.drawHeight = this.fontHeight;
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
        int n = this.drawX;
        this.drawWidth = this.drawX;
        int n2 = 0;
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            for (String string : (List)iterator.next()) {
                this.drawString(graphics, string, n2 == this.idx ? this.getDrawFont().deriveFont(1) : null);
                ++n2;
            }
            if (this.drawWidth < this.drawX) {
                this.drawWidth = this.drawX;
            }
            this.drawY += this.drawHeight;
            this.drawX = n;
            n2 = 0;
        }
    }

    protected void drawString(Graphics graphics, String string, Font font) {
        if (graphics != null) {
            graphics.setFont(font);
            graphics.drawString(string, this.drawX, this.drawY);
            graphics.setFont(this.drawFont);
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected int getHeight(String string, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        return new Dimension(this.drawWidth, this.drawHeight * this.params.size());
    }
}

