/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.netbeans.modules.xml.schema.model.Notation;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.ui.basic.editors.NamespacePanel;
import org.netbeans.modules.xml.schema.ui.basic.editors.StringEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class NamespaceEditor
extends StringEditor {
    private String typeDisplayName;
    private String property;
    private String initialUri;
    private Collection<String> uris;
    private Collection<Option> options;

    public NamespaceEditor(SchemaComponent schemaComponent, String string, String string2) {
        this.typeDisplayName = string;
        this.property = string2;
        this.options = new ArrayList<Option>();
        if (schemaComponent instanceof Schema) {
            Schema schema = (Schema)schemaComponent;
            this.initialUri = schema.getTargetNamespace();
            this.uris = schema.getPrefixes().values();
            this.options.add(Option.None);
            this.options.add(Option.Declared);
            this.options.add(Option.Other);
        } else if (schemaComponent instanceof Notation) {
            Notation notation = (Notation)schemaComponent;
            this.initialUri = notation.getSystemIdentifier();
            this.uris = notation.getModel().getSchema().getPrefixes().values();
            this.options.add(Option.Declared);
            this.options.add(Option.Other);
        }
        this.uris.remove(SchemaModelFactory.getDefault().getPrimitiveTypesModel().getSchema().getTargetNamespace());
        if (this.initialUri != null) {
            this.uris.remove(this.initialUri);
        }
    }

    public Component getCustomEditor() {
        final NamespacePanel namespacePanel = new NamespacePanel(this.initialUri, this.uris, this.options);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)namespacePanel, NbBundle.getMessage(NamespaceEditor.class, (String)"LBL_Custom_Property_Editor_Title", (Object)this.typeDisplayName, (Object)this.property), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        NamespaceEditor.this.setValue(namespacePanel.getCurrentSelection());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        namespacePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("validSelection")) {
                    dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                }
            }
        });
        namespacePanel.checkValidity();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setPreferredSize(new Dimension(400, 300));
        return dialog;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        None,
        Declared,
        Other,
        TargetNamespace,
        Local;

    }
}

