/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumn;
import org.netbeans.modules.xml.xam.ui.column.ColumnProvider;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.Customizer;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DetailsColumn
extends SchemaColumn
implements ActionListener,
LookupListener {
    static final long serialVersionUID = 1L;
    private boolean readonly;
    private Customizer customizer;
    private JPanel bottomPanel;
    private JButton applyButton;
    private JButton resetButton;
    private JScrollPane scrollPane;
    private Lookup.Result lookupResult;

    public DetailsColumn(Customizer customizer) {
        super(null, null, false);
        this.customizer = customizer == null || customizer.getComponent() == null ? new DummyDetails() : customizer;
        this.initialize();
        this.lookupResult = this.getCustomizer().getLookup().lookup(new Lookup.Template(ColumnProvider.class));
        if (this.lookupResult != null) {
            this.lookupResult.addLookupListener((LookupListener)this);
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.getCustomizer().getComponent().setBackground(Color.white);
        this.add((Component)this.getCustomizer().getComponent(), "Center");
        this.scrollPane = new JScrollPane(this.getCustomizer().getComponent());
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.applyButton = new JButton();
        this.applyButton.setText(NbBundle.getMessage(DetailsColumn.class, (String)"LBL_DetailsColumn_ApplyButton"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        this.resetButton = new JButton();
        this.resetButton.setText(NbBundle.getMessage(DetailsColumn.class, (String)"LBL_DetailsColumn_ResetButton"));
        this.resetButton.setEnabled(false);
        this.resetButton.addActionListener(this);
        this.bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.bottomPanel.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 2, 10, 10);
        gridBagConstraints.weightx = 0.0;
        this.bottomPanel.add((Component)this.resetButton, gridBagConstraints);
        this.bottomPanel.setBackground(Color.white);
        this.add((Component)this.bottomPanel, "South");
        this.getCustomizer().addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public String getTitle() {
        return NbBundle.getMessage(DetailsColumn.class, (String)"LBL_DetailsColumn");
    }

    public boolean requestFocusInWindow() {
        return this.getCustomizer().getComponent().requestFocusInWindow();
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean isShowing() {
        boolean bl = super.isShowing();
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = !this.isReadOnly();
            if (bl2 != this.getCustomizer().getComponent().isEnabled()) {
                DetailsColumn.setEnabledComponent(this.getCustomizer().getComponent(), bl2);
            }
        }
        return bl;
    }

    public boolean isReadOnly() {
        return this.readonly || !this.getCustomizer().isEditable();
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    private Customizer getCustomizer() {
        return this.customizer;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isReadOnly()) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("apply")) {
            this.applyButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("reset")) {
            this.resetButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isReadOnly()) {
            return;
        }
        if (actionEvent.getSource() == this.applyButton) {
            try {
                this.getCustomizer().apply();
            }
            catch (IOException iOException) {
                String string = NbBundle.getMessage(DetailsColumn.class, (String)"MSG_DetailsColumn_ApplyFailed");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, string, string, (Throwable)iOException, new Date());
                this.getCustomizer().reset();
            }
        } else if (actionEvent.getSource() == this.resetButton) {
            this.getCustomizer().reset();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void resultChanged(LookupEvent lookupEvent) {
        if (this.isReadOnly()) {
            return;
        }
        Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
        if (result.allInstances().isEmpty()) {
            this.getColumnView().removeColumnsAfter(this);
        } else {
            for (Object e : result.allInstances()) {
                if (!(e instanceof ColumnProvider)) continue;
                ColumnProvider columnProvider = (ColumnProvider)e;
                AbstractNode abstractNode = new AbstractNode(Children.LEAF, Lookups.singleton((Object)columnProvider));
                this.getExplorerManager().setRootContext((Node)abstractNode);
                try {
                    this.getExplorerManager().setSelectedNodes(new Node[]{abstractNode});
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
    }

    private static void setEnabledComponent(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                DetailsColumn.setEnabledComponent(component2, bl);
            }
        }
    }

    static class DummyDetails
    extends AbstractCustomizer {
        static final long serialVersionUID = 1L;

        public DummyDetails() {
            this.initialize();
        }

        private void initialize() {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(NbBundle.getMessage(DetailsColumn.class, (String)"LBL_DetailsColumn_NoCustomizer"));
            jTextArea.setColumns(25);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.add(jTextArea);
        }

        public void apply() {
            this.setSaveEnabled(false);
        }

        public void reset() {
            this.setResetEnabled(false);
        }

        public boolean isEditable() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

