/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentDefinition;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ComplexExtensionDefinition;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ComplexTypeDefinition;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalAttributeContainer;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleContentDefinition;
import org.netbeans.modules.xml.schema.model.SimpleContentRestriction;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.customizer.MessageDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexTypeCustomizer<T extends ComplexType>
extends AbstractSchemaComponentCustomizer<T>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    private JRadioButton allButton;
    private JRadioButton choiceButton;
    private ButtonGroup compositorButtonGroup;
    private JLabel compositorLabel;
    private JPanel compositorPanel;
    private ButtonGroup definitionButtonGroup;
    private JPanel definitionPanel;
    private JRadioButton existingDefinitionButton;
    private JRadioButton extensionButton;
    private JRadioButton groupButton;
    private JRadioButton inlineDefinitionButton;
    private JComboBox innerContentComboBox;
    private JLabel innerContentLabel;
    private JPanel innerContentPanel;
    private JScrollPane jScrollPane1;
    private JPanel mPanel;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameTextField;
    private JRadioButton noTypeButton;
    private JLabel previewLabel;
    private JEditorPane previewPane;
    private ButtonGroup referenceButtonGroup;
    private JLabel referenceLabel;
    private JPanel referencePanel;
    private JRadioButton restrictionButton;
    private JRadioButton sequenceButton;
    private JLabel typeLabel;
    private transient ContentType contentType;
    private transient ContentType innerContentType;
    private transient ReferenceableSchemaComponent gRef;
    private transient DocumentListener nameListener;
    private transient ItemListener buttonListener;
    private transient SchemaComponent parent;
    private transient SchemaComponentSelectionPanel<GlobalGroup> groupSelectionPanel;
    private transient SchemaComponentSelectionPanel<GlobalType> typeSelectionPanel;

    public ComplexTypeCustomizer(SchemaComponentReference<T> schemaComponentReference, SchemaComponent schemaComponent) {
        super(schemaComponentReference, schemaComponent);
        this.initComponents();
        this.reset();
    }

    public ComplexTypeCustomizer(SchemaComponentReference<T> schemaComponentReference) {
        this(schemaComponentReference, null);
    }

    private void initialize() {
        ComplexType complexType = this.getSchemaComponent();
        if (complexType == null) {
            return;
        }
        ComplexTypeDefinition complexTypeDefinition = complexType.getDefinition();
        this.contentType = ContentType.NoType;
        if (complexTypeDefinition instanceof All) {
            this.contentType = ContentType.All;
        } else if (complexTypeDefinition instanceof Choice) {
            this.contentType = ContentType.Choice;
        } else if (complexTypeDefinition instanceof Sequence) {
            this.contentType = ContentType.Sequence;
        } else if (complexTypeDefinition instanceof GroupReference) {
            this.contentType = ContentType.Group;
            this.gRef = (ReferenceableSchemaComponent)((GroupReference)complexTypeDefinition).getRef().get();
        } else if (complexTypeDefinition instanceof ComplexContent) {
            ComplexContent complexContent = (ComplexContent)complexTypeDefinition;
            if (complexContent.getLocalDefinition() instanceof ComplexContentRestriction) {
                this.contentType = ContentType.Restriction;
                ComplexContentRestriction complexContentRestriction = (ComplexContentRestriction)complexContent.getLocalDefinition();
                this.gRef = (ReferenceableSchemaComponent)complexContentRestriction.getBase().get();
                ComplexTypeDefinition complexTypeDefinition2 = complexContentRestriction.getDefinition();
                if (complexTypeDefinition2 instanceof All) {
                    this.innerContentType = ContentType.All;
                } else if (complexTypeDefinition2 instanceof Choice) {
                    this.innerContentType = ContentType.Choice;
                } else if (complexTypeDefinition2 instanceof Sequence) {
                    this.innerContentType = ContentType.Sequence;
                } else if (complexTypeDefinition2 instanceof GroupReference) {
                    this.innerContentType = ContentType.Group;
                }
            } else if (complexContent.getLocalDefinition() instanceof ComplexExtension) {
                this.contentType = ContentType.Extension;
                ComplexExtension complexExtension = (ComplexExtension)complexContent.getLocalDefinition();
                this.gRef = (ReferenceableSchemaComponent)complexExtension.getBase().get();
                ComplexExtensionDefinition complexExtensionDefinition = complexExtension.getLocalDefinition();
                this.innerContentType = complexExtensionDefinition instanceof All ? ContentType.All : (complexExtensionDefinition instanceof Choice ? ContentType.Choice : (complexExtensionDefinition instanceof Sequence ? ContentType.Sequence : (complexExtensionDefinition instanceof GroupReference ? ContentType.Group : ContentType.NoType)));
            }
        } else if (complexTypeDefinition instanceof SimpleContent) {
            SimpleContent simpleContent = (SimpleContent)complexTypeDefinition;
            if (simpleContent.getLocalDefinition() instanceof SimpleContentRestriction) {
                this.contentType = ContentType.Restriction;
                SimpleContentRestriction simpleContentRestriction = (SimpleContentRestriction)simpleContent.getLocalDefinition();
                if (simpleContentRestriction.getBase() != null) {
                    this.gRef = (ReferenceableSchemaComponent)simpleContentRestriction.getBase().get();
                }
            } else if (simpleContent.getLocalDefinition() instanceof SimpleExtension) {
                this.contentType = ContentType.Extension;
                this.gRef = (ReferenceableSchemaComponent)((SimpleExtension)simpleContent.getLocalDefinition()).getBase().get();
            }
        }
    }

    private ContentType getModelContentType() {
        return this.contentType;
    }

    private ContentType getModelInnerContentType() {
        return this.innerContentType;
    }

    private ReferenceableSchemaComponent getModelReference() {
        return this.gRef;
    }

    private void initializeUI() {
        this.getMessageDisplayer().clear();
        if (this.isNameable()) {
            this.nameTextField.setText(this._getName());
            if (!this.hasParent()) {
                this.nameTextField.setSelectionStart(0);
            }
        } else {
            this.namePanel.setVisible(false);
        }
        if (this.getModelContentType() == null) {
            this.inlineDefinitionButton.setSelected(true);
        } else {
            switch (this.getModelContentType()) {
                case NoType: {
                    this.inlineDefinitionButton.setSelected(true);
                    this.noTypeButton.setSelected(true);
                    break;
                }
                case Sequence: {
                    this.inlineDefinitionButton.setSelected(true);
                    this.sequenceButton.setSelected(true);
                    break;
                }
                case Choice: {
                    this.inlineDefinitionButton.setSelected(true);
                    this.choiceButton.setSelected(true);
                    break;
                }
                case All: {
                    this.inlineDefinitionButton.setSelected(true);
                    this.allButton.setSelected(true);
                    break;
                }
                case Group: {
                    this.existingDefinitionButton.setSelected(true);
                    this.groupButton.setSelected(true);
                    break;
                }
                case Extension: {
                    this.existingDefinitionButton.setSelected(true);
                    this.extensionButton.setSelected(true);
                    this.innerContentComboBox.setSelectedItem((Object)this.getModelInnerContentType());
                    break;
                }
                case Restriction: {
                    this.existingDefinitionButton.setSelected(true);
                    this.restrictionButton.setSelected(true);
                }
            }
        }
        this.switchDefinitionPanels();
        this.selectModelNode();
        this.enableDisableComboBox();
        this.setPreviewText();
    }

    private void enableDisableComboBox() {
        if (this.getUIContentType() == ContentType.Extension && this.getUIReference() instanceof GlobalComplexType && !(((GlobalComplexType)this.getUIReference()).getDefinition() instanceof SimpleContent)) {
            this.innerContentLabel.setEnabled(true);
            this.innerContentComboBox.setEnabled(true);
            if (this.innerContentComboBox.getSelectedItem() == null) {
                this.innerContentComboBox.setSelectedIndex(0);
            }
        } else {
            this.innerContentLabel.setEnabled(false);
            this.innerContentComboBox.setEnabled(false);
        }
    }

    private void switchDefinitionPanels() {
        if (this.existingDefinitionButton.isSelected()) {
            ((CardLayout)this.definitionPanel.getLayout()).show(this.definitionPanel, "reference");
            if (this.referenceButtonGroup.getSelection() == null) {
                this.referenceButtonGroup.getElements().nextElement().setSelected(true);
            }
            this.switchInnerContentPanels();
        } else {
            ((CardLayout)this.definitionPanel.getLayout()).show(this.definitionPanel, "compositor");
            if (this.compositorButtonGroup.getSelection() == null) {
                this.compositorButtonGroup.getElements().nextElement().setSelected(true);
            }
        }
        this.enableDisableComboBox();
    }

    private void switchInnerContentPanels() {
        if (this.groupButton.isSelected()) {
            ((CardLayout)this.innerContentPanel.getLayout()).show(this.innerContentPanel, "group");
        } else {
            ((CardLayout)this.innerContentPanel.getLayout()).show(this.innerContentPanel, "type");
        }
    }

    private void selectModelNode() {
        switch (this.getUIContentType()) {
            case Group: {
                this.groupSelectionPanel.setInitialSelection((GlobalGroup)this.getModelReference());
                break;
            }
            case Extension: 
            case Restriction: {
                this.typeSelectionPanel.setInitialSelection((GlobalType)this.getModelReference());
                break;
            }
        }
    }

    private void addListeners() {
        if (this.isNameable()) {
            if (this.nameListener == null) {
                this.nameListener = new DocumentListener(){

                    public void changedUpdate(DocumentEvent documentEvent) {
                        ComplexTypeCustomizer.this.setPreviewText();
                        ComplexTypeCustomizer.this.determineValidity();
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        ComplexTypeCustomizer.this.setPreviewText();
                        ComplexTypeCustomizer.this.determineValidity();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        ComplexTypeCustomizer.this.setPreviewText();
                        ComplexTypeCustomizer.this.determineValidity();
                    }
                };
            }
            this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        }
        if (this.buttonListener == null) {
            this.buttonListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = itemEvent.getSource();
                    if (object == ComplexTypeCustomizer.this.extensionButton) {
                        ComplexTypeCustomizer.this.enableDisableComboBox();
                    }
                    if (itemEvent.getStateChange() == 1) {
                        if (object == ComplexTypeCustomizer.this.inlineDefinitionButton || object == ComplexTypeCustomizer.this.existingDefinitionButton) {
                            ComplexTypeCustomizer.this.switchDefinitionPanels();
                        }
                        if (object == ComplexTypeCustomizer.this.groupButton || object == ComplexTypeCustomizer.this.extensionButton || object == ComplexTypeCustomizer.this.restrictionButton) {
                            ComplexTypeCustomizer.this.switchInnerContentPanels();
                        }
                        ComplexTypeCustomizer.this.setPreviewText();
                        ComplexTypeCustomizer.this.determineValidity();
                    }
                }
            };
        }
        this.inlineDefinitionButton.addItemListener(this.buttonListener);
        this.existingDefinitionButton.addItemListener(this.buttonListener);
        this.noTypeButton.addItemListener(this.buttonListener);
        this.sequenceButton.addItemListener(this.buttonListener);
        this.allButton.addItemListener(this.buttonListener);
        this.choiceButton.addItemListener(this.buttonListener);
        this.groupButton.addItemListener(this.buttonListener);
        this.extensionButton.addItemListener(this.buttonListener);
        this.restrictionButton.addItemListener(this.buttonListener);
        this.innerContentComboBox.addItemListener(this.buttonListener);
    }

    private void removeListeners() {
        if (this.isNameable()) {
            this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
        }
        this.inlineDefinitionButton.removeItemListener(this.buttonListener);
        this.existingDefinitionButton.removeItemListener(this.buttonListener);
        this.noTypeButton.removeItemListener(this.buttonListener);
        this.sequenceButton.removeItemListener(this.buttonListener);
        this.allButton.removeItemListener(this.buttonListener);
        this.choiceButton.removeItemListener(this.buttonListener);
        this.groupButton.removeItemListener(this.buttonListener);
        this.extensionButton.removeItemListener(this.buttonListener);
        this.restrictionButton.removeItemListener(this.buttonListener);
        this.innerContentComboBox.removeItemListener(this.buttonListener);
    }

    @Override
    protected String getUIName() {
        return this.nameTextField.getText();
    }

    private ContentType getUIContentType() {
        if (this.inlineDefinitionButton.isSelected()) {
            if (this.noTypeButton.isSelected()) {
                return ContentType.NoType;
            }
            if (this.sequenceButton.isSelected()) {
                return ContentType.Sequence;
            }
            if (this.choiceButton.isSelected()) {
                return ContentType.Choice;
            }
            if (this.allButton.isSelected()) {
                return ContentType.All;
            }
        }
        if (this.existingDefinitionButton.isSelected()) {
            if (this.groupButton.isSelected()) {
                return ContentType.Group;
            }
            if (this.extensionButton.isSelected()) {
                return ContentType.Extension;
            }
            if (this.restrictionButton.isSelected()) {
                return ContentType.Restriction;
            }
        }
        return null;
    }

    private ContentType getUIInnerContentType() {
        if (!this.innerContentComboBox.isEnabled()) {
            return null;
        }
        return (ContentType)((Object)this.innerContentComboBox.getSelectedItem());
    }

    private ReferenceableSchemaComponent getUIReference() {
        switch (this.getUIContentType()) {
            case Group: {
                return this.groupSelectionPanel.getCurrentSelection();
            }
            case Extension: 
            case Restriction: {
                return this.typeSelectionPanel.getCurrentSelection();
            }
        }
        return null;
    }

    private void initializeTypePanel() {
        this.typeSelectionPanel = new SchemaComponentSelectionPanel<Object>(((ComplexType)this.getReference().get()).getModel(), GlobalType.class, null, Collections.singleton(this.getReference().get()), true);
        this.typeSelectionPanel.addPropertyChangeListener(this);
        this.groupSelectionPanel = new SchemaComponentSelectionPanel<Object>(((ComplexType)this.getReference().get()).getModel(), GlobalGroup.class, null, null, false);
        this.groupSelectionPanel.addPropertyChangeListener(this);
        this.innerContentPanel.add((java.awt.Component)this.groupSelectionPanel.getTypeSelectionPanel(), "group");
        this.innerContentPanel.add((java.awt.Component)this.typeSelectionPanel.getTypeSelectionPanel(), "type");
        this.typeSelectionPanel.getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.innerContentPanel);
        this.groupSelectionPanel.getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.innerContentPanel);
    }

    private Class<? extends ReferenceableSchemaComponent> getReferenceType() {
        ArrayList arrayList = new ArrayList();
        switch (this.getUIContentType()) {
            case Group: {
                return GlobalGroup.class;
            }
            case Extension: 
            case Restriction: {
                return GlobalType.class;
            }
        }
        return null;
    }

    private void initComponents() {
        this.compositorButtonGroup = new ButtonGroup();
        this.definitionButtonGroup = new ButtonGroup();
        this.referenceButtonGroup = new ButtonGroup();
        this.previewLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        };
        this.definitionPanel = new JPanel();
        this.compositorPanel = new JPanel();
        this.sequenceButton = new JRadioButton();
        this.choiceButton = new JRadioButton();
        this.allButton = new JRadioButton();
        this.noTypeButton = new JRadioButton();
        this.compositorLabel = new JLabel();
        this.referencePanel = new JPanel();
        this.extensionButton = new JRadioButton();
        this.restrictionButton = new JRadioButton();
        this.groupButton = new JRadioButton();
        this.innerContentLabel = new JLabel();
        this.innerContentComboBox = new JComboBox();
        this.innerContentPanel = new JPanel();
        this.referenceLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.inlineDefinitionButton = new JRadioButton();
        this.existingDefinitionButton = new JRadioButton();
        this.mPanel = new JPanel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.previewLabel.setLabelFor(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"TITLE_CustomizerForm_Preview"));
        this.previewLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Preview"));
        this.previewPane.setEditable(false);
        this.previewPane.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Preview"));
        this.previewPane.setContentType("text/xml");
        this.previewPane.setEnabled(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        this.definitionPanel.setLayout(new CardLayout());
        this.definitionPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.compositorButtonGroup.add(this.sequenceButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sequenceButton, (String)ContentType.Sequence.getLabel());
        this.sequenceButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_Sequence"));
        this.sequenceButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sequenceButton.setMargin(new Insets(0, 0, 0, 0));
        this.compositorButtonGroup.add(this.choiceButton);
        Mnemonics.setLocalizedText((AbstractButton)this.choiceButton, (String)ContentType.Choice.getLabel());
        this.choiceButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_Choice"));
        this.choiceButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.choiceButton.setMargin(new Insets(0, 0, 0, 0));
        this.compositorButtonGroup.add(this.allButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allButton, (String)ContentType.All.getLabel());
        this.allButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_All"));
        this.allButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allButton.setMargin(new Insets(0, 0, 0, 0));
        this.compositorButtonGroup.add(this.noTypeButton);
        Mnemonics.setLocalizedText((AbstractButton)this.noTypeButton, (String)ContentType.NoType.getLabel());
        this.noTypeButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_NoType"));
        this.noTypeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noTypeButton.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.compositorLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Inline_Definition_Panel", (Object[])new Object[0]));
        this.compositorLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Inline_Definition_Panel"));
        GroupLayout groupLayout = new GroupLayout((Container)this.compositorPanel);
        this.compositorPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.compositorLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.sequenceButton).add((java.awt.Component)this.choiceButton).add((java.awt.Component)this.allButton).add((java.awt.Component)this.noTypeButton)))).addContainerGap(384, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.compositorLabel).addPreferredGap(0).add((java.awt.Component)this.sequenceButton).addPreferredGap(0).add((java.awt.Component)this.choiceButton).addPreferredGap(0).add((java.awt.Component)this.allButton).addPreferredGap(0).add((java.awt.Component)this.noTypeButton).addContainerGap(187, Short.MAX_VALUE)));
        this.definitionPanel.add((java.awt.Component)this.compositorPanel, "compositor");
        this.referenceButtonGroup.add(this.extensionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.extensionButton, (String)ContentType.Extension.getLabel());
        this.extensionButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_Extension"));
        this.extensionButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionButton.setMargin(new Insets(0, 0, 0, 0));
        this.referenceButtonGroup.add(this.restrictionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.restrictionButton, (String)ContentType.Restriction.getLabel());
        this.restrictionButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_Restriction"));
        this.restrictionButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.restrictionButton.setMargin(new Insets(0, 0, 0, 0));
        this.referenceButtonGroup.add(this.groupButton);
        Mnemonics.setLocalizedText((AbstractButton)this.groupButton, (String)ContentType.Group.getLabel());
        this.groupButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content_Group"));
        this.groupButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.groupButton.setMargin(new Insets(0, 0, 0, 0));
        this.innerContentLabel.setLabelFor(this.innerContentComboBox);
        Mnemonics.setLocalizedText((JLabel)this.innerContentLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_InnerContent"));
        this.innerContentLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_InnerContent"));
        this.innerContentLabel.setEnabled(false);
        this.innerContentComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{ContentType.Sequence, ContentType.Choice, ContentType.All, ContentType.NoType, ContentType.Group}));
        this.innerContentComboBox.setEnabled(false);
        this.innerContentPanel.setLayout(new CardLayout());
        this.initializeTypePanel();
        Mnemonics.setLocalizedText((JLabel)this.referenceLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Existing_Definition_Panel", (Object[])new Object[0]));
        this.referenceLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Existing_Definition_Panel"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.referencePanel);
        this.referencePanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((java.awt.Component)this.referenceLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((java.awt.Component)this.extensionButton).add(5, 5, 5).add((java.awt.Component)this.innerContentLabel).add(5, 5, 5).add((java.awt.Component)this.innerContentComboBox, 0, 278, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((java.awt.Component)this.restrictionButton).addContainerGap(385, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((java.awt.Component)this.innerContentPanel, -1, 451, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((java.awt.Component)this.groupButton).addContainerGap(385, Short.MAX_VALUE)))));
        groupLayout2.linkSize(new java.awt.Component[]{this.extensionButton, this.groupButton, this.restrictionButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((java.awt.Component)this.referenceLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((java.awt.Component)this.extensionButton).add((java.awt.Component)this.innerContentLabel).add((java.awt.Component)this.innerContentComboBox, -2, -1, -2)).addPreferredGap(0).add((java.awt.Component)this.restrictionButton).addPreferredGap(0).add((java.awt.Component)this.groupButton).add(0, 0, 0).add((java.awt.Component)this.innerContentPanel, -1, 201, Short.MAX_VALUE)));
        this.definitionPanel.add((java.awt.Component)this.referencePanel, "reference");
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content", (Object[])new Object[0]));
        this.typeLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Content"));
        this.definitionButtonGroup.add(this.inlineDefinitionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.inlineDefinitionButton, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Inline_Definition_Button"));
        this.inlineDefinitionButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Inline_Definition_Button"));
        this.inlineDefinitionButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inlineDefinitionButton.setMargin(new Insets(0, 0, 0, 0));
        this.definitionButtonGroup.add(this.existingDefinitionButton);
        Mnemonics.setLocalizedText((AbstractButton)this.existingDefinitionButton, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Existing_Definition_Button"));
        this.existingDefinitionButton.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Existing_Definition_Button"));
        this.existingDefinitionButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.existingDefinitionButton.setMargin(new Insets(0, 0, 0, 0));
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((java.awt.Component)this.getMessageDisplayer().getComponent(), "Center");
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_CustomizerForm_Name"));
        this.nameLabel.setToolTipText(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"HINT_ComplexType_Name"));
        this.nameTextField.setEditable(!this.hasParent());
        GroupLayout groupLayout3 = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((java.awt.Component)this.nameLabel).addPreferredGap(0).add((java.awt.Component)this.nameTextField, -1, 445, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((java.awt.Component)this.nameLabel).add((java.awt.Component)this.nameTextField, -2, -1, -2))));
        GroupLayout groupLayout4 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((java.awt.Component)this.typeLabel).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((java.awt.Component)this.existingDefinitionButton).add((java.awt.Component)this.inlineDefinitionButton)))).addContainerGap(357, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((java.awt.Component)this.previewLabel).addContainerGap(448, Short.MAX_VALUE)).add((java.awt.Component)this.namePanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((java.awt.Component)this.definitionPanel, -1, 480, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((java.awt.Component)this.jScrollPane1, -1, 480, Short.MAX_VALUE).addContainerGap()).add(2, (java.awt.Component)this.mPanel, -1, 500, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((java.awt.Component)this.namePanel, -2, -1, -2).add(11, 11, 11).add((java.awt.Component)this.typeLabel).addPreferredGap(0).add((java.awt.Component)this.inlineDefinitionButton).addPreferredGap(0).add((java.awt.Component)this.existingDefinitionButton).add(11, 11, 11).add((java.awt.Component)this.definitionPanel, -1, 287, Short.MAX_VALUE).add(11, 11, 11).add((java.awt.Component)this.previewLabel).add(5, 5, 5).add((java.awt.Component)this.jScrollPane1, -1, 89, Short.MAX_VALUE).add(0, 0, 0).add((java.awt.Component)this.mPanel, -1, 60, Short.MAX_VALUE)));
    }

    protected void applyChanges() throws IOException {
        this.saveName();
        ContentType contentType = this.getUIContentType();
        ReferenceableSchemaComponent referenceableSchemaComponent = this.getUIReference();
        switch (contentType) {
            case NoType: 
            case Sequence: 
            case Choice: 
            case All: {
                if (contentType == this.getModelContentType()) break;
                this.saveContentType();
                break;
            }
            case Group: {
                if (!(referenceableSchemaComponent instanceof GlobalGroup) || contentType == this.getModelContentType() && referenceableSchemaComponent == this.getModelReference()) break;
                this.saveContentType();
                break;
            }
            case Restriction: {
                if (!(referenceableSchemaComponent instanceof GlobalType) || contentType == this.getModelContentType() && referenceableSchemaComponent == this.getModelReference()) break;
                this.saveContentType();
                break;
            }
            case Extension: {
                ContentType contentType2;
                if (referenceableSchemaComponent instanceof GlobalSimpleType || referenceableSchemaComponent instanceof GlobalComplexType && ((GlobalComplexType)referenceableSchemaComponent).getDefinition() instanceof SimpleContent) {
                    if (contentType == this.getModelContentType() && referenceableSchemaComponent == this.getModelReference()) break;
                    this.saveContentType();
                    break;
                }
                if (!(referenceableSchemaComponent instanceof GlobalComplexType) || (contentType2 = this.getUIInnerContentType()) == null || contentType == this.getModelContentType() && referenceableSchemaComponent == this.getModelReference() && contentType2 == this.getModelInnerContentType()) break;
                this.saveContentType();
            }
        }
    }

    ComplexType saveContentType() {
        ComplexContent complexContent;
        ComplexType complexType = this.getSchemaComponent();
        SchemaComponentFactory schemaComponentFactory = this.getSchemaModel().getFactory();
        ComplexTypeDefinition complexTypeDefinition = complexType.getDefinition();
        ReferenceableSchemaComponent referenceableSchemaComponent = this.getUIReference();
        ComplexType complexType2 = complexType;
        if (complexTypeDefinition instanceof ComplexContent) {
            complexContent = (ComplexContent)complexTypeDefinition;
            if (complexContent.getLocalDefinition() instanceof ComplexContentRestriction) {
                complexType2 = (ComplexContentRestriction)complexContent.getLocalDefinition();
            } else if (complexContent.getLocalDefinition() instanceof ComplexExtension) {
                complexType2 = (ComplexExtension)complexContent.getLocalDefinition();
            }
        } else if (complexTypeDefinition instanceof SimpleContent) {
            complexContent = (SimpleContent)complexTypeDefinition;
            if (complexContent.getLocalDefinition() instanceof SimpleContentRestriction) {
                complexType2 = (SimpleContentRestriction)complexContent.getLocalDefinition();
            } else if (complexContent.getLocalDefinition() instanceof SimpleExtension) {
                complexType2 = (SimpleExtension)complexContent.getLocalDefinition();
            }
        }
        switch (this.getUIContentType()) {
            case NoType: {
                assert (complexTypeDefinition != null);
                complexType.setDefinition(null);
                break;
            }
            case All: {
                assert (!(complexTypeDefinition instanceof All));
                complexContent = schemaComponentFactory.createAll();
                if (complexTypeDefinition instanceof Choice || complexTypeDefinition instanceof Sequence) {
                    this.copyContent((SchemaComponent)complexTypeDefinition, (SchemaComponent)complexContent);
                }
                complexType.setDefinition((ComplexTypeDefinition)complexContent);
                break;
            }
            case Choice: {
                assert (!(complexTypeDefinition instanceof Choice));
                Choice choice = schemaComponentFactory.createChoice();
                if (complexTypeDefinition instanceof All || complexTypeDefinition instanceof Sequence) {
                    this.copyContent((SchemaComponent)complexTypeDefinition, (SchemaComponent)choice);
                }
                complexType.setDefinition((ComplexTypeDefinition)choice);
                break;
            }
            case Sequence: {
                Sequence sequence = schemaComponentFactory.createSequence();
                if (complexTypeDefinition instanceof All || complexTypeDefinition instanceof Choice) {
                    this.copyContent((SchemaComponent)complexTypeDefinition, (SchemaComponent)sequence);
                }
                complexType.setDefinition((ComplexTypeDefinition)sequence);
                break;
            }
            case Group: {
                assert (referenceableSchemaComponent instanceof GlobalGroup);
                GroupReference groupReference = complexTypeDefinition instanceof GroupReference ? (GroupReference)complexTypeDefinition : schemaComponentFactory.createGroupReference();
                groupReference.setRef(groupReference.createReferenceTo((ReferenceableSchemaComponent)((GlobalGroup)referenceableSchemaComponent), GlobalGroup.class));
                complexType.setDefinition((ComplexTypeDefinition)groupReference);
                break;
            }
            case Extension: {
                ComplexContent complexContent2;
                assert (referenceableSchemaComponent instanceof GlobalType);
                if (referenceableSchemaComponent instanceof GlobalSimpleType || referenceableSchemaComponent instanceof GlobalComplexType && ((GlobalComplexType)referenceableSchemaComponent).getDefinition() instanceof SimpleContent) {
                    SimpleExtension simpleExtension = null;
                    if (complexTypeDefinition instanceof SimpleContent) {
                        SimpleContent simpleContent = (SimpleContent)complexTypeDefinition;
                        if (simpleContent.getLocalDefinition() instanceof SimpleExtension) {
                            simpleExtension = (SimpleExtension)simpleContent.getLocalDefinition();
                        } else {
                            simpleExtension = schemaComponentFactory.createSimpleExtension();
                            this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)simpleExtension);
                            simpleContent.setLocalDefinition((SimpleContentDefinition)simpleExtension);
                        }
                    } else {
                        SimpleContent simpleContent = schemaComponentFactory.createSimpleContent();
                        simpleExtension = schemaComponentFactory.createSimpleExtension();
                        this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)simpleExtension);
                        simpleContent.setLocalDefinition((SimpleContentDefinition)simpleExtension);
                        complexType.setDefinition((ComplexTypeDefinition)simpleContent);
                    }
                    simpleExtension.setBase(simpleExtension.createReferenceTo((ReferenceableSchemaComponent)((GlobalType)referenceableSchemaComponent), GlobalType.class));
                    break;
                }
                if (!(referenceableSchemaComponent instanceof GlobalComplexType)) break;
                assert (this.getUIInnerContentType() != null);
                ComplexExtension complexExtension = null;
                if (complexTypeDefinition instanceof ComplexContent) {
                    complexContent2 = (ComplexContent)complexTypeDefinition;
                    if (complexContent2.getLocalDefinition() instanceof ComplexExtension) {
                        complexExtension = (ComplexExtension)complexContent2.getLocalDefinition();
                    } else {
                        complexExtension = schemaComponentFactory.createComplexExtension();
                        this.copyContent((SchemaComponent)complexContent2.getLocalDefinition(), (SchemaComponent)complexExtension);
                        complexContent2.setLocalDefinition((ComplexContentDefinition)complexExtension);
                    }
                } else {
                    complexContent2 = schemaComponentFactory.createComplexContent();
                    complexExtension = schemaComponentFactory.createComplexExtension();
                    this.moveComplexContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)complexExtension);
                    complexContent2.setLocalDefinition((ComplexContentDefinition)complexExtension);
                    complexType.setDefinition((ComplexTypeDefinition)complexContent2);
                }
                complexContent2 = (GlobalComplexType)referenceableSchemaComponent;
                complexExtension.setBase(complexExtension.createReferenceTo((ReferenceableSchemaComponent)complexContent2, GlobalType.class));
                if (this.getUIInnerContentType() == this.getModelInnerContentType()) break;
                GroupReference groupReference = null;
                switch (this.getUIInnerContentType()) {
                    case Group: {
                        groupReference = schemaComponentFactory.createGroupReference();
                        break;
                    }
                    case All: {
                        groupReference = schemaComponentFactory.createAll();
                        break;
                    }
                    case Sequence: {
                        groupReference = schemaComponentFactory.createSequence();
                        break;
                    }
                    case Choice: {
                        groupReference = schemaComponentFactory.createChoice();
                        break;
                    }
                }
                if (groupReference != null && complexExtension.getLocalDefinition() != null) {
                    this.copyContent((SchemaComponent)complexExtension.getLocalDefinition(), (SchemaComponent)groupReference);
                }
                complexExtension.setLocalDefinition((ComplexExtensionDefinition)groupReference);
                break;
            }
            case Restriction: {
                ComplexContent complexContent3;
                assert (referenceableSchemaComponent instanceof GlobalType);
                if (referenceableSchemaComponent instanceof GlobalSimpleType || referenceableSchemaComponent instanceof GlobalComplexType && ((GlobalComplexType)referenceableSchemaComponent).getDefinition() instanceof SimpleContent) {
                    SimpleContentRestriction simpleContentRestriction = null;
                    if (complexTypeDefinition instanceof SimpleContent) {
                        SimpleContent simpleContent = (SimpleContent)complexTypeDefinition;
                        if (simpleContent.getLocalDefinition() instanceof SimpleContentRestriction) {
                            simpleContentRestriction = (SimpleContentRestriction)simpleContent.getLocalDefinition();
                            if (simpleContentRestriction.getInlineType() != null) {
                                simpleContentRestriction.setInlineType(null);
                            }
                        } else {
                            simpleContentRestriction = schemaComponentFactory.createSimpleContentRestriction();
                            this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)simpleContentRestriction);
                            simpleContent.setLocalDefinition((SimpleContentDefinition)simpleContentRestriction);
                        }
                    } else {
                        SimpleContent simpleContent = schemaComponentFactory.createSimpleContent();
                        simpleContentRestriction = schemaComponentFactory.createSimpleContentRestriction();
                        this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)simpleContentRestriction);
                        simpleContent.setLocalDefinition((SimpleContentDefinition)simpleContentRestriction);
                        complexType.setDefinition((ComplexTypeDefinition)simpleContent);
                    }
                    simpleContentRestriction.setBase(simpleContentRestriction.createReferenceTo((ReferenceableSchemaComponent)((GlobalType)referenceableSchemaComponent), GlobalType.class));
                    break;
                }
                if (!(referenceableSchemaComponent instanceof GlobalComplexType)) break;
                ComplexContentRestriction complexContentRestriction = null;
                if (complexTypeDefinition instanceof ComplexContent) {
                    complexContent3 = (ComplexContent)complexTypeDefinition;
                    if (complexContent3.getLocalDefinition() instanceof ComplexContentRestriction) {
                        complexContentRestriction = (ComplexContentRestriction)complexContent3.getLocalDefinition();
                    } else {
                        complexContentRestriction = schemaComponentFactory.createComplexContentRestriction();
                        this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)complexContentRestriction);
                        complexContent3.setLocalDefinition((ComplexContentDefinition)complexContentRestriction);
                    }
                } else {
                    complexContent3 = schemaComponentFactory.createComplexContent();
                    complexContentRestriction = schemaComponentFactory.createComplexContentRestriction();
                    this.moveAttributeContents((LocalAttributeContainer)complexType2, (LocalAttributeContainer)complexContentRestriction);
                    complexContent3.setLocalDefinition((ComplexContentDefinition)complexContentRestriction);
                    complexType.setDefinition((ComplexTypeDefinition)complexContent3);
                }
                complexContent3 = (GlobalComplexType)referenceableSchemaComponent;
                complexContentRestriction.setBase(complexContentRestriction.createReferenceTo((ReferenceableSchemaComponent)complexContent3, GlobalComplexType.class));
                ComplexTypeDefinition complexTypeDefinition2 = null;
                if (complexContent3.getDefinition() instanceof All || complexContent3.getDefinition() instanceof Choice || complexContent3.getDefinition() instanceof Sequence || complexContent3.getDefinition() instanceof GroupReference) {
                    complexTypeDefinition2 = complexContent3.getDefinition();
                } else if (complexContent3.getDefinition() instanceof ComplexContent) {
                    ComplexContent complexContent4 = (ComplexContent)complexContent3.getDefinition();
                    if (complexContent4.getLocalDefinition() instanceof ComplexContentRestriction) {
                        complexTypeDefinition2 = ((ComplexContentRestriction)complexContent4.getLocalDefinition()).getDefinition();
                    } else if (complexContent4.getLocalDefinition() instanceof ComplexExtension) {
                        complexTypeDefinition2 = (ComplexTypeDefinition)((ComplexExtension)complexContent4.getLocalDefinition()).getLocalDefinition();
                    }
                }
                if (complexContentRestriction == null) break;
                complexContentRestriction.setDefinition((ComplexTypeDefinition)complexTypeDefinition2.copy((Component)complexContentRestriction));
            }
        }
        this.contentType = this.contentType;
        return complexType;
    }

    private void copyContent(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        if (schemaComponent == null || schemaComponent2 == null) {
            return;
        }
        SchemaModel schemaModel = this.getSchemaModel();
        for (SchemaComponent schemaComponent3 : schemaComponent.getChildren()) {
            if (!schemaComponent2.canPaste((Component)schemaComponent3)) continue;
            schemaModel.addChildComponent((Component)schemaComponent2, schemaComponent3.copy((Component)schemaComponent2), -1);
        }
    }

    private void moveAttributeContents(LocalAttributeContainer localAttributeContainer, LocalAttributeContainer localAttributeContainer2) {
        if (localAttributeContainer == null || localAttributeContainer2 == null) {
            return;
        }
        SchemaModel schemaModel = this.getSchemaModel();
        ArrayList<Class> arrayList = new ArrayList<Class>(4);
        arrayList.add(LocalAttribute.class);
        arrayList.add(AttributeReference.class);
        arrayList.add(AttributeGroupReference.class);
        arrayList.add(AnyAttribute.class);
        for (SchemaComponent schemaComponent : localAttributeContainer.getChildren(arrayList)) {
            if (localAttributeContainer2.canPaste((Component)schemaComponent)) {
                schemaModel.addChildComponent((Component)localAttributeContainer2, schemaComponent.copy((Component)localAttributeContainer2), -1);
            }
            schemaModel.removeChildComponent((Component)schemaComponent);
        }
    }

    private void moveComplexContents(LocalAttributeContainer localAttributeContainer, LocalAttributeContainer localAttributeContainer2) {
        if (localAttributeContainer == null || localAttributeContainer2 == null) {
            return;
        }
        SchemaModel schemaModel = this.getSchemaModel();
        ArrayList<Class<ComplexTypeDefinition>> arrayList = new ArrayList<Class<ComplexTypeDefinition>>(4);
        arrayList.add(LocalAttribute.class);
        arrayList.add(AttributeReference.class);
        arrayList.add(AttributeGroupReference.class);
        arrayList.add(AnyAttribute.class);
        arrayList.add(ComplexTypeDefinition.class);
        for (SchemaComponent schemaComponent : localAttributeContainer.getChildren(arrayList)) {
            if (localAttributeContainer2.canPaste((Component)schemaComponent)) {
                schemaModel.addChildComponent((Component)localAttributeContainer2, schemaComponent.copy((Component)localAttributeContainer2), -1);
            }
            schemaModel.removeChildComponent((Component)schemaComponent);
        }
    }

    public void reset() {
        this.removeListeners();
        this.initialize();
        this.initializeUI();
        this.addListeners();
        if (this.hasParent()) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
        this.setResetEnabled(false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ComplexTypeCustomizer.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectionChanged")) {
            this.enableDisableComboBox();
            this.setPreviewText();
            this.determineValidity();
        }
    }

    private void determineValidity() {
        boolean bl;
        this.getMessageDisplayer().clear();
        boolean bl2 = bl = this.isNameable() && this.isNameChanged();
        if (!bl && this.getUIContentType() == this.getModelContentType() && this.getUIInnerContentType() == this.getModelInnerContentType() && this.getUIReference() == this.getModelReference()) {
            if (this.hasParent()) {
                this.setSaveEnabled(false);
            } else {
                this.setSaveEnabled(true);
            }
            this.setResetEnabled(false);
        } else {
            this.setResetEnabled(true);
            boolean bl3 = false;
            switch (this.getUIContentType()) {
                case Extension: {
                    if (!(this.getUIReference() instanceof GlobalSimpleType) && (!(this.getUIReference() instanceof GlobalComplexType) || !(((GlobalComplexType)this.getUIReference()).getDefinition() instanceof SimpleContent) && this.getUIInnerContentType() == null)) break;
                    bl3 = true;
                    break;
                }
                case Restriction: {
                    if (!(this.getUIReference() instanceof GlobalType)) break;
                    bl3 = true;
                    break;
                }
                case Group: {
                    if (!(this.getUIReference() instanceof GlobalGroup)) break;
                    bl3 = true;
                    break;
                }
                case NoType: 
                case Sequence: 
                case Choice: 
                case All: {
                    bl3 = true;
                    break;
                }
            }
            this.setSaveEnabled(bl3 && (!this.isNameChanged() || this.isNameValid()));
            if (!bl3) {
                if (this.getUIContentType() == ContentType.Group) {
                    this.getMessageDisplayer().annotate(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"MSG_Group_Error"), MessageDisplayer.Type.ERROR);
                } else {
                    this.getMessageDisplayer().annotate(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"MSG_Type_Error"), MessageDisplayer.Type.ERROR);
                }
            }
        }
    }

    private void setPreviewText() {
        StringBuffer stringBuffer = new StringBuffer("<");
        String string = ((ComplexType)this.getReference().get()).getPeer().getPrefix();
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("complexType");
        if (this.isNameable()) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(this.getUIName());
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        ReferenceableSchemaComponent referenceableSchemaComponent = this.getUIReference();
        boolean bl = true;
        if (referenceableSchemaComponent instanceof GlobalSimpleType || referenceableSchemaComponent instanceof GlobalComplexType && ((GlobalComplexType)referenceableSchemaComponent).getDefinition() instanceof SimpleContent) {
            bl = false;
        }
        switch (this.getUIContentType()) {
            case NoType: {
                break;
            }
            case Sequence: {
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("sequence/>");
                break;
            }
            case Choice: {
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("choice/>");
                break;
            }
            case All: {
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("all/>");
                break;
            }
            case Group: {
                stringBuffer.append("\n    <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("group ref=\"");
                if (referenceableSchemaComponent != null) {
                    stringBuffer.append(referenceableSchemaComponent.getName());
                }
                stringBuffer.append("\"/>");
                break;
            }
            case Extension: {
                if (bl) {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("complexContent>");
                } else {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("simpleContent>");
                }
                stringBuffer.append("\n        <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("extension base=\"");
                if (referenceableSchemaComponent != null) {
                    stringBuffer.append(referenceableSchemaComponent.getName());
                }
                stringBuffer.append("\">");
                if (bl && referenceableSchemaComponent != null) {
                    switch (this.getUIInnerContentType()) {
                        case NoType: {
                            break;
                        }
                        case Sequence: {
                            stringBuffer.append("\n            <");
                            if (string != null) {
                                stringBuffer.append(string + ":");
                            }
                            stringBuffer.append("sequence/>");
                            break;
                        }
                        case Choice: {
                            stringBuffer.append("\n            <");
                            if (string != null) {
                                stringBuffer.append(string + ":");
                            }
                            stringBuffer.append("choice/>");
                            break;
                        }
                        case All: {
                            stringBuffer.append("\n            <");
                            if (string != null) {
                                stringBuffer.append(string + ":");
                            }
                            stringBuffer.append("all/>");
                            break;
                        }
                        case Group: {
                            stringBuffer.append("\n            <");
                            if (string != null) {
                                stringBuffer.append(string + ":");
                            }
                            stringBuffer.append("group ref=\"\"/>");
                        }
                    }
                }
                stringBuffer.append("\n        </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("extension>");
                if (bl) {
                    stringBuffer.append("\n    </");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("complexContent>");
                    break;
                }
                stringBuffer.append("\n    </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("simpleContent>");
                break;
            }
            case Restriction: {
                if (bl) {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("complexContent>");
                } else {
                    stringBuffer.append("\n    <");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("simpleContent>");
                }
                stringBuffer.append("\n        <");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("restriction base=\"");
                if (referenceableSchemaComponent != null) {
                    stringBuffer.append(referenceableSchemaComponent.getName());
                }
                stringBuffer.append("\">");
                stringBuffer.append("\n        </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("restriction>");
                if (bl) {
                    stringBuffer.append("\n    </");
                    if (string != null) {
                        stringBuffer.append(string + ":");
                    }
                    stringBuffer.append("complexContent>");
                    break;
                }
                stringBuffer.append("\n    </");
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append("simpleContent>");
            }
        }
        stringBuffer.append("\n</");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("complexType>\n");
        this.previewPane.setText(stringBuffer.toString());
    }

    private SchemaModel getSchemaModel() {
        return this.getSchemaComponent().getModel();
    }

    private ComplexType getSchemaComponent() {
        if (this.getReference() == null || this.getReference().get() == null) {
            return null;
        }
        return (ComplexType)this.getReference().get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContentType {
        NoType(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_NoType")),
        Sequence(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_Sequence")),
        Choice(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_Choice")),
        All(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_All")),
        Group(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_Group")),
        Extension(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_Extension")),
        Restriction(NbBundle.getMessage(ComplexTypeCustomizer.class, (String)"LBL_ComplexType_Content_Restriction"));

        private String label;

        private ContentType(String string2) {
            this.label = string2;
        }

        public String toString() {
            int n = Mnemonics.findMnemonicAmpersand((String)this.label);
            if (n > -1 && n < this.label.length()) {
                String string = this.label.substring(0, n);
                if (n + 1 < this.label.length()) {
                    string = string.concat(this.label.substring(n + 1, this.label.length()));
                }
                return string;
            }
            return this.label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

