/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.metainf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.metainf.SUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Service {
    private final String codebase;
    private final String fileName;
    private final List<String> classes;
    static final String META_INF_SERVICES = "META-INF/services";

    public Service(String string, String string2, List<String> list) {
        this.codebase = string;
        this.fileName = string2;
        this.classes = list;
    }

    static Service createService(String string, String string2, InputStream inputStream) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
            arrayList.add(string3);
        }
        return new Service(string, string2, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Service> readServices(File file) {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                String string = attributes.getValue("OpenIDE-Module");
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith(META_INF_SERVICES) || (string2 = jarEntry.getName().substring(META_INF_SERVICES.length() + 1).trim()).equals("")) continue;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    try {
                        arrayList.add(Service.createService(string, string2.intern(), inputStream));
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Service> getOnlyProjectServices(Project project) {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        try {
            NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
            FileObject fileObject = null;
            fileObject = SUtil.getServicesFolder(project, false);
            if (fileObject != null) {
                String string = nbModuleProvider.getCodeNameBase();
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!fileObjectArray[i].isData() || !VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
                    InputStream inputStream = fileObjectArray[i].getInputStream();
                    try {
                        arrayList.add(Service.createService(string, fileObjectArray[i].getNameExt(), inputStream));
                        continue;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
        }
        return arrayList;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public boolean containsClass(String string) {
        return this.classes.indexOf(string) != -1;
    }

    public void removeClass(String string) {
        this.classes.remove(string);
    }

    private static Set<File> getJars(Project project) throws IOException {
        if (project == null) {
            return SUtil.getPlatformJars();
        }
        NbModuleProvider.NbModuleType nbModuleType = ((NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class)).getModuleType();
        if (nbModuleType == NbModuleProvider.STANDALONE) {
            return LayerUtils.getPlatformJarsForStandaloneProject(project);
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
            assert (suiteProvider != null) : project;
            File file = suiteProvider.getSuiteDirectory();
            if (file == null || !file.isDirectory()) {
                throw new IOException("Could not locate suite for " + project);
            }
            Project project2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            if (!(project2 instanceof SuiteProject)) {
                throw new IOException("Could not load suite for " + project + " from " + file);
            }
            return LayerUtils.getPlatformJarsForSuiteComponentProject(project, (SuiteProject)project2);
        }
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            return LayerUtils.getPlatformJarsForStandaloneProject(project);
        }
        throw new AssertionError((Object)nbModuleType);
    }

    static List<Service> getPlatfromServices(Project project) throws IOException {
        NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(project);
        ArrayList<Service> arrayList = new ArrayList<Service>();
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            Set<NbModuleProject> set = LayerUtils.getProjectsForNetBeansOrgProject((NbModuleProject)project);
            Iterator<NbModuleProject> iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(Service.getOnlyProjectServices(iterator.next()));
            }
        } else {
            Set<File> set = Service.getJars(project);
            for (File file : set) {
                arrayList.addAll(Service.readServices(file));
            }
        }
        return arrayList;
    }

    void removeClass(String string, Project project) {
        String string2 = "-" + string;
        string2 = string2.intern();
        if (this.containsClass(string)) {
            this.removeClass(string);
        } else if (this.containsClass(string2)) {
            this.removeClass(string2);
        } else {
            this.classes.add(string2);
        }
        this.write(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Project project) {
        block8: {
            try {
                FileObject fileObject = null;
                fileObject = SUtil.getServicesFolder(project, true);
                FileObject fileObject2 = fileObject.getFileObject(this.getFileName());
                if (this.classes.size() > 0) {
                    if (fileObject2 == null) {
                        fileObject2 = fileObject.createData(this.getFileName());
                    }
                    OutputStream outputStream = fileObject2.getOutputStream();
                    try {
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                        for (String string : this.classes) {
                            printWriter.println(string);
                        }
                        printWriter.flush();
                        break block8;
                    }
                    finally {
                        outputStream.close();
                    }
                }
                fileObject2.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }
}

