/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.BrandingSupport;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class BasicBrandingModel {
    private BrandingSupport branding;
    private final SuiteProperties suiteProps;
    public static final String NAME_PROPERTY = "app.name";
    public static final String TITLE_PROPERTY = "app.title";
    public static final String ICON_LOCATION_PROPERTY = "app.icon";
    public static final String BRANDING_TOKEN_PROPERTY = "branding.token";
    static final int ICON_WIDTH = 48;
    static final int ICON_HEIGHT = 48;
    private boolean brandingEnabled;
    private boolean brandingChanged = false;
    private String name;
    private String title;
    private BrandingSupport.BrandedFile icon = null;
    private BrandingSupport.BrandedFile icon16 = null;
    private BrandingSupport.BundleKey productInformation = null;
    private BrandingSupport.BundleKey mainWindowTitle = null;
    private BrandingSupport.BundleKey splashWindowTitle = null;
    private BrandingSupport.BundleKey mainWindowTitleNoProject = null;
    private BrandingSupport.BundleKey currentVersion = null;
    private BrandingSupport.BrandedFile splash = null;
    private BrandingSupport.BundleKey splashWidth = null;
    private BrandingSupport.BundleKey splashHeight = null;
    private BrandingSupport.BundleKey splashShowProgressBar = null;
    private BrandingSupport.BundleKey splashRunningTextBounds = null;
    private BrandingSupport.BundleKey splashProgressBarBounds = null;
    private BrandingSupport.BundleKey splashRunningTextFontSize = null;
    private BrandingSupport.BundleKey splashRunningTextColor = null;
    private BrandingSupport.BundleKey splashProgressBarColor = null;
    private BrandingSupport.BundleKey splashProgressBarEdgeColor = null;
    private BrandingSupport.BundleKey splashProgressBarCornerColor = null;
    private final Set<BrandingSupport.BundleKey> splashKeys = new HashSet<BrandingSupport.BundleKey>();
    private BrandingSupport.BundleKey wsEnableDragAndDrop = null;
    private BrandingSupport.BundleKey wsEnableFloating = null;
    private BrandingSupport.BundleKey wsEnableSliding = null;
    private BrandingSupport.BundleKey wsEnableClosingViews = null;
    private BrandingSupport.BundleKey wsEnableClosingEditors = null;
    private BrandingSupport.BundleKey wsEnableResizing = null;
    private BrandingSupport.BundleKey wsEnableMinimumSize = null;
    private BrandingSupport.BundleKey wsEnableMaximization = null;
    private final Set<BrandingSupport.BundleKey> winsysKeys = new HashSet<BrandingSupport.BundleKey>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public BasicBrandingModel(SuiteProperties suiteProperties) {
        this.suiteProps = suiteProperties;
        this.init();
    }

    public boolean isBrandingEnabled() {
        return this.brandingEnabled;
    }

    public void setBrandingEnabled(boolean bl) {
        if (this.brandingEnabled != bl) {
            this.brandingEnabled = bl;
            this.brandingChanged = true;
            this.changeSupport.fireChange();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.isBrandingEnabled()) {
            this.name = string;
            this.suiteProps.setProperty(NAME_PROPERTY, this.getName());
            this.suiteProps.setProperty(BRANDING_TOKEN_PROPERTY, "${app.name}");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void setTitle(String string) {
        if (this.isBrandingEnabled()) {
            this.title = string;
            if (this.productInformation != null) {
                this.productInformation.setValue(string);
            }
            if (this.mainWindowTitle != null) {
                this.mainWindowTitle.setValue(string + " {0}");
            }
            if (this.splashWindowTitle != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(NbBundle.getMessage(BasicBrandingModel.class, (String)"LBL_splash_window_title_prefix"));
                stringBuilder.append(" ").append(string);
                this.splashWindowTitle.setValue(stringBuilder.toString());
            }
            if (this.mainWindowTitleNoProject != null) {
                this.mainWindowTitleNoProject.setValue(string + " {0}");
            }
            if (this.currentVersion != null) {
                this.currentVersion.setValue(string + " {0}");
            }
            this.suiteProps.setProperty(TITLE_PROPERTY, this.getTitle());
        }
    }

    public URL getIconSource() {
        return this.icon != null ? this.icon.getBrandingSource() : null;
    }

    public void setIconSource(URL uRL) {
        if (this.isBrandingEnabled()) {
            this.icon.setBrandingSource(uRL);
            this.suiteProps.setProperty(ICON_LOCATION_PROPERTY, this.getIconLocation());
        }
    }

    public String getIconLocation() {
        File file = this.suiteProps.getProjectDirectoryFile();
        String string = PropertyUtils.relativizeFile((File)file, (File)this.icon.getFileLocation());
        return string;
    }

    public String getSplashLocation() {
        File file = this.suiteProps.getProjectDirectoryFile();
        String string = PropertyUtils.relativizeFile((File)file, (File)this.splash.getFileLocation());
        return string;
    }

    public void store() throws IOException {
        if (this.brandingEnabled) {
            this.getBranding().brandBundleKey(this.productInformation);
            this.getBranding().brandBundleKey(this.mainWindowTitle);
            this.getBranding().brandBundleKey(this.splashWindowTitle);
            this.getBranding().brandBundleKey(this.mainWindowTitleNoProject);
            this.getBranding().brandBundleKey(this.currentVersion);
            boolean bl = this.icon.isModified();
            this.getBranding().brandFile(this.icon, BasicBrandingModel.getScaleAndStoreIconTask(this.icon, 48, 48));
            if (bl) {
                this.icon16.setBrandingSource(this.icon.getBrandingSource());
                this.getBranding().brandFile(this.icon16, BasicBrandingModel.getScaleAndStoreIconTask(this.icon16, 16, 16));
            }
            this.getBranding().brandBundleKeys(this.splashKeys);
            this.getBranding().brandFile(this.splash);
            this.getBranding().brandBundleKeys(this.winsysKeys);
        } else if (this.brandingChanged) {
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.removeProperty(NAME_PROPERTY);
            this.suiteProps.removeProperty(TITLE_PROPERTY);
            this.suiteProps.removeProperty(ICON_LOCATION_PROPERTY);
        }
    }

    private static Runnable getScaleAndStoreIconTask(final BrandingSupport.BrandedFile brandedFile, final int n, final int n2) throws IOException {
        return new Runnable(){

            public void run() {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                ImageIcon imageIcon = new ImageIcon(brandedFile.getBrandingSource());
                graphics2D.drawImage(imageIcon.getImage(), 0, 0, n, n2, null);
                graphics2D.dispose();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", brandedFile.getFileLocation());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
    }

    private BrandingSupport getBranding() {
        if (this.branding == null) {
            try {
                this.branding = BrandingSupport.getInstance(this.suiteProps);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                throw new IllegalStateException(iOException.getLocalizedMessage());
            }
        }
        return this.branding;
    }

    private void init() {
        this.initBundleKeys();
        this.initName(false);
        this.initTitle(false);
        this.brandingEnabledRefresh();
        this.brandingChanged = false;
    }

    void brandingEnabledRefresh() {
        this.brandingEnabled = this.suiteProps.getProperty(BRANDING_TOKEN_PROPERTY) != null;
    }

    private String getSimpleName() {
        Element element = Util.findElement(this.suiteProps.getProject().getHelper().getPrimaryConfigurationData(true), "name", "http://www.netbeans.org/ns/nb-module-suite-project/1");
        String string = element != null ? Util.findText(element) : null;
        return string != null ? string : "???";
    }

    void initName(boolean bl) {
        if (this.name == null || bl) {
            this.name = this.suiteProps.getProperty(NAME_PROPERTY);
        }
        if (this.name == null) {
            this.name = this.getSimpleName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_");
            if (!this.name.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
                this.name = "app";
            }
        }
        assert (this.name != null);
    }

    void initTitle(boolean bl) {
        if (this.title == null || bl) {
            String string = this.suiteProps.getProperty(TITLE_PROPERTY);
            if (string == null && Character.isLowerCase((string = this.getSimpleName()).charAt(0))) {
                string = String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
            }
            assert (string != null);
            this.title = string;
        }
    }

    private void initBundleKeys() {
        this.productInformation = this.getBranding().getBundleKey("org.netbeans.core", "org/netbeans/core/ui/Bundle.properties", "LBL_ProductInformation");
        this.mainWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title");
        this.splashWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "LBL_splash_window_title");
        this.mainWindowTitleNoProject = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title_No_Project");
        this.currentVersion = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "currentVersion");
        this.icon = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame48.gif");
        this.icon16 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame.gif");
        this.splash = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/splash.gif");
        this.splashWidth = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_WIDTH");
        this.splashHeight = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_HEIGHT");
        this.splashShowProgressBar = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashShowProgressBar");
        this.splashRunningTextFontSize = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextFontSize");
        this.splashProgressBarBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarBounds");
        this.splashRunningTextBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextBounds");
        this.splashRunningTextColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextColor");
        this.splashProgressBarColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarColor");
        this.splashProgressBarEdgeColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarEdgeColor");
        this.splashProgressBarCornerColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarCornerColor");
        this.splashKeys.clear();
        if (this.splashWidth != null) {
            this.splashKeys.add(this.splashWidth);
        }
        if (this.splashHeight != null) {
            this.splashKeys.add(this.splashHeight);
        }
        if (this.splashShowProgressBar != null) {
            this.splashKeys.add(this.splashShowProgressBar);
        }
        if (this.splashRunningTextBounds != null) {
            this.splashKeys.add(this.splashRunningTextBounds);
        }
        if (this.splashProgressBarBounds != null) {
            this.splashKeys.add(this.splashProgressBarBounds);
        }
        if (this.splashRunningTextFontSize != null) {
            this.splashKeys.add(this.splashRunningTextFontSize);
        }
        if (this.splashRunningTextColor != null) {
            this.splashKeys.add(this.splashRunningTextColor);
        }
        if (this.splashProgressBarColor != null) {
            this.splashKeys.add(this.splashProgressBarColor);
        }
        if (this.splashProgressBarEdgeColor != null) {
            this.splashKeys.add(this.splashProgressBarEdgeColor);
        }
        if (this.splashProgressBarCornerColor != null) {
            this.splashKeys.add(this.splashProgressBarCornerColor);
        }
        this.splashKeys.remove(null);
        this.wsEnableClosingEditors = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Editor.TopComponent.Closing.Enabled");
        this.wsEnableClosingViews = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "View.TopComponent.Closing.Enabled");
        this.wsEnableDragAndDrop = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.DragAndDrop.Enabled");
        this.wsEnableFloating = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Undocking.Enabled");
        this.wsEnableMinimumSize = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Splitter.Respect.MinimumSize.Enabled");
        this.wsEnableResizing = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Resizing.Enabled");
        this.wsEnableSliding = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Sliding.Enabled");
        this.wsEnableMaximization = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Maximization.Enabled");
        this.winsysKeys.clear();
        if (this.wsEnableClosingEditors != null) {
            this.winsysKeys.add(this.wsEnableClosingEditors);
        }
        if (this.wsEnableClosingViews != null) {
            this.winsysKeys.add(this.wsEnableClosingViews);
        }
        if (this.wsEnableDragAndDrop != null) {
            this.winsysKeys.add(this.wsEnableDragAndDrop);
        }
        if (this.wsEnableFloating != null) {
            this.winsysKeys.add(this.wsEnableFloating);
        }
        if (this.wsEnableMaximization != null) {
            this.winsysKeys.add(this.wsEnableMaximization);
        }
        if (this.wsEnableMinimumSize != null) {
            this.winsysKeys.add(this.wsEnableMinimumSize);
        }
        if (this.wsEnableResizing != null) {
            this.winsysKeys.add(this.wsEnableResizing);
        }
        if (this.wsEnableSliding != null) {
            this.winsysKeys.add(this.wsEnableSliding);
        }
        this.winsysKeys.remove(null);
    }

    public BrandingSupport.BundleKey getSplashWidth() {
        return this.splashWidth;
    }

    public BrandingSupport.BundleKey getSplashHeight() {
        return this.splashHeight;
    }

    public BrandingSupport.BundleKey getSplashShowProgressBar() {
        return this.splashShowProgressBar;
    }

    public BrandingSupport.BundleKey getSplashRunningTextBounds() {
        return this.splashRunningTextBounds;
    }

    public BrandingSupport.BundleKey getSplashProgressBarBounds() {
        return this.splashProgressBarBounds;
    }

    public BrandingSupport.BundleKey getSplashRunningTextFontSize() {
        return this.splashRunningTextFontSize;
    }

    public BrandingSupport.BundleKey getSplashRunningTextColor() {
        return this.splashRunningTextColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarColor() {
        return this.splashProgressBarColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarEdgeColor() {
        return this.splashProgressBarEdgeColor;
    }

    public BrandingSupport.BundleKey getSplashProgressBarCornerColor() {
        return this.splashProgressBarCornerColor;
    }

    public BrandingSupport.BrandedFile getSplash() {
        return this.splash;
    }

    public BrandingSupport.BundleKey getWsEnableClosingEditors() {
        return this.wsEnableClosingEditors;
    }

    public BrandingSupport.BundleKey getWsEnableClosingViews() {
        return this.wsEnableClosingViews;
    }

    public BrandingSupport.BundleKey getWsEnableDragAndDrop() {
        return this.wsEnableDragAndDrop;
    }

    public BrandingSupport.BundleKey getWsEnableFloating() {
        return this.wsEnableFloating;
    }

    public BrandingSupport.BundleKey getWsEnableMaximization() {
        return this.wsEnableMaximization;
    }

    public BrandingSupport.BundleKey getWsEnableMinimumSize() {
        return this.wsEnableMinimumSize;
    }

    public BrandingSupport.BundleKey getWsEnableResizing() {
        return this.wsEnableResizing;
    }

    public BrandingSupport.BundleKey getWsEnableSliding() {
        return this.wsEnableSliding;
    }
}

