/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public final class PlatformComponentFactory {
    private static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");
    private static Set<String> userSuites = new TreeSet<Object>(Collator.getInstance());

    private PlatformComponentFactory() {
    }

    public static JComboBox getNbPlatformsComboxBox() {
        JComboBox jComboBox = new JComboBox(new NbPlatformListModel());
        jComboBox.setRenderer(new NbPlatformListRenderer());
        return jComboBox;
    }

    public static JList getNbPlatformsList() {
        JList jList = new JList(new NbPlatformListModel());
        jList.setSelectionMode(0);
        jList.setCellRenderer(new NbPlatformListRenderer());
        return jList;
    }

    public static JComboBox getSuitesComboBox() {
        SuiteListModel suiteListModel = new SuiteListModel(userSuites);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            String string = SuiteUtils.getSuiteDirectoryPath(projectArray[i]);
            if (string == null) continue;
            suiteListModel.addElement(string);
        }
        JComboBox jComboBox = new JComboBox(suiteListModel);
        if (suiteListModel.getSize() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        return jComboBox;
    }

    public static void addUserSuite(String string) {
        userSuites.add(string);
    }

    public static ListCellRenderer getURLListRenderer() {
        return new URLListRenderer();
    }

    static final class URLListRenderer
    extends DefaultListCellRenderer {
        URLListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            URL uRL = (URL)object;
            File file = FileUtil.archiveOrDirForURL((URL)uRL);
            String string = file != null ? file.getAbsolutePath() : uRL.toString();
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    static final class NbPlatformJavadocRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] javadocRoots;

        NbPlatformJavadocRootsModel(NbPlatform nbPlatform) {
            this.plaf = nbPlatform;
            this.javadocRoots = nbPlatform.getJavadocRoots();
        }

        public Object getElementAt(int n) {
            return this.javadocRoots[n];
        }

        public int getSize() {
            return this.javadocRoots.length;
        }

        void removeJavadocRoots(URL[] uRLArray) {
            try {
                this.plaf.removeJavadocRoots(uRLArray);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void addJavadocRoot(URL uRL) {
            try {
                this.plaf.addJavadocRoot(uRL);
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveJavadocRootsDown(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveJavadocRootDown(nArray[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveJavadocRootsUp(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveJavadocRootUp(nArray[i]);
                }
                this.javadocRoots = this.plaf.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }
    }

    static final class NbPlatformSourceRootsModel
    extends AbstractListModel {
        private NbPlatform plaf;
        private URL[] srcRoots;

        NbPlatformSourceRootsModel(NbPlatform nbPlatform) {
            this.plaf = nbPlatform;
            this.srcRoots = nbPlatform.getSourceRoots();
        }

        public Object getElementAt(int n) {
            return this.srcRoots[n];
        }

        public int getSize() {
            return this.srcRoots.length;
        }

        void removeSourceRoot(URL[] uRLArray) {
            try {
                this.plaf.removeSourceRoots(uRLArray);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, uRLArray.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void addSourceRoot(URL uRL) {
            try {
                this.plaf.addSourceRoot(uRL);
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveSourceRootsDown(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveSourceRootDown(nArray[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        void moveSourceRootsUp(int[] nArray) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    this.plaf.moveSourceRootUp(nArray[i]);
                }
                this.srcRoots = this.plaf.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuiteListModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private Set<String> suites = new TreeSet<Object>(Collator.getInstance());
        private String selectedSuite;

        SuiteListModel(Set<String> set) {
            this.suites.addAll(set);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object == null) {
                return;
            }
            if (this.selectedSuite != object) {
                this.selectedSuite = (String)object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedSuite;
        }

        @Override
        public int getSize() {
            return this.suites.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.suites.toArray()[n];
        }

        public void addElement(Object object) {
            this.suites.add((String)object);
            this.fireIntervalAdded(this, 0, this.suites.size());
        }

        public void insertElementAt(Object object, int n) {
            assert (false) : "Who needs to insertElementAt?";
        }

        @Override
        public void removeElement(Object object) {
            assert (false) : "Who needs to removeElement?";
        }

        @Override
        public void removeElementAt(int n) {
            assert (false) : "Who needs to call removeElementAt?";
        }
    }

    static class ModuleEntryListModel
    extends AbstractListModel {
        private ModuleEntry[] mes;

        ModuleEntryListModel(ModuleEntry[] moduleEntryArray) {
            this.mes = moduleEntryArray;
        }

        public int getSize() {
            return this.mes.length;
        }

        public Object getElementAt(int n) {
            return this.mes[n].getLocalizedName();
        }
    }

    public static class NbPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private NbPlatform[] nbPlafs;
        private Object selectedPlaf;

        private static NbPlatform[] getSortedPlatforms(NbPlatform nbPlatform) {
            Set<NbPlatform> set = NbPlatform.getPlatforms();
            if (nbPlatform != null) {
                set.add(nbPlatform);
            }
            NbPlatform[] nbPlatformArray = set.toArray(new NbPlatform[set.size()]);
            Arrays.sort(nbPlatformArray, new Comparator<NbPlatform>(){

                @Override
                public int compare(NbPlatform nbPlatform, NbPlatform nbPlatform2) {
                    int n = Collator.getInstance().compare(nbPlatform.getLabel(), nbPlatform2.getLabel());
                    if (n != 0) {
                        return n;
                    }
                    return System.identityHashCode(nbPlatform) - System.identityHashCode(nbPlatform2);
                }
            });
            return nbPlatformArray;
        }

        public NbPlatformListModel() {
            this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
            if (this.nbPlafs.length > 0) {
                this.selectedPlaf = this.nbPlafs[0];
            }
        }

        public NbPlatformListModel(NbPlatform nbPlatform) {
            this.nbPlafs = NbPlatformListModel.getSortedPlatforms(nbPlatform);
            this.selectedPlaf = nbPlatform;
        }

        public int getSize() {
            return this.nbPlafs.length;
        }

        public Object getElementAt(int n) {
            return n < this.nbPlafs.length ? this.nbPlafs[n] : null;
        }

        public void setSelectedItem(Object object) {
            assert (object == null || object instanceof NbPlatform);
            if (this.selectedPlaf != object) {
                this.selectedPlaf = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(NbPlatform nbPlatform) {
            try {
                NbPlatform.removePlatform(nbPlatform);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
            }
        }

        NbPlatform addPlatform(String string, String string2, String string3) {
            try {
                NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
                NbPlatform nbPlatform2 = nbPlatform != null ? NbPlatform.addPlatform(string, new File(string2), nbPlatform.getHarnessLocation(), string3) : NbPlatform.addPlatform(string, new File(string2), string3);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                return nbPlatform2;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
                return null;
            }
        }
    }

    private static class NbPlatformListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public NbPlatformListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            NbPlatform nbPlatform = (NbPlatform)object;
            String string = nbPlatform == null ? "" : nbPlatform.getLabel();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (nbPlatform != null && !nbPlatform.isValid()) {
                this.setForeground(INVALID_PLAF_COLOR);
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

