/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProjectGenerator;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewNbModuleWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    static final String PREFERRED_SUITE_DIR = "preferredSuiteDir";
    static final String ONE_SUITE_DEDICATED_MODE = "oneSuiteDedicatedMode";
    private final NewModuleProjectData data;
    private int position;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private FileObject createdProjectFolder;
    private String preferredSuiteDir;
    private Boolean suiteDedicated = Boolean.FALSE;

    private NewNbModuleWizardIterator(Type type) {
        this.data = new NewModuleProjectData(type);
    }

    public static NewNbModuleWizardIterator createModuleIterator() {
        return new NewNbModuleWizardIterator(Type.MODULE);
    }

    public static NewNbModuleWizardIterator createSuiteComponentIterator(SuiteProject suiteProject) {
        NewNbModuleWizardIterator newNbModuleWizardIterator = new NewNbModuleWizardIterator(Type.SUITE_COMPONENT);
        newNbModuleWizardIterator.preferredSuiteDir = suiteProject.getProjectDirectoryFile().getAbsolutePath();
        newNbModuleWizardIterator.suiteDedicated = Boolean.TRUE;
        return newNbModuleWizardIterator;
    }

    public static NewNbModuleWizardIterator createSuiteIterator() {
        return new NewNbModuleWizardIterator(Type.SUITE);
    }

    public static NewNbModuleWizardIterator createApplicationIterator() {
        return new NewNbModuleWizardIterator(Type.APPLICATION);
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator(Project project) {
        NewNbModuleWizardIterator newNbModuleWizardIterator = new NewNbModuleWizardIterator(Type.LIBRARY_MODULE);
        newNbModuleWizardIterator.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath(project);
        assert (newNbModuleWizardIterator.preferredSuiteDir != null) : project + " does not have a SuiteProvider in its lookup?";
        newNbModuleWizardIterator.suiteDedicated = Boolean.TRUE;
        return newNbModuleWizardIterator;
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator() {
        return new NewNbModuleWizardIterator(Type.LIBRARY_MODULE);
    }

    static boolean isSuiteWizard(Type type) {
        return type == Type.SUITE || type == Type.APPLICATION;
    }

    static boolean isSuiteComponentWizard(Type type) {
        return type == Type.SUITE_COMPONENT;
    }

    static boolean isLibraryWizard(Type type) {
        return type == Type.LIBRARY_MODULE;
    }

    public FileObject getCreateProjectFolder() {
        return this.createdProjectFolder;
    }

    public Set instantiate() throws IOException {
        Object object;
        File file = new File(this.data.getProjectFolder());
        ProjectChooser.setProjectsFolder((File)new File(this.data.getProjectLocation()));
        ModuleUISettings.getDefault().setLastUsedPlatformID(this.data.getPlatformID());
        WizardDescriptor wizardDescriptor = this.data.getSettings();
        switch (this.data.getWizardType()) {
            case SUITE: {
                ModuleUISettings.getDefault().setNewSuiteCounter(this.data.getSuiteCounter());
                SuiteProjectGenerator.createSuiteProject(file, this.data.getPlatformID(), false);
                break;
            }
            case APPLICATION: {
                ModuleUISettings.getDefault().setNewSuiteCounter(this.data.getSuiteCounter());
                SuiteProjectGenerator.createSuiteProject(file, this.data.getPlatformID(), true);
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                ModuleUISettings.getDefault().setNewModuleCounter(this.data.getModuleCounter());
                if (this.data.isNetBeansOrg()) {
                    NbModuleProjectGenerator.createNetBeansOrgModule(file, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer());
                    break;
                }
                if (this.data.isStandalone()) {
                    NbModuleProjectGenerator.createStandAloneModule(file, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), this.data.getPlatformID());
                    break;
                }
                NbModuleProjectGenerator.createSuiteComponentModule(file, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), new File(this.data.getSuiteRoot()));
                break;
            }
            case LIBRARY_MODULE: {
                object = LibraryStartVisualPanel.convertStringToFiles((String)wizardDescriptor.getProperty("LIBRARY_PATH_VALUE"));
                File file2 = null;
                String string = (String)wizardDescriptor.getProperty("LICENSE_PATH_VALUE");
                if (string != null && string.length() > 0) {
                    file2 = new File(string);
                }
                NbModuleProjectGenerator.createSuiteLibraryModule(file, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), new File(this.data.getSuiteRoot()), file2, (File[])object);
                break;
            }
            default: {
                throw new IllegalStateException("Uknown wizard type: " + (Object)((Object)this.data.getWizardType()));
            }
        }
        this.createdProjectFolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        object = new HashSet();
        object.add(this.createdProjectFolder);
        UIUtil.setProjectChooserDirParent(file);
        wizardDescriptor.putProperty("setAsMain", (Object)this.data.isMainProject());
        return object;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        String[] stringArray;
        this.data.setSettings(wizardDescriptor);
        if (this.preferredSuiteDir == null && (stringArray = OpenProjects.getDefault().getMainProject()) != null) {
            this.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath((Project)stringArray);
        }
        if (this.preferredSuiteDir != null) {
            wizardDescriptor.putProperty(PREFERRED_SUITE_DIR, (Object)this.preferredSuiteDir);
            wizardDescriptor.putProperty(ONE_SUITE_DEDICATED_MODE, (Object)this.suiteDedicated);
        }
        this.position = 0;
        stringArray = null;
        switch (this.data.getWizardType()) {
            case MODULE: {
                stringArray = this.initModuleWizard();
                break;
            }
            case SUITE_COMPONENT: {
                stringArray = this.initModuleWizard();
                break;
            }
            case SUITE: 
            case APPLICATION: {
                stringArray = this.initSuiteModuleWizard();
                break;
            }
            case LIBRARY_MODULE: {
                stringArray = this.initLibraryModuleWizard();
                break;
            }
            default: {
                assert (false) : "Should never get here. type: " + (Object)((Object)this.data.getWizardType());
                break;
            }
        }
        for (int i = 0; i < this.panels.size(); ++i) {
            Component component = this.panels.get(i).getComponent();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    private String[] initModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new BasicInfoWizardPanel(this.data));
        this.panels.add(new BasicConfWizardPanel(this.data));
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicConfigPanel_Title")};
        return stringArray;
    }

    private String[] initSuiteModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new BasicInfoWizardPanel(this.data));
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title")};
        return stringArray;
    }

    private String[] initLibraryModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new LibraryStartWizardPanel(this.data));
        this.panels.add(new BasicInfoWizardPanel(this.data));
        this.panels.add(new LibraryConfWizardPanel(this.data));
        String[] stringArray = new String[]{NewNbModuleWizardIterator.getMessage("LBL_LibraryStartPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_PlatformSelectionPanel_Title")};
        return stringArray;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.position < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels.get(this.position);
    }

    static String getMessage(String string) {
        return NbBundle.getMessage(NewNbModuleWizardIterator.class, (String)string);
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        MODULE,
        SUITE,
        APPLICATION,
        LIBRARY_MODULE,
        SUITE_COMPONENT;

    }
}

