/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.moduleinstall;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.moduleinstall.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ModuleInstallPanel
extends BasicWizardIterator.Panel {
    private final DataModel data;
    private DocumentListener updateListener;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JLabel projectName;
    private JTextField projectNameValue;

    public ModuleInstallPanel(WizardDescriptor wizardDescriptor, DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        if (dataModel.getPackageName() != null) {
            this.packageName.setSelectedItem(dataModel.getPackageName());
        }
        this.putClientProperty("NewFileWizard_Title", ModuleInstallPanel.getMessage("LBL_ModuleInstallWizardTitle"));
        this.updateListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ModuleInstallPanel.this.updateData();
            }
        };
    }

    private void addListeners() {
        Component component = this.packageName.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(this.updateListener);
        }
    }

    private void removeListeners() {
        Component component = this.packageName.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().removeDocumentListener(this.updateListener);
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
    }

    public void addNotify() {
        super.addNotify();
        this.updateData();
    }

    private void updateData() {
        this.data.setPackageName(this.packageName.getEditor().getItem().toString());
        if (this.checkValidity()) {
            this.createdFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
            this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        }
    }

    private boolean checkValidity() {
        String string;
        String string2 = this.getModuleInstall();
        if (string2 != null) {
            this.setError(NbBundle.getMessage(ModuleInstallPanel.class, (String)"ERR_ModuleInstallAlreadyPresented", (Object)string2));
            return false;
        }
        String string3 = string = this.packageName.getEditor().getItem() == null ? "" : this.packageName.getEditor().getItem().toString().trim();
        if (string.length() == 0 || !UIUtil.isValidPackageName(string)) {
            this.setError(ModuleInstallPanel.getMessage("ERR_PackageInvalid"));
            return false;
        }
        String[] stringArray = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (stringArray.length > 0) {
            this.setError(NbBundle.getMessage(ModuleInstallPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)stringArray[0]));
            return false;
        }
        this.markValid();
        return true;
    }

    protected String getPanelName() {
        return ModuleInstallPanel.getMessage("LBL_ModuleInstallPanel_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ModuleInstallPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(ModuleInstallPanel.class, (String)string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(ModuleInstallPanel.getMessage("ACS_form"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(ModuleInstallPanel.getMessage("ACS_CTL_ProjectName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(ModuleInstallPanel.getMessage("ACS_CTL_PackageName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(ModuleInstallPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(ModuleInstallPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    private String getModuleInstall() {
        String string;
        block2: {
            string = null;
            try {
                EditableManifest editableManifest = Util.loadManifest(this.data.getModuleInfo().getManifestFile());
                string = editableManifest.getAttribute("OpenIDE-Module-Install", null);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)iOException);
            }
        }
        return string;
    }

    private void initComponents() {
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.packageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameTxt = new JLabel();
        this.setLayout(new GridBagLayout());
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/moduleinstall/Bundle").getString("LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/moduleinstall/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/moduleinstall/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.packageName, gridBagConstraints);
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage(ModuleInstallPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.packageNameTxt, gridBagConstraints);
    }
}

