/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CasaGraphAbstractScene<N, E, P, G>
extends ObjectScene {
    private HashSet<N> regions = new HashSet();
    private Set<N> regionsUm = Collections.unmodifiableSet(this.regions);
    private HashSet<N> nodes = new HashSet();
    private Set<N> nodesUm = Collections.unmodifiableSet(this.nodes);
    private HashSet<E> edges = new HashSet();
    private Set<E> edgesUm = Collections.unmodifiableSet(this.edges);
    private HashSet<P> pins = new HashSet();
    private Set<P> pinsUm = Collections.unmodifiableSet(this.pins);
    private HashSet<G> processes = new HashSet();
    private Set<G> processesUm = Collections.unmodifiableSet(this.processes);
    private HashMap<N, HashSet<P>> nodePins = new HashMap();
    private HashMap<N, HashSet<G>> nodeProcesses = new HashMap();
    private HashMap<P, N> pinNodes = new HashMap();
    private HashMap<G, N> processNodes = new HashMap();
    private HashMap<E, P> edgeSourcePins = new HashMap();
    private HashMap<E, P> edgeTargetPins = new HashMap();
    private HashMap<P, List<E>> pinInputEdges = new HashMap();
    private HashMap<P, List<E>> pinOutputEdges = new HashMap();

    public Widget addRegion(N n) {
        assert (n != null);
        assert (!this.regions.contains(n));
        Widget widget = this.attachRegionWidget(n);
        this.addObject(n, new Widget[]{widget});
        this.regions.add(n);
        this.notifyRegionAdded(n, widget);
        return widget;
    }

    public final void removeRegion(N n) {
        assert (n != null);
        assert (this.regions.contains(n));
        this.regions.remove(n);
        Widget widget = this.findWidget(n);
        this.removeObject(n);
        this.detachRegionWidget(n, widget);
    }

    public final Collection<N> getRegions() {
        return this.regionsUm;
    }

    public Widget addNode(N n) {
        assert (n != null);
        assert (!this.nodes.contains(n));
        Widget widget = this.attachNodeWidget(n);
        this.addObject(n, new Widget[]{widget});
        this.nodes.add(n);
        this.nodePins.put(n, new HashSet());
        this.nodeProcesses.put(n, new HashSet());
        this.notifyNodeAdded(n, widget);
        return widget;
    }

    public final void removeNode(N n) {
        assert (n != null);
        assert (this.nodes.contains(n));
        for (Object e : new HashSet(this.nodePins.get(n))) {
            this.removePin(e);
        }
        for (Object e : new HashSet(this.nodeProcesses.get(n))) {
            this.removeProcess(e);
        }
        this.nodes.remove(n);
        this.nodePins.remove(n);
        this.nodeProcesses.remove(n);
        Widget widget = this.findWidget(n);
        this.removeObject(n);
        this.detachNodeWidget(n, widget);
    }

    public final void refreshNode(N n) {
        assert (n != null);
        assert (this.nodes.contains(n));
        Widget widget = this.findWidget(n);
        this.refreshWidgetBadge(n, widget);
    }

    public final Collection<N> getNodes() {
        return this.nodesUm;
    }

    public final Collection<G> getProcesses() {
        return this.processesUm;
    }

    public final Widget addEdge(E e) {
        assert (e != null);
        assert (!this.edges.contains(e));
        Widget widget = this.attachEdgeWidget(e);
        this.addObject(e, new Widget[]{widget});
        this.edges.add(e);
        this.notifyEdgeAdded(e, widget);
        return widget;
    }

    public final void removeEdge(E e) {
        assert (e != null);
        assert (this.edges.contains(e));
        this.setEdgeSource(e, null);
        this.setEdgeTarget(e, null);
        this.edges.remove(e);
        this.edgeSourcePins.remove(e);
        this.edgeTargetPins.remove(e);
        Widget widget = this.findWidget(e);
        this.removeObject(e);
        this.detachEdgeWidget(e, widget);
    }

    public final Collection<E> getEdges() {
        return this.edgesUm;
    }

    public final Widget addPin(N n, P p) {
        assert (n != null);
        assert (p != null);
        assert (!this.pins.contains(p));
        Widget widget = this.attachPinWidget(n, p);
        this.addObject(p, new Widget[]{widget});
        this.pins.add(p);
        this.nodePins.get(n).add(p);
        this.pinNodes.put(p, n);
        this.pinInputEdges.put(p, new ArrayList());
        this.pinOutputEdges.put(p, new ArrayList());
        this.notifyPinAdded(n, p, widget);
        return widget;
    }

    public final void removePin(P p) {
        Object object2;
        assert (p != null);
        assert (this.pins.contains(p));
        for (Object object2 : this.findPinEdges(p, true, false)) {
            this.setEdgeSource(object2, null);
        }
        for (Object object2 : this.findPinEdges(p, false, true)) {
            this.setEdgeTarget(object2, null);
        }
        this.pins.remove(p);
        Iterator<Object> iterator = this.pinNodes.remove(p);
        this.nodePins.get(iterator).remove(p);
        this.pinInputEdges.remove(p);
        this.pinOutputEdges.remove(p);
        object2 = this.findWidget(p);
        this.removeObject(p);
        this.detachPinWidget(p, (Widget)object2);
    }

    public final Widget addProcess(N n, G g) {
        assert (n != null);
        assert (g != null);
        Widget widget = this.attachProcessWidget(n, g);
        this.addObject(g, new Widget[]{widget});
        this.processes.add(g);
        this.nodeProcesses.get(n).add(g);
        this.processNodes.put(g, n);
        return widget;
    }

    public final void removeProcess(G g) {
        assert (g != null);
        assert (this.processes.contains(g));
        this.processes.remove(g);
        N n = this.processNodes.remove(g);
        this.nodeProcesses.get(n).remove(g);
        Widget widget = this.findWidget(g);
        this.removeObject(g);
        this.detachGroupWidget(g, widget);
    }

    public final N getPinNode(P p) {
        return this.pinNodes.get(p);
    }

    public final Collection<P> getPins() {
        return this.pinsUm;
    }

    public final Collection<P> getNodePins(N n) {
        if (n == null) {
            return null;
        }
        HashSet<P> hashSet = this.nodePins.get(n);
        if (hashSet == null) {
            return null;
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public final void setEdgeSource(E e, P p) {
        assert (e != null);
        assert (this.edges.contains(e));
        if (p != null) assert (this.pins.contains(p));
        P p2 = this.edgeSourcePins.put(e, p);
        if (Utilities.equals(p2, p)) {
            return;
        }
        if (p2 != null) {
            this.pinOutputEdges.get(p2).remove(e);
        }
        if (p != null) {
            this.pinOutputEdges.get(p).add(e);
        }
        this.attachEdgeSourceAnchor(e, p2, p);
    }

    public final void setEdgeTarget(E e, P p) {
        assert (e != null);
        assert (this.edges.contains(e));
        if (p != null) assert (this.pins.contains(p));
        P p2 = this.edgeTargetPins.put(e, p);
        if (Utilities.equals(p2, p)) {
            return;
        }
        if (p2 != null) {
            this.pinInputEdges.get(p2).remove(e);
        }
        if (p != null) {
            this.pinInputEdges.get(p).add(e);
        }
        this.attachEdgeTargetAnchor(e, p2, p);
    }

    public final P getEdgeSource(E e) {
        return this.edgeSourcePins.get(e);
    }

    public final P getEdgeTarget(E e) {
        return this.edgeTargetPins.get(e);
    }

    public final Collection<E> findPinEdges(P p, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        if (bl2) {
            arrayList.addAll(this.pinInputEdges.get(p));
        }
        if (bl) {
            arrayList.addAll(this.pinOutputEdges.get(p));
        }
        return arrayList;
    }

    public final Collection<E> findEdgesBetween(P p, P p2) {
        HashSet<E> hashSet = new HashSet<E>();
        List<E> list = this.pinInputEdges.get(p2);
        List<E> list2 = this.pinOutputEdges.get(p);
        for (E e : list) {
            if (!list2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public boolean isNode(Object object) {
        return this.nodes.contains(object);
    }

    public boolean isEdge(Object object) {
        return this.edges.contains(object);
    }

    public boolean isPin(Object object) {
        return this.pins.contains(object);
    }

    protected void notifyRegionAdded(N n, Widget widget) {
    }

    protected void notifyNodeAdded(N n, Widget widget) {
    }

    protected void notifyEdgeAdded(E e, Widget widget) {
    }

    protected void notifyPinAdded(N n, P p, Widget widget) {
    }

    protected void detachRegionWidget(N n, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachNodeWidget(N n, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachEdgeWidget(E e, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachPinWidget(P p, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachGroupWidget(G g, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected abstract Widget attachRegionWidget(N var1);

    protected abstract Widget attachNodeWidget(N var1);

    protected abstract Widget attachEdgeWidget(E var1);

    protected abstract Widget attachPinWidget(N var1, P var2);

    protected abstract Widget attachProcessWidget(N var1, G var2);

    protected abstract void attachEdgeSourceAnchor(E var1, P var2, P var3);

    protected abstract void attachEdgeTargetAnchor(E var1, P var2, P var3);

    protected abstract void fireSelectionChanged();

    protected abstract void refreshWidgetBadge(N var1, Widget var2);

    public void userSelectionSuggested(Set<?> set, boolean bl) {
        super.userSelectionSuggested(set, bl);
        this.fireSelectionChanged();
    }
}

