/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.casa;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.casaeditor.model.casa.Casa;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaBindingComponentServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponentFactory;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnections;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoints;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaExtensibilityElement;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaLink;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPortState;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPortTypes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPorts;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaRegion;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceUnits;
import org.netbeans.modules.compapp.casaeditor.model.casa.ConnectionState;
import org.netbeans.modules.compapp.casaeditor.model.casa.JBIServiceUnitTransferObject;
import org.netbeans.modules.compapp.casaeditor.model.casa.ReferenceableCasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.impl.CasaAttribute;
import org.netbeans.modules.compapp.casaeditor.model.casa.impl.CasaComponentFactoryImpl;
import org.netbeans.modules.compapp.casaeditor.model.casa.impl.CasaImpl;
import org.netbeans.modules.compapp.casaeditor.model.casa.impl.CasaSyncUpdateVisitor;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.JBIAttributes;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.CasaValidationController;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePluginWizardIterator;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBindingInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.AddProjectAction;
import org.netbeans.modules.compapp.projects.jbi.ui.actions.DeleteModuleAction;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.ExtensibilityElementTemplateFactory;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.visitor.FindWSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.wizard.BindingGenerator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaWrapperModel
extends CasaModel {
    public static final String PROPERTY_PREFIX = "model_property_";
    public static final String PROPERTY_MODEL_RELOAD = "model_property_reload";
    public static final String PROPERTY_CONNECTION_REMOVED = "model_property_connection_removed";
    public static final String PROPERTY_CONNECTION_ADDED = "model_property_connection_added";
    public static final String PROPERTY_CASA_PORT_REMOVED = "model_property_casa_port_removed";
    public static final String PROPERTY_CASA_PORT_ADDED = "model_property_casa_port_added";
    public static final String PROPERTY_CASA_PORT_REFRESH = "model_property_casa_port_refresh";
    public static final String PROPERTY_ENDPOINT_REMOVED = "model_property_endpoint_removed";
    public static final String PROPERTY_ENDPOINT_ADDED = "model_property_endpoint_added";
    public static final String PROPERTY_ENDPOINT_NAME_CHANGED = "model_property_endpoint_renamed";
    public static final String PROPERTY_ENDPOINT_EXTENSION_CHANGED = "model_property_endpoint_extension_changed";
    public static final String PROPERTY_ENDPOINT_INTERFACE_QNAME_CHANGED = "model_property_endpoint_interface_qname_changed";
    public static final String PROPERTY_ENDPOINT_SERVICE_QNAME_CHANGED = "model_property_endpoint_service_qname_changed";
    public static final String PROPERTY_SERVICE_UNIT_RENAMED = "model_property_service_unit_renamed";
    public static final String PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_ADDED = "model_property_service_unit_added";
    public static final String PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_REMOVED = "model_property_service_unit_removed";
    private static final String COMPAPP_WSDL_RELATIVE_LOCATION = "../jbiasa/";
    private static final String JBI_SERVICE_UNITS_DIR = "jbiServiceUnits";
    private static final String JBI_SOURCE_DIR = "jbiasa";
    private static final String DUMMY_PORTTYPE_NAME = "dummyCasaPortType";
    private CasaComponentFactory factory;
    private Casa casa;
    private PropertyChangeSupport mSupport = new PropertyChangeSupport((Object)this);
    private Map<String, Project> mAddProjects = new HashMap<String, Project>();
    private Map<String, String> mDeleteProjects = new HashMap<String, String>();
    private Map<String, WSDLComponent> cachedWSDLComponents = new HashMap<String, WSDLComponent>();
    private List<String> artifactTypes = new ArrayList<String>();
    private PropertyChangeListener markCasaDirtyListener;
    private Map<String, String> bcNameMap;
    private CasaValidationController controller;

    public CasaWrapperModel(ModelSource modelSource) {
        super(modelSource);
        this.factory = new CasaComponentFactoryImpl(this);
        this.artifactTypes.add("CAPS.asa");
        this.markCasaDirtyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataObject dataObject = CasaWrapperModel.getDataObject((Model)CasaWrapperModel.this);
                if (!dataObject.isModified()) {
                    dataObject.setModified(true);
                }
            }
        };
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.mSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.mSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public List<CasaBindingComponentServiceUnit> getBindingComponentServiceUnits() {
        CasaServiceUnits casaServiceUnits = this.getRootComponent().getServiceUnits();
        return casaServiceUnits.getBindingComponentServiceUnits();
    }

    public List<CasaServiceEngineServiceUnit> getServiceEngineServiceUnits() {
        CasaServiceUnits casaServiceUnits = this.getRootComponent().getServiceUnits();
        return casaServiceUnits.getServiceEngineServiceUnits();
    }

    public boolean existingServiceEngineServiceUnit(String string) {
        for (CasaServiceEngineServiceUnit casaServiceEngineServiceUnit : this.getServiceEngineServiceUnits()) {
            if (!string.equalsIgnoreCase(casaServiceEngineServiceUnit.getUnitName())) continue;
            return true;
        }
        return false;
    }

    public List<CasaPort> getCasaPorts() {
        ArrayList<CasaPort> arrayList = new ArrayList<CasaPort>();
        for (CasaBindingComponentServiceUnit casaBindingComponentServiceUnit : this.getBindingComponentServiceUnits()) {
            for (CasaPort casaPort : casaBindingComponentServiceUnit.getPorts().getPorts()) {
                if (CasaPortState.DELETED.getState().equals(casaPort.getState())) continue;
                arrayList.add(casaPort);
            }
        }
        return arrayList;
    }

    public String getBindingComponentName(CasaPort casaPort) {
        CasaBindingComponentServiceUnit casaBindingComponentServiceUnit = (CasaBindingComponentServiceUnit)((CasaComponent)casaPort.getParent()).getParent();
        return casaBindingComponentServiceUnit.getComponentName();
    }

    public String getBindingType(CasaPort casaPort) {
        String string = casaPort.getBindingType();
        if (string == null) {
            Object object;
            try {
                object = this.getLinkedWSDLPort(casaPort);
                JbiBindingInfo jbiBindingInfo = JbiDefaultComponentInfo.getBindingInfo((Port)object);
                if (jbiBindingInfo != null) {
                    return jbiBindingInfo.getBindingType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = this.getBindingComponentName(casaPort);
            string = this.getDefaultBindingComponents().get(object);
        }
        return string;
    }

    public void setEndpointName(CasaPort casaPort, String string) {
        if (!CasaWrapperModel.isNCName(string)) {
            String string2 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_ENDPOINT_NAME", (Object)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        assert (this.isDefinedInCompApp(casaPort));
        CasaEndpointRef casaEndpointRef = casaPort.getConsumes();
        if (casaEndpointRef == null) {
            casaEndpointRef = casaPort.getProvides();
        }
        assert (casaEndpointRef != null);
        this.setEndpointName(casaPort, casaEndpointRef, string);
    }

    public void setEndpointName(CasaEndpointRef casaEndpointRef, String string) {
        if (!CasaWrapperModel.isNCName(string)) {
            String string2 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_ENDPOINT_NAME", (Object)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        CasaPort casaPort = this.getCasaPort(casaEndpointRef);
        if (casaPort == null) {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef);
            assert (!casaServiceEngineServiceUnit.isInternal());
        } else assert (this.isDefinedInCompApp(casaPort));
        this.setEndpointName(casaEndpointRef, casaEndpointRef, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensibilityElement(CasaComponent casaComponent, CasaExtensibilityElement casaExtensibilityElement) {
        this.startTransaction();
        try {
            casaComponent.addExtensibilityElement(casaExtensibilityElement);
        }
        finally {
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaExtensibilityElement, PROPERTY_ENDPOINT_EXTENSION_CHANGED);
                this.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensibilityElement(CasaComponent casaComponent, CasaExtensibilityElement casaExtensibilityElement) {
        this.startTransaction();
        try {
            casaComponent.removeExtensibilityElement(casaExtensibilityElement);
        }
        finally {
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaExtensibilityElement, PROPERTY_ENDPOINT_EXTENSION_CHANGED);
                this.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtensibilityElementAttribute(CasaExtensibilityElement casaExtensibilityElement, String string, String string2) {
        this.startTransaction();
        try {
            casaExtensibilityElement.setAttribute(string, string2);
        }
        finally {
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaExtensibilityElement, PROPERTY_ENDPOINT_EXTENSION_CHANGED);
                this.endTransaction();
            }
        }
    }

    public Port getLinkedWSDLPort(CasaPort casaPort) {
        String string = casaPort.getLink().getHref();
        Port port = null;
        try {
            port = this.getWSDLComponentFromXLinkHref(string, Port.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return port;
    }

    public <T extends WSDLComponent> T getWSDLComponentFromXLinkHref(String string, Class<T> clazz) throws URISyntaxException, CatalogModelException, XPathExpressionException {
        String string2;
        WSDLComponent wSDLComponent = this.cachedWSDLComponents.get(string);
        if (wSDLComponent == null) {
            string2 = "(.*)#xpointer\\((.*)\\)";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid xlink href: " + string);
            }
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            try {
                WSDLModel wSDLModel = this.getWSDLModel(string3);
                if (wSDLModel != null) {
                    WSDLComponent wSDLComponent2 = (WSDLComponent)wSDLModel.getRootComponent();
                    wSDLComponent = new FindWSDLComponent().findComponent(wSDLComponent2, string4);
                    this.cachedWSDLComponents.put(string, wSDLComponent);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                String string5 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_URI", (Object)string3);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            catch (CatalogModelException catalogModelException) {
                String string6 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_UNAVAILABLE_WSDL_MODEL", (Object)string3);
                System.err.println(string6);
            }
        }
        if (wSDLComponent != null) {
            string2 = wSDLComponent.getModel();
            string2.removePropertyChangeListener(this.markCasaDirtyListener);
            string2.addPropertyChangeListener(this.markCasaDirtyListener);
        }
        return (T)wSDLComponent;
    }

    public CasaEndpointRef getCasaEndpointRef(CasaConnection casaConnection, boolean bl) {
        CasaEndpoint casaEndpoint = bl ? (CasaEndpoint)casaConnection.getConsumer().get() : (CasaEndpoint)casaConnection.getProvider().get();
        return this.getCasaEndpointRef(casaEndpoint, bl);
    }

    private CasaEndpointRef getCasaEndpointRef(CasaEndpoint casaEndpoint, boolean bl) {
        for (CasaServiceEngineServiceUnit casaServiceUnit : this.getServiceEngineServiceUnits()) {
            for (CasaEndpointRef casaEndpointRef : casaServiceUnit.getEndpoints()) {
                if ((!bl || !(casaEndpointRef instanceof CasaConsumes)) && (bl || !(casaEndpointRef instanceof CasaProvides)) || casaEndpointRef.getEndpoint().get() != casaEndpoint) continue;
                return casaEndpointRef;
            }
        }
        for (CasaBindingComponentServiceUnit casaBindingComponentServiceUnit : this.getBindingComponentServiceUnits()) {
            for (CasaPort casaPort : casaBindingComponentServiceUnit.getPorts().getPorts()) {
                CasaEndpointRef casaEndpointRef = bl ? casaPort.getConsumes() : casaPort.getProvides();
                if (casaEndpointRef == null || casaEndpointRef.getEndpoint().get() != casaEndpoint) continue;
                return casaEndpointRef;
            }
        }
        return null;
    }

    public CasaEndpointRef getServiceEngineEndpointRef(CasaEndpoint casaEndpoint) {
        for (CasaServiceEngineServiceUnit casaServiceEngineServiceUnit : this.getServiceEngineServiceUnits()) {
            for (CasaEndpointRef casaEndpointRef : casaServiceEngineServiceUnit.getEndpoints()) {
                if (casaEndpointRef.getEndpoint().get() != casaEndpoint) continue;
                return casaEndpointRef;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, int n, int n2) {
        if (casaServiceEngineServiceUnit.getX() == n && casaServiceEngineServiceUnit.getY() == n2) {
            return;
        }
        this.startTransaction();
        try {
            casaServiceEngineServiceUnit.setX(n);
            casaServiceEngineServiceUnit.setY(n2);
        }
        finally {
            if (this.isIntransaction()) {
                this.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(CasaPort casaPort, int n, int n2) {
        if (casaPort.getX() == n && casaPort.getY() == n2) {
            return;
        }
        this.startTransaction();
        try {
            casaPort.setX(n);
            casaPort.setY(n2);
        }
        finally {
            if (this.isIntransaction()) {
                this.endTransaction();
            }
        }
    }

    public CasaConnection addConnection(CasaConsumes casaConsumes, CasaProvides casaProvides) {
        return this.addConnection(casaConsumes, casaProvides, true);
    }

    public CasaConnection addConnection(CasaConsumes casaConsumes, CasaProvides casaProvides, boolean bl) {
        Object object;
        Object object2;
        if (!this.canConnect(casaConsumes, casaProvides)) {
            throw new RuntimeException("The two endpoints cannot be connected.");
        }
        boolean bl2 = this.isEndpointDefined(casaConsumes);
        boolean bl3 = this.isEndpointDefined(casaProvides);
        if (bl2 && bl3 && !((QName)(object2 = casaConsumes.getInterfaceQName())).equals(object = casaProvides.getInterfaceQName())) {
            boolean bl4;
            CasaPort casaPort = this.getCasaPort(casaConsumes);
            CasaPort casaPort2 = this.getCasaPort(casaProvides);
            boolean bl5 = casaPort != null && this.isEditable(casaPort) && this.getConnections(casaPort, false).size() == 0;
            boolean bl6 = bl4 = casaPort2 != null && this.isEditable(casaPort2) && this.getConnections(casaPort2, false).size() == 0;
            if (bl4 && bl) {
                this._setEndpointInterfaceQName(casaProvides, null);
            } else {
                this._setEndpointInterfaceQName(casaConsumes, null);
            }
        }
        if ((object2 = this.getCasaConnection(casaConsumes, casaProvides)) == null) {
            object2 = this.addNewConnection(casaConsumes, casaProvides);
        } else {
            object = object2.getState();
            if (!ConnectionState.DELETED.getState().equals(object)) {
                throw new RuntimeException("Cannot add a connection that is marked as \"new\" or \"unchanged\"");
            }
            this.setConnectionState((CasaConnection)object2, ConnectionState.UNCHANGED);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CasaConnection addNewConnection(CasaConsumes casaConsumes, CasaProvides casaProvides) {
        Object object;
        CasaEndpointRef casaEndpointRef = null;
        CasaEndpointRef casaEndpointRef2 = null;
        if (this.isEndpointDefined(casaConsumes)) {
            if (!this.isEndpointDefined(casaProvides)) {
                casaEndpointRef = casaConsumes;
                casaEndpointRef2 = casaProvides;
            }
        } else if (this.isEndpointDefined(casaProvides)) {
            casaEndpointRef = casaProvides;
            casaEndpointRef2 = casaConsumes;
        }
        if (casaEndpointRef != null && casaEndpointRef2 != null) {
            object = casaEndpointRef.getInterfaceQName();
            this._setEndpointInterfaceQName(casaEndpointRef2, (QName)object);
        }
        object = this.getFactory();
        CasaConnection casaConnection = object.createCasaConnection();
        casaConnection.setState(ConnectionState.NEW.getState());
        casaConnection.setConsumer(casaConnection.createReferenceTo((ReferenceableCasaComponent)casaConsumes.getEndpoint().get(), CasaEndpoint.class));
        casaConnection.setProvider(casaConnection.createReferenceTo((ReferenceableCasaComponent)casaProvides.getEndpoint().get(), CasaEndpoint.class));
        CasaConnections casaConnections = this.getRootComponent().getConnections();
        this.startTransaction();
        try {
            casaConnections.addConnection(-1, casaConnection);
        }
        finally {
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_ADDED);
                this.endTransaction();
            }
        }
        return casaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateBindingAndPort(CasaPort casaPort, Port port, QName qName, String string) {
        Import import_2;
        Object object;
        Object object22;
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaPort.getModel();
        PortType portType = casaWrapperModel.getPortType(qName);
        assert (portType != null);
        String string2 = casaWrapperModel.getWSDLLocation(qName);
        ExtensibilityElementTemplateFactory extensibilityElementTemplateFactory = ExtensibilityElementTemplateFactory.getDefault();
        Collection collection = extensibilityElementTemplateFactory.getExtensibilityElementTemplateGroups();
        Vector<LocalizedTemplateGroup> vector = new Vector<LocalizedTemplateGroup>();
        LocalizedTemplateGroup localizedTemplateGroup = null;
        LocalizedTemplateGroup localizedTemplateGroup2 = null;
        for (Object object22 : collection) {
            localizedTemplateGroup = extensibilityElementTemplateFactory.getLocalizedTemplateGroup(object22);
            vector.add(localizedTemplateGroup);
            if (!localizedTemplateGroup.getName().equalsIgnoreCase(string)) continue;
            localizedTemplateGroup2 = localizedTemplateGroup;
            break;
        }
        if (localizedTemplateGroup2 == null) {
            object = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_FAIL_TO_POPULATE_BINDING", (Object)(string == null ? "null" : string.toUpperCase()));
            object22 = new NotifyDescriptor.Message(object, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)object22);
            throw new RuntimeException((String)object);
        }
        object = (Binding)port.getBinding().get();
        object22 = object.getName();
        Service service = (Service)port.getParent();
        String string3 = service.getName();
        String string4 = port.getName();
        LocalizedTemplate localizedTemplate = null;
        LocalizedTemplate[] localizedTemplateArray = localizedTemplateGroup2.getTemplate();
        WSDLModel wSDLModel = port.getModel();
        Definitions definitions = wSDLModel.getDefinitions();
        boolean bl = false;
        if (string2 != null) {
            for (Import import_2 : definitions.getImports()) {
                if (!import_2.getNamespace().equals(qName.getNamespaceURI()) || !import_2.getLocation().equals(string2)) continue;
                bl = true;
                break;
            }
        }
        Import import_3 = null;
        if (string2 != null && !bl) {
            import_3 = wSDLModel.getFactory().createImport();
            import_3.setNamespace(qName.getNamespaceURI());
            import_3.setLocation(string2);
        }
        import_2 = new HashMap();
        import_2.put("BINDING_NAME", object22);
        import_2.put("BINDING_TYPE", localizedTemplateGroup2);
        import_2.put("SERVICE_NAME", string3);
        import_2.put("SERVICEPORT_NAME", string4);
        wSDLModel.startTransaction();
        try {
            if (import_3 != null) {
                definitions.addImport(import_3);
            }
            String string5 = definitions.getTargetNamespace();
            boolean bl2 = true;
            for (int i = 0; i < localizedTemplateArray.length && bl2; ++i) {
                Object object32;
                localizedTemplate = localizedTemplateArray[i];
                import_2.put("BINDING_SUBTYPE", localizedTemplate);
                if (object != null) {
                    definitions.removeBinding(object);
                }
                if (port != null) {
                    for (Object object32 : port.getExtensibilityElements()) {
                        port.removeExtensibilityElement((ExtensibilityElement)object32);
                    }
                }
                BindingGenerator bindingGenerator = new BindingGenerator(wSDLModel, portType, (Map)import_2);
                bindingGenerator.execute();
                object = bindingGenerator.getBinding();
                if (object != null) {
                    localizedTemplate.getMProvider().postProcess(string5, object);
                }
                if (port != null) {
                    localizedTemplate.getMProvider().postProcess(string5, port);
                }
                bl2 = (object32 = localizedTemplate.getMProvider().validate(object)).size() > 0;
            }
        }
        finally {
            if (wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
        }
    }

    public void removeConnection(CasaConnection casaConnection) {
        this.removeConnection(casaConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(CasaConnection casaConnection, boolean bl) {
        String string = casaConnection.getState();
        if (ConnectionState.DELETED.getState().equals(string)) {
            throw new RuntimeException("Trying to remove a connection that has already been marked as \"deleted\"");
        }
        CasaEndpointRef casaEndpointRef = this.getCasaEndpointRef(casaConnection, true);
        CasaEndpointRef casaEndpointRef2 = this.getCasaEndpointRef(casaConnection, false);
        for (CasaEndpointRef casaEndpointRef3 : new CasaEndpointRef[]{casaEndpointRef, casaEndpointRef2}) {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit;
            CasaPort casaPort = this.getCasaPort(casaEndpointRef3);
            if (casaPort != null || (casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef3)) == null || casaServiceEngineServiceUnit.isInternal() || this.getConnections(casaEndpointRef3, false).size() != 1) continue;
            this._setEndpointInterfaceQName(casaEndpointRef3, null);
        }
        if (ConnectionState.NEW.getState().equals(string) || bl) {
            CasaConnections casaConnections = (CasaConnections)casaConnection.getParent();
            this.startTransaction();
            try {
                casaConnections.removeConnection(casaConnection);
            }
            finally {
                if (this.isIntransaction()) {
                    this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_REMOVED);
                    this.endTransaction();
                }
            }
        } else if (ConnectionState.UNCHANGED.getState().equals(string)) {
            this.setConnectionState(casaConnection, ConnectionState.DELETED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionState(CasaConnection casaConnection, ConnectionState connectionState) {
        String string = casaConnection.getState();
        this.startTransaction();
        try {
            casaConnection.setState(connectionState.getState());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.isIntransaction()) {
                if (ConnectionState.UNCHANGED.getState().equals(string) && ConnectionState.DELETED.equals((Object)connectionState)) {
                    this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_REMOVED);
                } else if (ConnectionState.DELETED.getState().equals(string) && ConnectionState.UNCHANGED.equals((Object)connectionState)) {
                    this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_ADDED);
                } else assert (false) : "Uh? setConnectionState: " + string + "->" + connectionState.getState();
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            if (ConnectionState.UNCHANGED.getState().equals(string) && ConnectionState.DELETED.equals((Object)connectionState)) {
                this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_REMOVED);
            } else if (ConnectionState.DELETED.getState().equals(string) && ConnectionState.UNCHANGED.equals((Object)connectionState)) {
                this.fireChangeEvent(casaConnection, PROPERTY_CONNECTION_ADDED);
            } else assert (false) : "Uh? setConnectionState: " + string + "->" + connectionState.getState();
            this.endTransaction();
        }
    }

    private void fireChangeEvent(CasaComponent casaComponent, String string) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(casaComponent, string, null, null));
    }

    public boolean canConnect(CasaEndpointRef casaEndpointRef, CasaEndpointRef casaEndpointRef2) {
        String string = this.getUnConnectableReason(casaEndpointRef, casaEndpointRef2);
        return string == null;
    }

    public String getUnConnectableReason(CasaEndpointRef casaEndpointRef, CasaEndpointRef casaEndpointRef2) {
        QName qName;
        Object object;
        CasaEndpointRef casaEndpointRef3;
        if (casaEndpointRef instanceof CasaConsumes && casaEndpointRef2 instanceof CasaConsumes) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_TWO_CONSUMES");
        }
        if (casaEndpointRef instanceof CasaProvides && casaEndpointRef2 instanceof CasaProvides) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_TWO_PROVIDES");
        }
        CasaEndpointRef casaEndpointRef4 = casaEndpointRef3 = casaEndpointRef instanceof CasaConsumes ? casaEndpointRef : casaEndpointRef2;
        if (this.getConnections(casaEndpointRef3, false).size() > 0) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_TWO_PROVIDES_WITH_ONE_CONSUMES");
        }
        CasaPort casaPort = this.getCasaPort(casaEndpointRef);
        CasaPort casaPort2 = this.getCasaPort(casaEndpointRef2);
        if (casaPort != null && casaPort2 != null && casaPort == casaPort2) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_SAME_BC_TO_BC");
        }
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef);
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit2 = this.getCasaEngineServiceUnit(casaEndpointRef2);
        if (casaServiceEngineServiceUnit != null && casaServiceEngineServiceUnit2 != null && !casaServiceEngineServiceUnit.isInternal() && !casaServiceEngineServiceUnit2.isInternal()) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_TWO_EXTERNAL_ENDPOINTS");
        }
        boolean bl = this.isEndpointDefined(casaEndpointRef);
        if (bl && !this.isEndpointPortTypeAvailable(casaEndpointRef)) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_PORTTYPE_NOT_AVAILABLE", (Object)casaEndpointRef.getFullyQualifiedEndpointName());
        }
        boolean bl2 = this.isEndpointDefined(casaEndpointRef2);
        if (bl2 && !this.isEndpointPortTypeAvailable(casaEndpointRef2)) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_PORTTYPE_NOT_AVAILABLE", (Object)casaEndpointRef2.getFullyQualifiedEndpointName());
        }
        if (casaPort != null && (object = this.getLinkedWSDLPort(casaPort)) == null) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CORRUPTED_MODEL_WITH_MISSING_SRC_WSDL_PORT", (Object)casaPort.getLink().getHref());
        }
        if (casaPort2 != null && (object = this.getLinkedWSDLPort(casaPort2)) == null) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CORRUPTED_MODEL_WITH_MISSING_DEST_WSDL_PORT", (Object)casaPort2.getLink().getHref());
        }
        if (bl && bl2 && !((QName)(object = casaEndpointRef.getInterfaceQName())).equals(qName = casaEndpointRef2.getInterfaceQName())) {
            boolean bl3;
            boolean bl4 = casaPort != null && this.isEditable(casaPort, JBIAttributes.INTERFACE_NAME.getName()) && this.getConnections(casaPort, false).size() == 0;
            boolean bl5 = bl3 = casaPort2 != null && this.isEditable(casaPort2, JBIAttributes.INTERFACE_NAME.getName()) && this.getConnections(casaPort2, false).size() == 0;
            if (!bl4 && !bl3) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_INCOMPATIBLE_ENDPOINTS");
            }
        }
        if (!bl && !bl2) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_TWO_UNDEFINED_ENDPOINTS");
        }
        if (casaEndpointRef.getEndpoint().get() == casaEndpointRef2.getEndpoint().get()) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CANNOT_CONNECT_SAME_ENDPOINT");
        }
        return null;
    }

    private boolean isEndpointDefined(CasaEndpointRef casaEndpointRef) {
        QName qName = casaEndpointRef.getInterfaceQName();
        String string = this.getCompAppWSDLTargetNamespace();
        return qName.getLocalPart().trim().length() > 0 && !qName.equals(new QName(string, DUMMY_PORTTYPE_NAME));
    }

    private boolean isEndpointPortTypeAvailable(CasaEndpointRef casaEndpointRef) {
        QName qName = casaEndpointRef.getInterfaceQName();
        return this.getPortType(qName) != null;
    }

    private CasaConnection getCasaConnection(CasaConsumes casaConsumes, CasaProvides casaProvides) {
        List<CasaConnection> list = this.getCasaConnectionList(true);
        CasaEndpoint casaEndpoint = (CasaEndpoint)casaConsumes.getEndpoint().get();
        CasaEndpoint casaEndpoint2 = (CasaEndpoint)casaProvides.getEndpoint().get();
        for (CasaConnection casaConnection : list) {
            if (casaConnection.getConsumer().get() != casaEndpoint || casaConnection.getProvider().get() != casaEndpoint2) continue;
            return casaConnection;
        }
        return null;
    }

    public Map<String, String> getDefaultBindingComponents() {
        if (this.bcNameMap == null) {
            this.bcNameMap = new HashMap<String, String>();
            JbiDefaultComponentInfo jbiDefaultComponentInfo = JbiDefaultComponentInfo.getJbiDefaultComponentInfo();
            assert (jbiDefaultComponentInfo != null);
            List list = jbiDefaultComponentInfo.getBindingInfoList();
            for (JbiBindingInfo jbiBindingInfo : list) {
                this.bcNameMap.put(jbiBindingInfo.getBindingComponentName(), jbiBindingInfo.getBindingType());
            }
        }
        return this.bcNameMap;
    }

    public List<CasaConnection> getCasaConnectionList(boolean bl) {
        ArrayList<CasaConnection> arrayList = new ArrayList<CasaConnection>();
        CasaConnections casaConnections = this.getRootComponent().getConnections();
        for (CasaConnection casaConnection : casaConnections.getConnections()) {
            String string = casaConnection.getState();
            if (!bl && string.equals(ConnectionState.DELETED.getState())) continue;
            arrayList.add(casaConnection);
        }
        return arrayList;
    }

    public List<PortType> getPortTypes() {
        ArrayList<PortType> arrayList = new ArrayList<PortType>();
        CasaPortTypes casaPortTypes = this.getRootComponent().getPortTypes();
        for (CasaLink casaLink : casaPortTypes.getLinks()) {
            String string = casaLink.getHref();
            try {
                PortType portType = this.getWSDLComponentFromXLinkHref(string, PortType.class);
                arrayList.add(portType);
            }
            catch (Exception exception) {
                System.out.println("Failed to Fetch: " + string);
            }
        }
        return arrayList;
    }

    public PortType getCasaPortType(CasaPort casaPort) {
        Port port = this.getLinkedWSDLPort(casaPort);
        if (port == null) {
            return null;
        }
        return (PortType)((Binding)port.getBinding().get()).getType().get();
    }

    public static boolean isDummyPortType(PortType portType) {
        return portType.getName().equals(DUMMY_PORTTYPE_NAME);
    }

    public PortType getPortType(QName qName) {
        CasaPortTypes casaPortTypes = this.getRootComponent().getPortTypes();
        for (CasaLink casaLink : casaPortTypes.getLinks()) {
            String string = casaLink.getHref();
            try {
                PortType portType = this.getWSDLComponentFromXLinkHref(string, PortType.class);
                if (!qName.getNamespaceURI().equals(portType.getModel().getDefinitions().getTargetNamespace()) || !qName.getLocalPart().equals(portType.getName())) continue;
                return portType;
            }
            catch (Exception exception) {
                System.out.println("Failed to fetch portType: " + qName);
            }
        }
        return null;
    }

    private String getWSDLLocation(QName qName) {
        CasaPortTypes casaPortTypes = this.getRootComponent().getPortTypes();
        for (CasaLink casaLink : casaPortTypes.getLinks()) {
            String string = casaLink.getHref();
            try {
                PortType portType = this.getWSDLComponentFromXLinkHref(string, PortType.class);
                if (!qName.getNamespaceURI().equals(portType.getModel().getDefinitions().getTargetNamespace()) || !qName.getLocalPart().equals(portType.getName())) continue;
                return string.substring(0, string.indexOf("#xpointer"));
            }
            catch (Exception exception) {
                System.out.println("Failed to fetch WSDL location: " + string);
            }
        }
        return null;
    }

    public CasaServiceEngineServiceUnit addServiceEngineServiceUnit(boolean bl, int n, int n2) {
        String string = this.getUniqueUnknownServiceEngineServiceUnitName();
        return this._addServiceEngineServiceUnit(string, "", null, bl, true, !bl, n, n2);
    }

    private String getUniqueUnknownServiceEngineServiceUnitName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CasaServiceEngineServiceUnit casaServiceEngineServiceUnit : this.getServiceEngineServiceUnits()) {
            if (!casaServiceEngineServiceUnit.isUnknown()) continue;
            arrayList.add(casaServiceEngineServiceUnit.getUnitName());
        }
        String string = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_UNKNOWN_EXTERNAL_SESU_PREFIX");
        return CasaWrapperModel.getUniqueName(arrayList, string);
    }

    public CasaServiceEngineServiceUnit addServiceEngineServiceUnit(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        return this._addServiceEngineServiceUnit(string, string2, string3, bl, bl2, bl3, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CasaServiceEngineServiceUnit _addServiceEngineServiceUnit(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        CasaComponentFactory casaComponentFactory = this.getFactory();
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = casaComponentFactory.createCasaEngineServiceUnit();
        casaServiceEngineServiceUnit.setX(n);
        casaServiceEngineServiceUnit.setY(n2);
        casaServiceEngineServiceUnit.setInternal(bl);
        casaServiceEngineServiceUnit.setUnknown(bl2);
        casaServiceEngineServiceUnit.setDefined(bl3);
        casaServiceEngineServiceUnit.setName(string);
        casaServiceEngineServiceUnit.setUnitName(string);
        casaServiceEngineServiceUnit.setDescription(string3 == null ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_SERVICE_UNIT_DESCRIPTION") : string3);
        casaServiceEngineServiceUnit.setComponentName(string2);
        casaServiceEngineServiceUnit.setArtifactsZip(string + ".jar");
        CasaServiceUnits casaServiceUnits = this.getRootComponent().getServiceUnits();
        this.startTransaction();
        try {
            casaServiceUnits.addServiceEngineServiceUnit(-1, casaServiceEngineServiceUnit);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaServiceEngineServiceUnit, PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_ADDED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaServiceEngineServiceUnit, PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_ADDED);
            this.endTransaction();
        }
        return casaServiceEngineServiceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortType getDummyPortType(WSDLModel wSDLModel, boolean bl) {
        Definitions definitions = wSDLModel.getDefinitions();
        for (PortType portType2 : definitions.getPortTypes()) {
            if (!portType2.getName().equals(DUMMY_PORTTYPE_NAME)) continue;
            return portType2;
        }
        PortType portType = null;
        if (bl) {
            PortType portType2;
            portType2 = wSDLModel.getFactory();
            portType = portType2.createPortType();
            portType.setName(DUMMY_PORTTYPE_NAME);
            wSDLModel.startTransaction();
            try {
                definitions.addPortType(portType);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (wSDLModel.isIntransaction()) {
                    wSDLModel.endTransaction();
                }
                throw throwable;
            }
            if (wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
        }
        return portType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CasaPort addCasaPort(String string, String string2, int n, int n2) {
        String string3;
        WSDLModel wSDLModel = this.getCompAppWSDLModel(true);
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        Definitions definitions = wSDLModel.getDefinitions();
        PortType portType = this.getDummyPortType(wSDLModel, true);
        Binding binding = wSDLComponentFactory.createBinding();
        String string4 = CasaWrapperModel.getUniqueBindingName(wSDLModel);
        binding.setName(string4);
        Port port = wSDLComponentFactory.createPort();
        String string5 = CasaWrapperModel.getUniquePortName(wSDLModel);
        port.setName(string5);
        int n3 = definitions.getServices().size();
        Service service = wSDLComponentFactory.createService();
        String string6 = CasaWrapperModel.getUniqueServiceName(wSDLModel);
        service.setName(string6);
        wSDLModel.startTransaction();
        try {
            definitions.addBinding(binding);
            binding.setType(binding.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
            definitions.addService(service);
            service.addPort(port);
            port.setBinding(port.createReferenceTo((ReferenceableWSDLComponent)binding, Binding.class));
            string3 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
            throw throwable;
        }
        if (wSDLModel.isIntransaction()) {
            wSDLModel.endTransaction();
        }
        String string7 = this.getRelativePathForCompAppWSDL();
        string3 = this.getPortHref(string7, string6, string5);
        String string8 = this.getPortTypeHref(string7, DUMMY_PORTTYPE_NAME);
        String string9 = wSDLModel.getDefinitions().getTargetNamespace();
        return this.addCasaPortToModel(string2, string, new QName(string9, DUMMY_PORTTYPE_NAME), new QName(string9, string6), string5, string3, string8, n, n2);
    }

    private String getRelativePathForCompAppWSDL() {
        String string = this.getCompAppWSDLFileName();
        return COMPAPP_WSDL_RELATIVE_LOCATION + string;
    }

    private String getPortHref(String string, String string2, String string3) {
        return string + "#xpointer(/definitions/service[@name='" + string2 + "']/port[@name='" + string3 + "'])";
    }

    private String getPortTypeHref(String string, String string2) {
        return string + "#xpointer(/definitions/portType[@name='" + string2 + "'])";
    }

    private String getCompAppWSDLFileName() {
        Project project = this.getJBIProject();
        if (project != null) {
            return JbiProjectHelper.getJbiProjectName((Project)project) + ".wsdl";
        }
        return "casa.wsdl";
    }

    public CasaPort addCasaPortFromWsdlPort(Port port, File file) {
        try {
            String string;
            JbiBindingInfo jbiBindingInfo = JbiDefaultComponentInfo.getBindingInfo((Port)port);
            if (jbiBindingInfo == null) {
                return null;
            }
            String string2 = ((Service)port.getParent()).getName();
            String string3 = port.getName();
            String string4 = string = file.getCanonicalPath();
            if (string.indexOf(JBI_SERVICE_UNITS_DIR) > 0) {
                string4 = "../" + string.substring(string.indexOf(JBI_SERVICE_UNITS_DIR)).replace('\\', '/');
            } else if (string.indexOf(JBI_SOURCE_DIR) > 0) {
                string4 = "../" + string.substring(string.indexOf(JBI_SOURCE_DIR)).replace('\\', '/');
            }
            String string5 = this.getPortHref(string4, string2, string3);
            for (CasaBindingComponentServiceUnit object22 : this.getBindingComponentServiceUnits()) {
                for (CasaPort casaPort : object22.getPorts().getPorts()) {
                    if (!string5.equals(casaPort.getLink().getHref())) continue;
                    assert (CasaPortState.DELETED.getState().equals(casaPort.getState()));
                    this.setCasaPortState(casaPort, CasaPortState.NORMAL);
                    return casaPort;
                }
            }
            String string6 = port.getModel().getDefinitions().getTargetNamespace();
            String string7 = ((PortType)((Binding)port.getBinding().get()).getType().get()).getName();
            String string8 = this.getPortTypeHref(string4, string7);
            String string9 = jbiBindingInfo.getBindingType();
            String string10 = jbiBindingInfo.getBindingComponentName();
            return this.addCasaPortToModel(string10, string9, new QName(string6, string7), new QName(string6, string2), string3, string5, string8, 0, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private CasaPort addCasaPortToModel(String string, String string2, QName qName, QName qName2, String string3, String string4, String string5, int n, int n2) {
        CasaLink casaLink;
        CasaEndpoints casaEndpoints = this.getRootComponent().getEndpoints();
        CasaComponentFactory casaComponentFactory = this.getFactory();
        CasaEndpoint casaEndpoint = casaComponentFactory.createCasaEndpoint();
        String string6 = CasaWrapperModel.getUniqueEndpointID(this);
        this.startTransaction();
        try {
            casaEndpoint.setName(string6);
            casaEndpoint.setEndpointName(string3);
            casaEndpoint.setInterfaceQName(qName);
            casaEndpoint.setServiceQName(qName2);
            casaEndpoints.addEndpoint(-1, casaEndpoint);
            casaLink = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (this.isIntransaction()) {
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.endTransaction();
        }
        CasaPort casaPort = casaComponentFactory.createCasaPort();
        casaPort.setX(n);
        casaPort.setY(n2);
        casaPort.setBindingType(string2);
        casaLink = casaComponentFactory.createCasaLink();
        casaLink.setHref(string4);
        casaLink.setType("simple");
        casaPort.setLink(casaLink);
        CasaConsumes casaConsumes = casaComponentFactory.createCasaConsumes();
        casaConsumes.setEndpoint(casaConsumes.createReferenceTo(casaEndpoint, CasaEndpoint.class));
        casaPort.setConsumes(casaConsumes);
        CasaProvides casaProvides = casaComponentFactory.createCasaProvides();
        casaProvides.setEndpoint(casaProvides.createReferenceTo(casaEndpoint, CasaEndpoint.class));
        casaPort.setProvides(casaProvides);
        boolean bl = false;
        CasaPortTypes casaPortTypes = this.getRootComponent().getPortTypes();
        for (CasaLink casaComponent : casaPortTypes.getLinks()) {
            if (!casaComponent.getHref().equals(string5)) continue;
            bl = true;
            break;
        }
        Object object = null;
        if (!bl) {
            object = casaComponentFactory.createCasaLink();
            object.setHref(string5);
            object.setType("simple");
        }
        this.startTransaction();
        try {
            void var21_28;
            Object object2;
            void var21_26;
            Object var21_24 = null;
            for (CasaBindingComponentServiceUnit casaBindingComponentServiceUnit : this.getBindingComponentServiceUnits()) {
                if (!casaBindingComponentServiceUnit.getComponentName().equals(string)) continue;
                CasaBindingComponentServiceUnit casaBindingComponentServiceUnit2 = casaBindingComponentServiceUnit;
                break;
            }
            if (var21_26 == null) {
                CasaBindingComponentServiceUnit casaBindingComponentServiceUnit = casaComponentFactory.createCasaBindingServiceUnit();
                casaBindingComponentServiceUnit.setUnitName(string);
                casaBindingComponentServiceUnit.setComponentName(string);
                casaBindingComponentServiceUnit.setName(string);
                casaBindingComponentServiceUnit.setDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_SERVICE_UNIT_DESCRIPTION"));
                casaBindingComponentServiceUnit.setArtifactsZip(string + ".jar");
                object2 = casaComponentFactory.createCasaPorts();
                casaBindingComponentServiceUnit.setPorts((CasaPorts)object2);
                CasaServiceUnits casaServiceUnits = this.getRootComponent().getServiceUnits();
                casaServiceUnits.addBindingComponentServiceUnit(-1, casaBindingComponentServiceUnit);
            }
            object2 = var21_28.getPorts();
            object2.addPort(-1, casaPort);
            if (object != null) {
                casaPortTypes.addLink(-1, (CasaLink)object);
            }
            Object var25_32 = null;
        }
        catch (Throwable throwable) {
            Object var25_33 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_ADDED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_ADDED);
            this.endTransaction();
        }
        return casaPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCasaPort(CasaPort casaPort) {
        block12: {
            Object object;
            CasaEndpoint casaEndpoint;
            Port port;
            String string;
            block11: {
                Object object2;
                string = casaPort.getLink().getHref();
                port = this.getLinkedWSDLPort(casaPort);
                casaEndpoint = casaPort.getConsumes() != null ? (CasaEndpoint)casaPort.getConsumes().getEndpoint().get() : (CasaEndpoint)casaPort.getProvides().getEndpoint().get();
                CasaConsumes casaConsumes = casaPort.getConsumes();
                if (casaConsumes != null) {
                    object2 = this.getConnections(casaConsumes, false).iterator();
                    while (object2.hasNext()) {
                        object = (CasaConnection)object2.next();
                        this.removeConnection((CasaConnection)object, false);
                    }
                }
                if ((object2 = casaPort.getProvides()) != null) {
                    for (CasaComponent casaComponent : this.getConnections((CasaEndpointRef)object2, false)) {
                        this.removeConnection((CasaConnection)casaComponent, false);
                    }
                }
                if (this.isDefinedInCompApp(casaPort)) break block11;
                this.setCasaPortState(casaPort, CasaPortState.DELETED);
                break block12;
            }
            object = (CasaPorts)casaPort.getParent();
            this.startTransaction();
            try {
                if (object.getPorts().size() > 1) {
                    object.removePort(casaPort);
                } else {
                    CasaComponent casaComponent;
                    casaComponent = (CasaBindingComponentServiceUnit)object.getParent();
                    CasaServiceUnits casaServiceUnits = (CasaServiceUnits)casaComponent.getParent();
                    casaServiceUnits.removeBindingComponentServiceUnit((CasaBindingComponentServiceUnit)casaComponent);
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (this.isIntransaction()) {
                    this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REMOVED);
                    this.endTransaction();
                }
                throw throwable;
            }
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REMOVED);
                this.endTransaction();
            }
            this.removeDanglingEndpoint(casaEndpoint);
            if (port != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Binding binding = (Binding)port.getBinding().get();
                        Service service = (Service)port.getParent();
                        Definitions definitions = (Definitions)service.getParent();
                        WSDLModel wSDLModel = port.getModel();
                        wSDLModel.startTransaction();
                        try {
                            if (service != null) {
                                if (port != null) {
                                    service.removePort(port);
                                }
                                definitions.removeService(service);
                            }
                            if (binding != null) {
                                definitions.removeBinding(binding);
                            }
                        }
                        finally {
                            if (wSDLModel.isIntransaction()) {
                                wSDLModel.endTransaction();
                            }
                        }
                    }
                });
            }
            this.cachedWSDLComponents.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCasaPortState(CasaPort casaPort, CasaPortState casaPortState) {
        String string = casaPort.getState();
        this.startTransaction();
        try {
            casaPort.setState(casaPortState.getState());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.isIntransaction()) {
                if (CasaPortState.DELETED.equals((Object)casaPortState)) {
                    this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REMOVED);
                } else if (CasaPortState.DELETED.getState().equals(string)) {
                    this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_ADDED);
                } else assert (false) : "Uh? setCasaPortState: " + string + "->" + casaPortState.getState();
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            if (CasaPortState.DELETED.equals((Object)casaPortState)) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REMOVED);
            } else if (CasaPortState.DELETED.getState().equals(string)) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_ADDED);
            } else assert (false) : "Uh? setCasaPortState: " + string + "->" + casaPortState.getState();
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalEndpoint(CasaEndpointRef casaEndpointRef) {
        List<CasaConnection> list = this.getConnections(casaEndpointRef, false);
        for (CasaConnection casaComponent2 : list) {
            this.removeConnection(casaComponent2, false);
        }
        CasaEndpoint casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaEndpointRef.getParent();
        this.startTransaction();
        try {
            if (casaEndpointRef instanceof CasaConsumes) {
                casaServiceEngineServiceUnit.removeConsumes((CasaConsumes)casaEndpointRef);
            } else {
                casaServiceEngineServiceUnit.removeProvides((CasaProvides)casaEndpointRef);
            }
            Object var6_6 = null;
        }
        catch (Throwable casaEndpoints) {
            Object var6_7 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_REMOVED);
                this.endTransaction();
            }
            throw casaEndpoints;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_REMOVED);
            this.endTransaction();
        }
        CasaEndpoints casaEndpoints = this.getRootComponent().getEndpoints();
        this.startTransaction();
        try {
            casaEndpoints.removeEndpoint(casaEndpoint);
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (this.isIntransaction()) {
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDanglingEndpoint(CasaEndpoint casaEndpoint) {
        for (CasaServiceEngineServiceUnit casaComponent : this.getServiceEngineServiceUnits()) {
            for (CasaEndpointRef casaEndpointRef : casaComponent.getEndpoints()) {
                if (casaEndpointRef.getEndpoint().get() != casaEndpoint) continue;
                return false;
            }
        }
        for (CasaBindingComponentServiceUnit casaBindingComponentServiceUnit : this.getBindingComponentServiceUnits()) {
            for (CasaPort casaPort : casaBindingComponentServiceUnit.getPorts().getPorts()) {
                CasaConsumes casaConsumes = casaPort.getConsumes();
                if (casaConsumes != null && casaConsumes.getEndpoint().get() == casaEndpoint) {
                    return false;
                }
                CasaProvides casaProvides = casaPort.getProvides();
                if (casaProvides == null || casaProvides.getEndpoint().get() != casaEndpoint) continue;
                return false;
            }
        }
        for (CasaConnection casaConnection : this.getCasaConnectionList(true)) {
            if (casaConnection.getConsumer().get() != casaEndpoint && casaConnection.getProvider().get() != casaEndpoint) continue;
            return false;
        }
        CasaEndpoints casaEndpoints = this.getRootComponent().getEndpoints();
        this.startTransaction();
        try {
            casaEndpoints.removeEndpoint(casaEndpoint);
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (this.isIntransaction()) {
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.endTransaction();
        }
        return true;
    }

    public String getComponentName(CasaEndpointRef casaEndpointRef) {
        String string = null;
        CasaPort casaPort = this.getCasaPort(casaEndpointRef);
        if (casaPort != null) {
            string = this.getBindingComponentName(casaPort);
        } else {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef);
            assert (casaServiceEngineServiceUnit != null);
            string = casaServiceEngineServiceUnit.getComponentName();
        }
        return string;
    }

    public CasaPort getCasaPort(CasaEndpointRef casaEndpointRef) {
        CasaComponent casaComponent = (CasaComponent)casaEndpointRef.getParent();
        if (casaComponent instanceof CasaPort) {
            return (CasaPort)casaComponent;
        }
        return null;
    }

    public CasaServiceEngineServiceUnit getCasaEngineServiceUnit(CasaEndpointRef casaEndpointRef) {
        CasaComponent casaComponent = (CasaComponent)casaEndpointRef.getParent();
        if (casaComponent instanceof CasaServiceEngineServiceUnit) {
            return (CasaServiceEngineServiceUnit)casaComponent;
        }
        return null;
    }

    private boolean isBindingComponentEndpoint(CasaEndpointRef casaEndpointRef) {
        return this.getCasaPort(casaEndpointRef) != null;
    }

    public void saveDocument() {
        this.saveRelatedDataObjects();
        this.addPendingProjects();
        this.deletePendingProjects();
    }

    private void saveRelatedDataObjects() {
        List<DataObject> list = this.getRelatedDataObjects();
        for (DataObject dataObject : list) {
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie == null) continue;
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void discardRelatedDataObjects() {
        List<DataObject> list = this.getRelatedDataObjects();
        for (DataObject dataObject : list) {
            dataObject.setModified(false);
            try {
                dataObject.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    private List<DataObject> getRelatedDataObjects() {
        DataObject dataObject;
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        WSDLModel wSDLModel = this.getCompAppWSDLModel(false);
        if (wSDLModel != null && (dataObject = CasaWrapperModel.getDataObject((Model)wSDLModel)) != null) {
            arrayList.add(dataObject);
        }
        return arrayList;
    }

    private static DataObject getDataObject(Model model) {
        Lookup lookup = model.getModelSource().getLookup();
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public CasaEndpointRef addExternalEndpoint(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, boolean bl) {
        return this._addExternalEndpoint(casaServiceEngineServiceUnit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CasaEndpointRef _addExternalEndpoint(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, boolean bl) {
        assert (!casaServiceEngineServiceUnit.isInternal());
        CasaComponentFactory casaComponentFactory = this.getFactory();
        String string = CasaWrapperModel.getUniqueEndpointID(this);
        String string2 = CasaWrapperModel.getUniqueExternalEndpointName(this);
        CasaEndpoint casaEndpoint = casaComponentFactory.createCasaEndpoint();
        casaEndpoint.setName(string);
        casaEndpoint.setEndpointName(string2);
        CasaEndpointRef casaEndpointRef = bl ? casaComponentFactory.createCasaConsumes() : casaComponentFactory.createCasaProvides();
        CasaEndpoints casaEndpoints = this.getRootComponent().getEndpoints();
        this.startTransaction();
        try {
            casaEndpoint.setInterfaceQName(new QName(""));
            casaEndpoint.setServiceQName(new QName(""));
            casaEndpoints.addEndpoint(-1, casaEndpoint);
            casaEndpointRef.setEndpoint(casaEndpointRef.createReferenceTo(casaEndpoint, CasaEndpoint.class));
            if (bl) {
                casaServiceEngineServiceUnit.addConsumes(-1, (CasaConsumes)casaEndpointRef);
            } else {
                casaServiceEngineServiceUnit.addProvides(-1, (CasaProvides)casaEndpointRef);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_ADDED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_ADDED);
            this.endTransaction();
        }
        return casaEndpointRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalEndpoints(JBIServiceUnitTransferObject jBIServiceUnitTransferObject, CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        CasaComponent casaComponent;
        Object object;
        CasaModel casaModel = casaServiceEngineServiceUnit.getModel();
        List<JBIServiceUnitTransferObject.Endpoint> list = jBIServiceUnitTransferObject.getProvidesEndpoints();
        for (JBIServiceUnitTransferObject.Endpoint object22 : list) {
            Object var10_10;
            object = this._addExternalEndpoint(casaServiceEngineServiceUnit, false);
            casaComponent = (CasaEndpoint)object.getEndpoint().get();
            casaModel.startTransaction();
            try {
                casaComponent.setInterfaceQName(object22.getInterfaceQName());
                casaComponent.setServiceQName(object22.getServiceQName());
                casaComponent.setEndpointName(object22.getEndpointName());
                var10_10 = null;
            }
            catch (Throwable casaEndpoint) {
                var10_10 = null;
                if (casaModel.isIntransaction()) {
                    casaModel.endTransaction();
                }
                throw casaEndpoint;
            }
            if (!casaModel.isIntransaction()) continue;
            casaModel.endTransaction();
            {
            }
        }
        List<JBIServiceUnitTransferObject.Endpoint> list2 = jBIServiceUnitTransferObject.getConsumesEndpoints();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object var12_13;
            object = (JBIServiceUnitTransferObject.Endpoint)iterator.next();
            casaComponent = this._addExternalEndpoint(casaServiceEngineServiceUnit, true);
            CasaEndpoint casaEndpoint = (CasaEndpoint)casaComponent.getEndpoint().get();
            casaModel.startTransaction();
            try {
                casaEndpoint.setInterfaceQName(((JBIServiceUnitTransferObject.Endpoint)object).getInterfaceQName());
                casaEndpoint.setServiceQName(((JBIServiceUnitTransferObject.Endpoint)object).getServiceQName());
                casaEndpoint.setEndpointName(((JBIServiceUnitTransferObject.Endpoint)object).getEndpointName());
                var12_13 = null;
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (casaModel.isIntransaction()) {
                    casaModel.endTransaction();
                }
                throw throwable;
            }
            if (!casaModel.isIntransaction()) continue;
            casaModel.endTransaction();
            {
            }
        }
    }

    private void addPendingProjects() {
        try {
            Project project = this.getJBIProject();
            AddProjectAction addProjectAction = new AddProjectAction();
            for (String string : new HashSet<String>(this.mAddProjects.keySet())) {
                Project project2 = this.mAddProjects.get(string);
                AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project2.getLookup().lookup(AntArtifactProvider.class);
                assert (antArtifactProvider != null);
                AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
                boolean bl = addProjectAction.addProject(project, antArtifactArray[0]);
                if (!bl) continue;
                this.mAddProjects.remove(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deletePendingProjects() {
        try {
            Project project = this.getJBIProject();
            DeleteModuleAction deleteModuleAction = (DeleteModuleAction)SystemAction.get(DeleteModuleAction.class);
            for (String string : new HashSet<String>(this.mDeleteProjects.keySet())) {
                String string2 = this.mDeleteProjects.get(string);
                boolean bl = deleteModuleAction.removeProject(project, string2);
                if (!bl) continue;
                this.mDeleteProjects.remove(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addJBIModule(Project project, String string, int n, int n2) {
        String string2 = ProjectUtils.getInformation((Project)project).getDisplayName();
        if (this.mDeleteProjects.containsKey(string2)) {
            this.mDeleteProjects.remove(string2);
        } else {
            this.mAddProjects.put(string2, project);
        }
        this._addServiceEngineServiceUnit(string2, string, null, true, false, false, n, n2);
    }

    public void addJBIModuleFromPlugin(final InternalProjectTypePlugin internalProjectTypePlugin, String string, String string2, int n, int n2) {
        final String string3 = string;
        final String string4 = string2;
        final int n3 = n;
        final int n4 = n2;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_ADDPROJECT_CREATE"));
                try {
                    progressHandle.start(100);
                    InternalProjectTypePluginWizardIterator internalProjectTypePluginWizardIterator = internalProjectTypePlugin.getWizardIterator();
                    WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)internalProjectTypePluginWizardIterator);
                    Project project = null;
                    File file = FileUtil.toFile((FileObject)CasaWrapperModel.this.getJBIProject().getProjectDirectory());
                    File file2 = new File(file, "projs/caps");
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    File file3 = new File(file2, string3);
                    wizardDescriptor.putProperty("projdir", (Object)file3);
                    wizardDescriptor.putProperty("name", (Object)string3);
                    wizardDescriptor.putProperty("j2eeLevel", (Object)"1.4");
                    wizardDescriptor.putProperty("setAsMain", (Object)new Boolean(false));
                    progressHandle.progress(NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_ADDPROJECT_INVOKE"), 20);
                    if (internalProjectTypePluginWizardIterator.hasContent()) {
                        wizardDescriptor.setModal(true);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
                        dialog.setVisible(true);
                    } else {
                        internalProjectTypePluginWizardIterator.instantiate();
                    }
                    progressHandle.progress(NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_ADDPROJECT_SETUP"), 50);
                    project = internalProjectTypePluginWizardIterator.getProject();
                    if (project != null) {
                        CasaWrapperModel.this.addJBIModule(project, string4, n3, n4);
                        CasaWrapperModel.this.copyPrivateProperties(file, file3);
                    }
                    if (CasaWrapperModel.this.mDeleteProjects.containsKey(string3)) {
                        CasaWrapperModel.this.mDeleteProjects.remove(string3);
                    } else {
                        CasaWrapperModel.this.mAddProjects.put(string3, project);
                    }
                    progressHandle.progress(80);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                progressHandle.finish();
            }
        });
    }

    private void copyPrivateProperties(File file, File file2) {
        String string = "nbproject/private/private.properties";
        String string2 = "module.install.dir";
        String string3 = "netbeans.user";
        File file3 = new File(file, string);
        File file4 = new File(file2, string);
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file3);
            FileInputStream fileInputStream2 = new FileInputStream(file4);
            properties.load(fileInputStream);
            properties2.load(fileInputStream2);
            fileInputStream.close();
            fileInputStream2.close();
            String string4 = properties.getProperty(string2);
            String string5 = properties.getProperty(string3);
            properties2.setProperty(string2, string4);
            properties2.setProperty(string3, string5);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            properties2.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceEngineServiceUnit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        Iterator iterator;
        Object object;
        Object object3;
        if (casaServiceEngineServiceUnit.isInternal() && !casaServiceEngineServiceUnit.isUnknown()) {
            object3 = casaServiceEngineServiceUnit.getUnitName();
            if (this.mAddProjects.containsKey(object3)) {
                this.mAddProjects.remove(object3);
            } else {
                this.mDeleteProjects.put((String)object3, casaServiceEngineServiceUnit.getArtifactsZip());
            }
        }
        object3 = new HashSet();
        for (CasaEndpointRef object22 : casaServiceEngineServiceUnit.getEndpoints()) {
            object = this.getConnections(object22, false);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                CasaEndpointRef casaEndpointRef;
                CasaComponent casaComponent = iterator.next();
                CasaEndpointRef casaEndpointRef2 = this.getCasaEndpointRef((CasaEndpoint)casaComponent.getConsumer().get(), true);
                CasaPort casaPort = this.getCasaPort(casaEndpointRef2);
                if (casaPort != null) {
                    object3.add(casaPort);
                }
                if ((casaPort = this.getCasaPort(casaEndpointRef = this.getCasaEndpointRef((CasaEndpoint)casaComponent.getProvider().get(), false))) != null) {
                    object3.add(casaPort);
                }
                this.removeConnection((CasaConnection)casaComponent, true);
            }
        }
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            CasaPort casaPort = (CasaPort)((Object)object4.next());
            if (this.isDefinedInCompApp(casaPort) || this.getConnections(casaPort, true).size() != 0) continue;
            this.removeCasaPort(casaPort);
        }
        object4 = casaServiceEngineServiceUnit.getEndpoints();
        ArrayList<Referenceable> arrayList = new ArrayList<Referenceable>();
        object = object4.iterator();
        while (object.hasNext()) {
            iterator = (CasaEndpointRef)object.next();
            arrayList.add(iterator.getEndpoint().get());
        }
        object = this.getRootComponent().getServiceUnits();
        this.startTransaction();
        try {
            object.removeServiceEngineServiceUnit(casaServiceEngineServiceUnit);
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaServiceEngineServiceUnit, PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_REMOVED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaServiceEngineServiceUnit, PROPERTY_SERVICE_ENGINE_SERVICE_UNIT_REMOVED);
            this.endTransaction();
        }
        for (CasaComponent casaComponent : arrayList) {
            this.removeDanglingEndpoint((CasaEndpoint)casaComponent);
        }
    }

    public Project getJBIProject() {
        try {
            Lookup lookup = this.getModelSource().getLookup();
            FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
            FileObject fileObject2 = fileObject.getParent().getParent().getParent();
            return ProjectManager.getDefault().findProject(fileObject2);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private List<CasaConnection> getConnections(CasaEndpointRef casaEndpointRef, boolean bl) {
        ArrayList<CasaConnection> arrayList = new ArrayList<CasaConnection>();
        CasaEndpoint casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
        for (CasaConnection casaConnection : this.getCasaConnectionList(bl)) {
            if ((!(casaEndpointRef instanceof CasaConsumes) || casaConnection.getConsumer().get() != casaEndpoint) && (!(casaEndpointRef instanceof CasaProvides) || casaConnection.getProvider().get() != casaEndpoint)) continue;
            arrayList.add(casaConnection);
        }
        return arrayList;
    }

    private static String getUniqueEndpointID(CasaWrapperModel casaWrapperModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CasaEndpoint casaEndpoint : casaWrapperModel.getRootComponent().getEndpoints().getEndpoints()) {
            String string = casaEndpoint.getName();
            arrayList.add(string);
        }
        return CasaWrapperModel.getUniqueName(arrayList, "endpoint");
    }

    private static String getUniqueExternalEndpointName(CasaWrapperModel casaWrapperModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CasaEndpoint casaEndpoint : casaWrapperModel.getRootComponent().getEndpoints().getEndpoints()) {
            String string = casaEndpoint.getEndpointName();
            arrayList.add(string);
        }
        return CasaWrapperModel.getUniqueName(arrayList, "extEndpoint");
    }

    private static String getUniquePortTypeName(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PortType portType : wSDLModel.getDefinitions().getPortTypes()) {
            String string = portType.getName();
            arrayList.add(string);
        }
        return CasaWrapperModel.getUniqueName(arrayList, "casaPortType");
    }

    private static String getUniqueBindingName(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Binding binding : wSDLModel.getDefinitions().getBindings()) {
            String string = binding.getName();
            arrayList.add(string);
        }
        return CasaWrapperModel.getUniqueName(arrayList, "casaBinding");
    }

    private static String getUniqueServiceName(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Service service : wSDLModel.getDefinitions().getServices()) {
            String string = service.getName();
            arrayList.add(string);
        }
        return CasaWrapperModel.getUniqueName(arrayList, "casaService");
    }

    private static String getUniquePortName(WSDLModel wSDLModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Service service : wSDLModel.getDefinitions().getServices()) {
            for (Port port : service.getPorts()) {
                String string = port.getName();
                arrayList.add(string);
            }
        }
        return CasaWrapperModel.getUniqueName(arrayList, "casaPort");
    }

    private static String getUniqueName(List<String> list, String string) {
        String string2 = null;
        int n = 1;
        while (list.contains(string2 = string + n)) {
            ++n;
        }
        return string2;
    }

    private WSDLModel getWSDLModel(String string) throws URISyntaxException, CatalogModelException {
        WSDLModel wSDLModel = null;
        ModelSource modelSource = this.getModelSource();
        Lookup lookup = modelSource.getLookup();
        CatalogModel catalogModel = (CatalogModel)lookup.lookup(CatalogModel.class);
        ModelSource modelSource2 = catalogModel.getModelSource(new URI(string), modelSource);
        if (modelSource2 != null) {
            wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource2);
            assert (wSDLModel != null && wSDLModel.getDefinitions() != null);
        }
        return wSDLModel;
    }

    private WSDLModel getCompAppWSDLModel(boolean bl) {
        String string;
        String string2 = this.getCompAppWSDLFileName();
        ModelSource modelSource = this.getModelSource();
        Lookup lookup = modelSource.getLookup();
        CatalogModel catalogModel = (CatalogModel)lookup.lookup(CatalogModel.class);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        URI uRI = null;
        try {
            uRI = new URI(this.getRelativePathForCompAppWSDL());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        ModelSource modelSource2 = null;
        FileObject fileObject2 = fileObject.getParent().getParent();
        FileObject fileObject3 = fileObject2.getFileObject(JBI_SOURCE_DIR);
        if (fileObject3 == null && bl) {
            try {
                fileObject3 = fileObject2.createFolder(JBI_SOURCE_DIR);
            }
            catch (Exception exception) {
                string = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_FAIED_TO_CREATE_DIRECTORY", (Object)"src/jbiasa");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        if (fileObject3 != null) {
            File file = new File(FileUtil.toFile((FileObject)fileObject3), string2);
            try {
                if (!file.exists()) {
                    if (bl) {
                        this.createEmptyCompAppWSDLFile(file);
                        modelSource2 = catalogModel.getModelSource(uRI, modelSource);
                    }
                } else {
                    modelSource2 = catalogModel.getModelSource(uRI, modelSource);
                }
            }
            catch (CatalogModelException catalogModelException) {
                catalogModelException.printStackTrace();
            }
            if (modelSource2 != null) {
                string = WSDLModelFactory.getDefault().getModel(modelSource2);
                return string;
            }
        }
        return null;
    }

    private String getCompAppWSDLTargetNamespace() {
        Project project = this.getJBIProject();
        return JbiProjectHelper.getJbiProjectName((Project)project);
    }

    private void createEmptyCompAppWSDLFile(File file) {
        String string = this.getCompAppWSDLTargetNamespace();
        try {
            FileObject fileObject = FileUtil.createData((File)file);
            OutputStream outputStream = fileObject.getOutputStream();
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println();
            printWriter.println("<!--");
            printWriter.println("  This file is auto-generated by CASA. ");
            printWriter.println("  Edit its content manually may cause unrecoverable errors.");
            printWriter.println("-->");
            printWriter.println();
            printWriter.println("<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\"");
            printWriter.println("             xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"");
            printWriter.println("             xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            printWriter.println("             targetNamespace=\"" + string + "\"");
            printWriter.println("             xmlns:tns=\"" + string + "\">");
            printWriter.println("</definitions>");
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<CasaConnection> getConnections(CasaPort casaPort, boolean bl) {
        CasaProvides casaProvides;
        ArrayList<CasaConnection> arrayList = new ArrayList<CasaConnection>();
        CasaConsumes casaConsumes = casaPort.getConsumes();
        if (casaConsumes != null) {
            arrayList.addAll(this.getConnections(casaConsumes, bl));
        }
        if ((casaProvides = casaPort.getProvides()) != null) {
            arrayList.addAll(this.getConnections(casaProvides, bl));
        }
        return arrayList;
    }

    public boolean isEditable(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        return !casaServiceEngineServiceUnit.isInternal();
    }

    public boolean isEditable(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, String string) {
        if (!this.isEditable(casaServiceEngineServiceUnit)) {
            return false;
        }
        return CasaAttribute.UNIT_NAME.getName().equals(string) || CasaAttribute.DESCRIPTION.getName().equals(string);
    }

    public boolean isEditable(CasaBindingComponentServiceUnit casaBindingComponentServiceUnit) {
        return false;
    }

    public boolean isEditable(CasaPort casaPort) {
        return this.isDefinedInCompApp(casaPort);
    }

    public boolean isEditable(CasaPort casaPort, String string) {
        if (!this.isEditable(casaPort)) {
            return false;
        }
        if (JBIAttributes.INTERFACE_NAME.getName().equals(string)) {
            if (this.getConnections(casaPort, false).size() > 0) {
                return false;
            }
            if (!this.isDefinedInCompAppWSDL(casaPort)) {
                return false;
            }
        }
        return true;
    }

    public boolean isEditable(CasaEndpointRef casaEndpointRef, String string) {
        CasaPort casaPort;
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef);
        if (casaServiceEngineServiceUnit != null ? casaServiceEngineServiceUnit.isInternal() : !this.isEditable(casaPort = this.getCasaPort(casaEndpointRef))) {
            return false;
        }
        return !JBIAttributes.INTERFACE_NAME.getName().equals(string) || (casaPort = this.getCasaPort(casaEndpointRef)) == null;
    }

    private boolean isDefinedInCompApp(CasaPort casaPort) {
        CasaLink casaLink = casaPort.getLink();
        String string = casaLink.getHref();
        return string.startsWith(COMPAPP_WSDL_RELATIVE_LOCATION);
    }

    private boolean isDefinedInCompAppWSDL(CasaPort casaPort) {
        CasaLink casaLink = casaPort.getLink();
        String string = casaLink.getHref();
        return string.startsWith(COMPAPP_WSDL_RELATIVE_LOCATION + this.getCompAppWSDLFileName() + "#xpointer");
    }

    public boolean isDeletable(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        return true;
    }

    public boolean isDeletable(CasaBindingComponentServiceUnit casaBindingComponentServiceUnit) {
        return true;
    }

    public boolean isDeletable(CasaPort casaPort) {
        return true;
    }

    public boolean isDeletable(CasaEndpointRef casaEndpointRef) {
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getCasaEngineServiceUnit(casaEndpointRef);
        return casaServiceEngineServiceUnit != null && !casaServiceEngineServiceUnit.isInternal();
    }

    public boolean isDeletable(CasaConnection casaConnection) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndpointName(CasaComponent casaComponent, CasaEndpointRef casaEndpointRef, String string) {
        Object object;
        Object object2;
        CasaEndpoint casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
        String string2 = casaEndpoint.getEndpointName();
        if (string2.equals(string)) {
            return;
        }
        CasaPort casaPort = null;
        casaPort = casaComponent instanceof CasaPort ? (CasaPort)casaComponent : this.getCasaPort((CasaEndpointRef)casaComponent);
        if (casaPort != null) {
            object2 = this.getLinkedWSDLPort(casaPort);
            object = object2.getModel();
            object.startTransaction();
            try {
                object2.setName(string);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (object.isIntransaction()) {
                    object.endTransaction();
                }
                throw throwable;
            }
            if (object.isIntransaction()) {
                object.endTransaction();
            }
        }
        this.startTransaction();
        try {
            if (casaPort != null) {
                object2 = casaPort.getLink();
                object = object2.getHref();
                object = ((String)object).replaceAll("/port\\[@name='" + string2 + "'\\]", "/port[@name='" + string + "']");
                object2.setHref((String)object);
            }
            casaEndpoint.setEndpointName(string);
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaComponent, PROPERTY_ENDPOINT_NAME_CHANGED);
                if (casaPort != null && casaPort != casaComponent) {
                    this.fireChangeEvent(casaPort, PROPERTY_ENDPOINT_NAME_CHANGED);
                }
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaComponent, PROPERTY_ENDPOINT_NAME_CHANGED);
            if (casaPort != null && casaPort != casaComponent) {
                this.fireChangeEvent(casaPort, PROPERTY_ENDPOINT_NAME_CHANGED);
            }
            this.endTransaction();
        }
    }

    public void setEndpointInterfaceQName(CasaEndpointRef casaEndpointRef, QName qName) {
        this._setEndpointInterfaceQName(casaEndpointRef, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setEndpointInterfaceQName(CasaEndpointRef casaEndpointRef, QName qName) {
        block24: {
            Port port;
            CasaPort casaPort;
            QName qName2;
            CasaEndpoint casaEndpoint;
            block25: {
                Binding binding;
                String string;
                Object object;
                if (casaEndpointRef.getInterfaceQName().equals(qName)) {
                    return;
                }
                casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
                qName2 = casaEndpoint.getInterfaceQName();
                this.startTransaction();
                try {
                    if (qName == null || qName.equals(new QName(""))) {
                        casaPort = this.getCasaPort(casaEndpointRef);
                        if (casaPort != null && this.isDefinedInCompAppWSDL(casaPort)) {
                            port = this.getLinkedWSDLPort(casaPort);
                            object = port.getModel();
                            string = object.getDefinitions().getTargetNamespace();
                            casaEndpoint.setInterfaceQName(new QName(string, DUMMY_PORTTYPE_NAME));
                        } else {
                            casaEndpoint.setInterfaceQName(qName);
                        }
                    } else {
                        casaEndpoint.setInterfaceQName(qName);
                    }
                    binding = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (this.isIntransaction()) {
                        this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_INTERFACE_QNAME_CHANGED);
                        this.endTransaction();
                    }
                    throw throwable;
                }
                if (this.isIntransaction()) {
                    this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_INTERFACE_QNAME_CHANGED);
                    this.endTransaction();
                }
                casaPort = this.getCasaPort(casaEndpointRef);
                if (casaPort == null) {
                    return;
                }
                port = this.getLinkedWSDLPort(casaPort);
                if (port == null) {
                    object = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CORRUPTED_MODEL_WITH_MISSING_WSDL_PORT", (Object)casaPort.getLink().getHref());
                    string = new NotifyDescriptor.Message(object, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
                    return;
                }
                if (!this.isDefinedInCompAppWSDL(casaPort)) break block24;
                object = port.getModel();
                string = object.getDefinitions().getTargetNamespace();
                if (qName != null && !qName.equals(new QName("")) && !qName.equals(new QName(string, DUMMY_PORTTYPE_NAME))) break block25;
                PortType portType = this.getDummyPortType((WSDLModel)object, true);
                object.startTransaction();
                try {
                    for (Object object2 : port.getExtensibilityElements()) {
                        port.removeExtensibilityElement((ExtensibilityElement)object2);
                    }
                    binding = (Binding)port.getBinding().get();
                    for (BindingOperation bindingOperation : binding.getBindingOperations()) {
                        binding.removeBindingOperation(bindingOperation);
                    }
                    for (BindingOperation bindingOperation : binding.getExtensibilityElements()) {
                        binding.removeExtensibilityElement((ExtensibilityElement)bindingOperation);
                    }
                    binding.setType(binding.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (object.isIntransaction()) {
                        object.endTransaction();
                    }
                    throw throwable;
                }
                if (object.isIntransaction()) {
                    object.endTransaction();
                }
                break block24;
            }
            try {
                CasaWrapperModel.populateBindingAndPort(casaPort, port, qName, casaPort.getBindingType());
            }
            catch (RuntimeException runtimeException) {
                this.startTransaction();
                try {
                    casaEndpoint.setInterfaceQName(qName2);
                    Object var16_19 = null;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    if (this.isIntransaction()) {
                        this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_INTERFACE_QNAME_CHANGED);
                        this.endTransaction();
                    }
                    throw throwable;
                }
                if (this.isIntransaction()) {
                    this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_INTERFACE_QNAME_CHANGED);
                    this.endTransaction();
                }
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpointServiceQName(CasaEndpointRef casaEndpointRef, QName qName) {
        String string;
        CasaLink casaLink;
        Object object;
        CasaEndpoint casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
        QName qName2 = casaEndpoint.getServiceQName();
        if (qName2.equals(qName)) {
            return;
        }
        CasaPort casaPort = this.getCasaPort(casaEndpointRef);
        String string2 = qName.getLocalPart();
        if (!CasaWrapperModel.isNCName(string2)) {
            String string3 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_SERVICE_NAME", (Object)string2);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String string4 = qName.getNamespaceURI();
        if (!CasaWrapperModel.isURI(string4)) {
            String string5 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_NAMESPACE_URI", (Object)string4);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String string6 = qName.getPrefix();
        if (!CasaWrapperModel.isNCName(string6)) {
            String string7 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_PREFIX_NAME", (Object)string6);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string7, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (casaPort != null) {
            Object object2;
            if (!string4.equals(qName2.getNamespaceURI())) {
                String string8 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_INVALID_SERVICE_NAMESPACE", (Object)qName2.getNamespaceURI());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string8, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            object = this.getLinkedWSDLPort(casaPort);
            casaLink = (Service)object.getParent();
            string = object.getModel();
            WSDLComponentFactory wSDLComponentFactory = string.getFactory();
            Definitions definitions = object.getModel().getDefinitions();
            Object object3 = null;
            for (Object object4 : definitions.getServices()) {
                if (!object4.getName().equals(string2)) continue;
                object3 = object4;
                break;
            }
            if (object3 != null) {
                object2 = casaEndpointRef.getEndpointName();
                for (Port port : object3.getPorts()) {
                    if (!port.getName().equals(object2)) continue;
                    String string9 = NbBundle.getMessage(CasaWrapperModel.class, (String)"MSG_SETTING_SERVICE_QNAME_CAUSES_PORT_CONFLICT", (Object)qName);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string9, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
            }
            string.startTransaction();
            try {
                if (object3 == null) {
                    object3 = wSDLComponentFactory.createService();
                    object3.setName(string2);
                    definitions.addService((Service)object3);
                }
                object2 = (Port)object.copy((Component)object3);
                if (casaLink.getPorts().size() == 1) {
                    definitions.removeService((Service)casaLink);
                    casaLink = null;
                }
                if (casaLink != null) {
                    casaLink.removePort((Port)object);
                }
                object3.addPort((Port)object2);
                Object var21_28 = null;
            }
            catch (Throwable throwable) {
                Object var21_29 = null;
                if (string.isIntransaction()) {
                    string.endTransaction();
                }
                throw throwable;
            }
            if (string.isIntransaction()) {
                string.endTransaction();
            }
        }
        this.startTransaction();
        try {
            if (casaPort != null) {
                object = qName2.getLocalPart();
                casaLink = casaPort.getLink();
                string = casaLink.getHref();
                string = string.replaceAll("/service\\[@name='" + (String)object + "'\\]", "/service[@name='" + string2 + "']");
                casaLink.setHref(string);
            }
            casaEndpoint.setServiceQName(qName);
            Object var23_31 = null;
        }
        catch (Throwable throwable) {
            Object var23_32 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_SERVICE_QNAME_CHANGED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaEndpointRef, PROPERTY_ENDPOINT_SERVICE_QNAME_CHANGED);
            this.endTransaction();
        }
    }

    public CasaRegion getCasaRegion(CasaRegion.Name name) {
        String string = name.getName();
        List<CasaRegion> list = this.getRootComponent().getRegions().getRegions();
        for (CasaRegion casaRegion : list) {
            if (!casaRegion.getName().equals(string)) continue;
            return casaRegion;
        }
        assert (false) : "Unknown casa region: " + string;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCasaRegionWidth(CasaRegion casaRegion, int n) {
        this.startTransaction();
        try {
            casaRegion.setWidth(n);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.isIntransaction()) {
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnitName(CasaServiceUnit casaServiceUnit, String string) {
        assert (casaServiceUnit instanceof CasaServiceEngineServiceUnit);
        assert (!((CasaServiceEngineServiceUnit)casaServiceUnit).isInternal());
        this.startTransaction();
        try {
            casaServiceUnit.setUnitName(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaServiceUnit, PROPERTY_SERVICE_UNIT_RENAMED);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaServiceUnit, PROPERTY_SERVICE_UNIT_RENAMED);
            this.endTransaction();
        }
    }

    public Map<String, String> getNamespaces() {
        return CasaWrapperModel.getDocumentModelNamespaces(this);
    }

    private static Map<String, String> getDocumentModelNamespaces(AbstractDocumentModel abstractDocumentModel) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        NamedNodeMap namedNodeMap = abstractDocumentModel.getRootComponent().getPeer().getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            Node node = namedNodeMap.item(i);
            String string2 = node.getPrefix();
            if (string2 == null || !string2.equals("xmlns") || (string = node.getLocalName()).equals("xsi") || string.equals("xlink")) continue;
            String string3 = node.getNodeValue();
            treeMap.put(string, string3);
        }
        return treeMap;
    }

    public String getJbiProjectType(Project project) {
        if (project == null) {
            return null;
        }
        if (JbiDefaultComponentInfo.isJavaEEProject((Project)project)) {
            return "sun-javaee-engine";
        }
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antArtifactProvider != null) {
            AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
            Iterator<String> iterator = null;
            String string2 = null;
            if (antArtifactArray != null) {
                for (int i = 0; i < antArtifactArray.length; ++i) {
                    for (String string2 : this.artifactTypes) {
                        String string3 = antArtifactArray[i].getType();
                        if (!string3.startsWith(string2)) continue;
                        int n = string3.indexOf(58) + 1;
                        return string3.substring(n);
                    }
                }
            }
        }
        return null;
    }

    public void clearCache() {
        this.cachedWSDLComponents.clear();
    }

    public void sync() throws IOException {
        super.sync();
        WSDLModel wSDLModel = this.getCompAppWSDLModel(false);
        if (wSDLModel != null) {
            wSDLModel.sync();
        }
        this.cachedWSDLComponents.clear();
        super.refresh();
        this.mSupport.firePropertyChange(new PropertyChangeEvent((Object)this, PROPERTY_MODEL_RELOAD, null, null));
    }

    public List<Validator.ResultItem> validate() {
        ArrayList<Validator.ResultItem> arrayList = new ArrayList<Validator.ResultItem>();
        ArrayList<CasaWrapperModel> arrayList2 = new ArrayList<CasaWrapperModel>();
        arrayList2.add(this);
        WSDLModel wSDLModel = this.getCompAppWSDLModel(false);
        if (wSDLModel != null) {
            arrayList2.add((CasaWrapperModel)wSDLModel);
        }
        for (Model model : arrayList2) {
            Validation validation = new Validation();
            validation.validate(model, Validation.ValidationType.COMPLETE);
            List list = validation.getValidationResult();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public CasaValidationController getValidationController() {
        if (this.controller == null) {
            this.controller = new CasaValidationController(this);
        }
        return this.controller;
    }

    private static boolean isNCName(String string) {
        String string2 = "[_A-Za-z][-._A-Za-z0-9]*";
        return string.matches(string2);
    }

    private static boolean isURI(String string) {
        String string2 = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
        return string.matches(string2);
    }

    @Override
    public Casa getRootComponent() {
        return this.casa;
    }

    public void setCasa(Casa casa) {
        this.casa = casa;
    }

    protected ComponentUpdater<CasaComponent> getComponentUpdater() {
        return new CasaSyncUpdateVisitor();
    }

    public CasaComponent createComponent(CasaComponent casaComponent, Element element) {
        return this.getFactory().create(element, casaComponent);
    }

    public Casa createRootComponent(Element element) {
        CasaImpl casaImpl = new CasaImpl(this, element);
        this.setCasa(casaImpl);
        return casaImpl;
    }

    @Override
    public CasaComponentFactory getFactory() {
        return this.factory;
    }

    public boolean isWsitEnable(CasaPort casaPort) {
        Port port = this.getLinkedWSDLPort(casaPort);
        if (port != null) {
            Binding binding = (Binding)port.getBinding().get();
            for (ExtensibilityElement extensibilityElement : binding.getExtensibilityElements()) {
                String string = extensibilityElement.getQName().getNamespaceURI();
                if (!string.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refershWsitStatus(CasaPort casaPort) {
        this.startTransaction();
        try {
            if (casaPort != null) {
                // empty if block
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.isIntransaction()) {
                if (casaPort != null) {
                    this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REFRESH);
                }
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            if (casaPort != null) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REFRESH);
            }
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpointLink(CasaPort casaPort, String string) {
        if (casaPort == null || casaPort.getLink().getHref().equals(string)) {
            return;
        }
        this.startTransaction();
        try {
            casaPort.getLink().setHref(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.isIntransaction()) {
                this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REFRESH);
                this.endTransaction();
            }
            throw throwable;
        }
        if (this.isIntransaction()) {
            this.fireChangeEvent(casaPort, PROPERTY_CASA_PORT_REFRESH);
            this.endTransaction();
        }
    }
}

