/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.visitor;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.compapp.casaeditor.model.jbi.JBIComponent;
import org.netbeans.modules.compapp.casaeditor.model.visitor.JBIVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindJBIComponentVisitor
extends JBIVisitor.Deep {
    private JBIComponent result;
    private Element xmlNode;

    public static <T extends JBIComponent> T findComponent(Class<T> clazz, JBIComponent jBIComponent, String string) {
        JBIComponent jBIComponent2 = new FindJBIComponentVisitor().findComponent(jBIComponent, string);
        if (jBIComponent2 == null) {
            return null;
        }
        return (T)((JBIComponent)clazz.cast(jBIComponent2));
    }

    public JBIComponent findComponent(JBIComponent jBIComponent, Element element) {
        assert (element != null);
        this.xmlNode = element;
        this.result = null;
        jBIComponent.accept(this);
        return this.result;
    }

    public JBIComponent findComponent(JBIComponent jBIComponent, String string) {
        Document document = jBIComponent.getModel().getDocument();
        if (document == null) {
            return null;
        }
        Node node = null;
        if (string.startsWith("/jbi/service-assembly/connections/connection[")) {
            List list = jBIComponent.getModel().getAccess().findNodes(document, "/jbi/service-assembly/connections/connection");
            Pattern pattern = Pattern.compile("consumer\\[@endpoint-name='(.*?)'\\] and provider\\[@endpoint-name='(.*?)'\\]");
            Matcher matcher = pattern.matcher(string);
            assert (matcher.find() && matcher.groupCount() == 2);
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            node = this.findConnection(list, string2, string3);
        } else if (string.startsWith("/jbi/service-assembly/service-unit[")) {
            List list = jBIComponent.getModel().getAccess().findNodes(document, "/jbi/service-assembly/service-unit");
            int n = string.indexOf("'");
            int n2 = string.lastIndexOf("'");
            String string4 = string.substring(n + 1, n2);
            node = this.findServiceUnit(list, string4);
        } else {
            node = jBIComponent.getModel().getAccess().findNode(document, string);
        }
        if (node instanceof Element) {
            return this.findComponent(jBIComponent, (Element)node);
        }
        return null;
    }

    @Override
    protected void visitComponent(JBIComponent jBIComponent) {
        if (this.result != null) {
            return;
        }
        if (jBIComponent.referencesSameNode(this.xmlNode)) {
            this.result = jBIComponent;
            return;
        }
        super.visitChild(jBIComponent);
    }

    private Element findConnection(List<Node> list, String string, String string2) {
        for (Node node : list) {
            Element element = (Element)node;
            Element element2 = (Element)element.getElementsByTagName("consumer").item(0);
            Element element3 = (Element)element.getElementsByTagName("provider").item(0);
            if (!element2.getAttribute("endpoint-name").equals(string) || !element3.getAttribute("endpoint-name").equals(string2)) continue;
            return element;
        }
        return null;
    }

    private Element findServiceUnit(List<Node> list, String string) {
        for (Node node : list) {
            Element element = (Element)node;
            Element element2 = (Element)element.getElementsByTagName("target").item(0);
            Element element3 = (Element)element2.getElementsByTagName("component-name").item(0);
            String string2 = element3.getFirstChild() != null ? element3.getFirstChild().getNodeValue() : "";
            if (!string.equals(string2)) continue;
            return element;
        }
        return null;
    }
}

