/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponentVisitor;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.ConnectionState;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.NodeAbstractAction;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDeleteAction
extends NodeAbstractAction {
    public NodeDeleteAction(CasaNode casaNode) {
        super(NbBundle.getMessage(NodeDeleteAction.class, (String)"NAME_Delete"), casaNode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<CasaComponent> arrayList = new ArrayList<CasaComponent>();
        Object object = this.getData();
        if (object != null && object instanceof CasaComponent) {
            arrayList.add((CasaComponent)object);
        }
        NodeDeleteAction.delete(this.getModel(), arrayList);
    }

    public static void delete(CasaWrapperModel casaWrapperModel, List<CasaComponent> list) {
        DeleteVisitorCasa deleteVisitorCasa = new DeleteVisitorCasa(casaWrapperModel);
        for (CasaComponent casaComponent : list) {
            casaComponent.accept(deleteVisitorCasa);
        }
    }

    private static class DeleteVisitorCasa
    extends CasaComponentVisitor.Default {
        private CasaWrapperModel mModel;

        public DeleteVisitorCasa(CasaWrapperModel casaWrapperModel) {
            this.mModel = casaWrapperModel;
        }

        public void visit(CasaConnection casaConnection) {
            String string = casaConnection.getState();
            if (casaConnection.isInDocumentModel() && !ConnectionState.DELETED.getState().equals(string)) {
                this.mModel.removeConnection(casaConnection);
            }
        }

        public void visit(CasaConsumes casaConsumes) {
            if (casaConsumes.isInDocumentModel()) {
                this.mModel.removeExternalEndpoint(casaConsumes);
            }
        }

        public void visit(CasaProvides casaProvides) {
            if (casaProvides.isInDocumentModel()) {
                this.mModel.removeExternalEndpoint(casaProvides);
            }
        }

        public void visit(CasaPort casaPort) {
            this.mModel.removeCasaPort(casaPort);
        }

        public void visit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
            this.mModel.removeServiceEngineServiceUnit(casaServiceEngineServiceUnit);
        }
    }
}

