/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.palette;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.api.visual.widget.general.IconNodeWidget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.palette.CasaAcceptProvider;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.MultiTransferObject;

public class CasaCommonAcceptProvider
implements CasaAcceptProvider {
    private CasaModelGraphScene mScene;
    private Image mIconImage = null;
    private String mIconLable;
    private Rectangle mSceneBounds;
    private Dimension mIconOriginalSize;
    private static final Point msInvisiblePointLocation = new Point(-1210, -1210);
    private static final int TOP_VISIBLE_HEIGHT = 8;
    private static final int HORIZONTAL_VISIBLE_LEFT_WIDTH = 8;

    public CasaCommonAcceptProvider(CasaModelGraphScene casaModelGraphScene) {
        this.mScene = casaModelGraphScene;
        this.mIconImage = null;
    }

    public CasaModelGraphScene getScene() {
        return this.mScene;
    }

    public void acceptFinished() {
        this.mScene.getDragLayer().removeChildren();
        this.mIconOriginalSize = null;
        this.mIconImage = null;
    }

    public void acceptStarted(Transferable transferable) {
        this.mSceneBounds = this.mScene.getBounds();
        this.populateIconInfo(transferable);
    }

    public void positionIcon(Widget widget, Point point, ConnectorState connectorState) {
        IconNodeWidget iconNodeWidget;
        boolean bl;
        boolean bl2 = bl = connectorState != ConnectorState.REJECT;
        if (!bl) {
            this.makeIconNodeWidgetAsInvisible();
            this.mIconOriginalSize = null;
            return;
        }
        if (this.mSceneBounds == null) {
            this.mSceneBounds = this.mScene.getBounds();
        }
        if ((iconNodeWidget = this.getIconNodeWidget()) != null && iconNodeWidget.getBounds() != null) {
            Rectangle rectangle = iconNodeWidget.getBounds();
            Dimension dimension = new Dimension(0, 0);
            Point point2 = widget.convertLocalToScene(point);
            if (this.mIconOriginalSize == null) {
                this.mIconOriginalSize = new Dimension(iconNodeWidget.getBounds().width, iconNodeWidget.getBounds().height);
            }
            dimension = new Dimension(this.mIconOriginalSize.width, this.mIconOriginalSize.height);
            if (point2.x + this.mIconOriginalSize.width > this.mSceneBounds.width) {
                dimension.width = this.mSceneBounds.width - point2.x;
            }
            if (point2.y + this.mIconOriginalSize.height > this.mSceneBounds.height) {
                dimension.height = this.mSceneBounds.height - point2.y;
            }
            iconNodeWidget.setPreferredSize(dimension);
            iconNodeWidget.setPreferredLocation(point2);
            Rectangle rectangle2 = new Rectangle(point2.x - 8, point2.y - 8, 8 + dimension.width, 8 + dimension.height);
            this.mScene.getView().scrollRectToVisible(rectangle2);
        }
    }

    public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
        return ConnectorState.REJECT;
    }

    public void accept(Widget widget, Point point, Transferable transferable) {
    }

    protected void populateIconInfo(Transferable transferable) {
        if (this.mIconImage == null || this.mScene.getDragLayer().getChildren().size() < 1) {
            IconNodeWidget iconNodeWidget;
            try {
                if (transferable != null && ((DataFlavor[])(iconNodeWidget = transferable.getTransferDataFlavors())).length > 0) {
                    if (iconNodeWidget[0].getRepresentationClass().equals(MultiTransferObject.class)) {
                        MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData((DataFlavor)iconNodeWidget[0]);
                        DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(0);
                        if (dataFlavorArray.length > 0) {
                            for (int i = 0; i < multiTransferObject.getCount() && !this.extractIcon(dataFlavorArray[0].getRepresentationClass(), multiTransferObject.getTransferData(i, dataFlavorArray[0]), true); ++i) {
                            }
                        }
                    } else {
                        this.extractIcon(iconNodeWidget[0].getRepresentationClass(), transferable.getTransferData((DataFlavor)iconNodeWidget[0]), false);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            iconNodeWidget = new IconNodeWidget((Scene)this.mScene);
            iconNodeWidget.setImage(this.mIconImage);
            iconNodeWidget.setLabel(this.mIconLable);
            this.makeIconNodeWidgetAsInvisible();
            this.mScene.getDragLayer().addChild((Widget)iconNodeWidget);
        }
    }

    public boolean extractIcon(Class clazz, Object object, boolean bl) {
        boolean bl2 = false;
        if (Node.class.isAssignableFrom(clazz)) {
            Node node = (Node)object;
            this.mIconLable = "    " + node.getName();
            if (bl) {
                this.mIconLable = this.mIconLable + "...";
            }
            this.mIconImage = node.getIcon(1);
            bl2 = true;
        }
        return bl2;
    }

    private void makeIconNodeWidgetAsInvisible() {
        Widget widget;
        if (this.mScene.getDragLayer().getChildren().size() > 0 && (widget = (Widget)this.mScene.getDragLayer().getChildren().get(0)) != null) {
            widget.setPreferredLocation(msInvisiblePointLocation);
        }
    }

    private IconNodeWidget getIconNodeWidget() {
        IconNodeWidget iconNodeWidget = null;
        if (this.mScene.getDragLayer().getChildren().size() > 0) {
            iconNodeWidget = (IconNodeWidget)this.mScene.getDragLayer().getChildren().get(0);
        }
        return iconNodeWidget;
    }
}

