/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.properties.NamespaceEditorPanel;
import org.netbeans.modules.compapp.casaeditor.properties.StringEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class NamespaceEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String EMPTY = "";
    private boolean mWritable;
    private String mPropertyName;
    private QName mInitialURI;
    private Collection<PrefixNamespacePair> mURIs;
    private Collection<Option> mOptions;

    public NamespaceEditor(CasaWrapperModel casaWrapperModel, QName qName, String string, boolean bl) {
        this.mWritable = bl;
        this.mPropertyName = string;
        this.mOptions = new ArrayList<Option>();
        this.mInitialURI = qName;
        this.mURIs = new ArrayList<PrefixNamespacePair>();
        Map<String, String> map = casaWrapperModel.getNamespaces();
        for (String string2 : map.keySet()) {
            this.mURIs.add(new PrefixNamespacePair(string2, map.get(string2)));
        }
        this.mOptions.add(Option.None);
        this.mOptions.add(Option.Declared);
        this.mOptions.add(Option.Other);
        if (this.mInitialURI != null) {
            this.mURIs.remove(this.mInitialURI);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getAsText() {
        Object object = super.getValue();
        return object == null ? EMPTY : super.getAsText();
    }

    public void setAsText(String string) {
        if (EMPTY.equals(string) && this.getValue() == null) {
            return;
        }
    }

    public boolean isPaintable() {
        return false;
    }

    protected String getPaintableString() {
        Object object = this.getValue();
        return object == null ? NbBundle.getMessage(StringEditor.class, (String)"LBL_Null") : this.getAsText();
    }

    public Component getCustomEditor() {
        final NamespaceEditorPanel namespaceEditorPanel = new NamespaceEditorPanel(this.mInitialURI, this.mURIs, this.mOptions);
        namespaceEditorPanel.setEditable(this.mWritable);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)namespaceEditorPanel, NbBundle.getMessage(NamespaceEditor.class, (String)"LBL_QNAME_Editor"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        NamespaceEditor.this.setValue(namespaceEditorPanel.getCurrentSelection());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        if (this.mWritable) {
            namespaceEditorPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("validSelection")) {
                        dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                    }
                }
            });
            namespaceEditorPanel.checkValidity();
        } else {
            dialogDescriptor.setValid(false);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.getFeatureDescriptor().setValue("canEditAsText", false);
    }

    public static class PrefixNamespacePair {
        private String mPrefix;
        private String mNamespace;

        public PrefixNamespacePair(String string, String string2) {
            this.mPrefix = string;
            this.mNamespace = string2;
        }

        public String getPrefix() {
            return this.mPrefix;
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public String toString() {
            return this.mPrefix + ":" + this.mNamespace;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && object instanceof PrefixNamespacePair) {
                PrefixNamespacePair prefixNamespacePair = (PrefixNamespacePair)object;
                if (this.getNamespace().equals(prefixNamespacePair.getNamespace())) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + this.mPrefix.hashCode();
            n = n * 31 + this.mNamespace.hashCode();
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        None,
        Declared,
        Other;

    }
}

