/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.api.GrailsRuntime;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionSupport {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private static ExecutionSupport instance;
    private final GrailsRuntime runtime;

    private ExecutionSupport(GrailsRuntime grailsRuntime) {
        this.runtime = grailsRuntime;
    }

    public static synchronized ExecutionSupport getInstance() {
        if (instance == null) {
            instance = new ExecutionSupport(GrailsRuntime.getInstance());
        }
        return instance;
    }

    private static ExecutionSupport forRuntime(GrailsRuntime grailsRuntime) {
        if (grailsRuntime == null) {
            throw new NullPointerException("Runtime is null");
        }
        if (!grailsRuntime.isConfigured()) {
            return null;
        }
        return new ExecutionSupport(grailsRuntime);
    }

    public Callable<Process> createCreateApp(final File file) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                if (file.exists()) {
                    throw new IOException("Project directory already exists");
                }
                File file2 = file.getAbsoluteFile().getParentFile();
                FileUtil.createFolder((File)file2);
                String string = file.getName();
                GrailsRuntime.CommandDescriptor commandDescriptor = new GrailsRuntime.CommandDescriptor("create-app", file2, null, new String[]{string});
                return ExecutionSupport.this.runtime.createCommand(commandDescriptor).call();
            }
        };
    }

    public Process executeCreateApp(File file) throws Exception {
        return this.execute(this.createCreateApp(file));
    }

    public Callable<Process> createRunApp(final GrailsProjectConfig grailsProjectConfig) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File file = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
                Properties properties = new Properties();
                String string = grailsProjectConfig.getPort();
                if (string != null) {
                    properties.setProperty("server.port", string);
                }
                GrailsRuntime.CommandDescriptor commandDescriptor = new GrailsRuntime.CommandDescriptor("run-app", file, grailsProjectConfig.getEnvironment(), new String[0], properties);
                return ExecutionSupport.this.runtime.createCommand(commandDescriptor).call();
            }
        };
    }

    public Process executeRunApp(GrailsProjectConfig grailsProjectConfig) throws Exception {
        return this.execute(this.createRunApp(grailsProjectConfig));
    }

    public Callable<Process> createSimpleCommand(final String string, final GrailsProjectConfig grailsProjectConfig, final String ... stringArray) {
        return new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                File file = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
                GrailsRuntime.CommandDescriptor commandDescriptor = new GrailsRuntime.CommandDescriptor(string, file, grailsProjectConfig.getEnvironment(), stringArray);
                return ExecutionSupport.this.runtime.createCommand(commandDescriptor).call();
            }
        };
    }

    public Process executeSimpleCommand(String string, GrailsProjectConfig grailsProjectConfig, String ... stringArray) throws Exception {
        return this.execute(this.createSimpleCommand(string, grailsProjectConfig, stringArray));
    }

    private Process execute(Callable<Process> callable) throws Exception {
        Future<Process> future = EXECUTOR.submit(callable);
        try {
            return future.get();
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof Exception) {
                throw (Exception)executionException.getCause();
            }
            throw executionException;
        }
    }
}

