/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.wm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.netbeans.mobility.activesync.ActiveSyncException;
import org.netbeans.mobility.activesync.ActiveSyncOps;
import org.netbeans.mobility.activesync.DeviceConnectedListener;
import org.netbeans.mobility.activesync.RemoteFile;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class RemoteFilesystemChooser
extends JPanel
implements ExplorerManager.Provider {
    private static String currentFolder;
    private String selectedFolder;
    private static boolean foldersOnly;
    private ExplorerManager em;
    private static final ImageIcon CDC_PROJECT_ICON;
    private static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder";
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                if (RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes().length == 1) {
                    RemoteFile remoteFile = (RemoteFile)RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes()[0].getLookup().lookup(RemoteFile.class);
                    if (remoteFile == null) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    if (foldersOnly && !remoteFile.isDirectory()) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    if (!foldersOnly && remoteFile.isDirectory()) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    String[] stringArray = NodeOp.createPath((Node)RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes()[0], (Node)RemoteFilesystemChooser.this.getExplorerManager().getRootContext());
                    StringBuffer stringBuffer = new StringBuffer("\\");
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(stringArray[i]);
                        if (i + 1 >= stringArray.length) continue;
                        stringBuffer.append("\\");
                    }
                    RemoteFilesystemChooser.this.selectedFolder = stringBuffer.toString();
                    RemoteFilesystemChooser.this.firePropertyChange("valid", false, true);
                } else {
                    RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                }
            }
        }
    };
    private ConnectionListener connectionListener;
    private static Comparator REMOTE_FILE_COMPARATOR;

    public RemoteFilesystemChooser(String string, boolean bl) {
        foldersOnly = bl;
        this.selectedFolder = string;
        this.setPreferredSize(new Dimension(400, 500));
        this.setLayout(new BorderLayout());
        try {
            if (ActiveSyncOps.isAvailable()) {
                if (!ActiveSyncOps.getDefault().isDeviceConnected()) {
                    this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_DeviceDisconnected"));
                } else {
                    this.createView(null);
                }
            } else {
                this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyntNotInstalled"));
            }
        }
        catch (ActiveSyncException activeSyncException) {
            this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyncGeneralError"));
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.em == null) {
            this.em = new ExplorerManager();
        }
        return this.em;
    }

    public String getSelectedFile() {
        return this.selectedFolder;
    }

    public void addNotify() {
        super.addNotify();
        try {
            if (ActiveSyncOps.getDefault() != null) {
                this.connectionListener = new ConnectionListener();
                ActiveSyncOps.getDefault().addConnectionListener((DeviceConnectedListener)this.connectionListener);
            }
        }
        catch (ActiveSyncException activeSyncException) {
            // empty catch block
        }
    }

    public void removeNotify() {
        try {
            if (ActiveSyncOps.getDefault() != null) {
                ActiveSyncOps.getDefault().removeConnectionListener((DeviceConnectedListener)this.connectionListener);
            }
        }
        catch (ActiveSyncException activeSyncException) {
            // empty catch block
        }
        super.removeNotify();
    }

    private void createView(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (string == null) {
                this.createFileView();
            } else {
                this.createErrorView(string);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RemoteFilesystemChooser.this.createView(string);
                }
            });
        }
    }

    private void createFileView() {
        this.setVisible(false);
        this.removeAll();
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setBorder((Border)new LineBorder(Color.BLACK, 1, true));
        this.add((Component)beanTreeView, "Center");
        try {
            this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)new RemoteFileSystemChildren(ActiveSyncOps.getDefault().getRootFilesystems()[0])){

                public String getName() {
                    return "\\";
                }

                public Image getIcon(int n) {
                    return CDC_PROJECT_ICON.getImage();
                }

                public Image getOpenedIcon(int n) {
                    return this.getIcon(n);
                }
            });
        }
        catch (ActiveSyncException activeSyncException) {
            this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyncGeneralError"));
        }
        this.getExplorerManager().addPropertyChangeListener(this.pcl);
        this.invalidate();
        this.setVisible(true);
    }

    private void createErrorView(String string) {
        this.setVisible(false);
        this.removeAll();
        this.getExplorerManager().removePropertyChangeListener(this.pcl);
        try {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.firePropertyChange("valid", true, false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        this.add((Component)jLabel, "Center");
        this.invalidate();
        this.setVisible(true);
    }

    static {
        CDC_PROJECT_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/deployment/wm/resources/cdcProject.png"));
        REMOTE_FILE_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                RemoteFile remoteFile = (RemoteFile)object;
                RemoteFile remoteFile2 = (RemoteFile)object2;
                if (remoteFile.isDirectory() && remoteFile2.isDirectory() || !remoteFile.isDirectory() && !remoteFile2.isDirectory()) {
                    return remoteFile.getName().compareTo(remoteFile2.getName());
                }
                return !remoteFile.isDirectory() && remoteFile2.isDirectory() ? 1 : -1;
            }
        };
    }

    private class ConnectionListener
    implements DeviceConnectedListener {
        private ConnectionListener() {
        }

        public void onDeviceConnected(boolean bl) {
            if (bl) {
                RemoteFilesystemChooser.this.createView(null);
            } else {
                RemoteFilesystemChooser.this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_DeviceDisconnected"));
                RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
            }
        }
    }

    private static class RemoteFileSystemChildren
    extends Children.Keys {
        private RemoteFile folder;

        RemoteFileSystemChildren(RemoteFile remoteFile) {
            this.folder = remoteFile;
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof RemoteFile) {
                try {
                    RemoteFile remoteFile = (RemoteFile)object;
                    if (foldersOnly && !remoteFile.isDirectory()) {
                        return new AbstractNode[0];
                    }
                    return new AbstractNode[]{remoteFile.isDirectory() ? new RemoteFileSystemNode(remoteFile, (Children)new RemoteFileSystemChildren(remoteFile)) : new RemoteFileSystemNode(remoteFile, Children.LEAF)};
                }
                catch (Exception exception) {
                    return new AbstractNode[0];
                }
            }
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"NodeWait"));
            return new Node[]{abstractNode};
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(new Object[]{new Object()});
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        ActiveSyncOps activeSyncOps = ActiveSyncOps.getDefault();
                        Object[] objectArray = activeSyncOps.listFiles(RemoteFileSystemChildren.this.folder);
                        Arrays.sort(objectArray, REMOTE_FILE_COMPARATOR);
                        RemoteFileSystemChildren.this.setKeys(objectArray);
                    }
                    catch (ActiveSyncException activeSyncException) {
                        // empty catch block
                    }
                }
            });
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(Collections.EMPTY_LIST);
        }
    }

    private static class RemoteFileSystemNode
    extends AbstractNode {
        private RemoteFile file;

        RemoteFileSystemNode(RemoteFile remoteFile, Children children) {
            super(children, Lookups.singleton((Object)remoteFile));
            this.file = remoteFile;
            this.setIconBase(RemoteFilesystemChooser.FOLDER_ICON_BASE);
        }

        public String getName() {
            return this.file.getName();
        }

        public Image getIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (image == null) {
                image = super.getIcon(n);
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (image == null) {
                image = super.getOpenedIcon(n);
            }
            return image;
        }
    }
}

