/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.sjmc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SJMCToolkitEmulatorExecTask
extends Task {
    private List filesets = new LinkedList();
    private File home;
    private String mainclass;
    private String args;
    private String jvmargs;
    private String device;
    private String profile;
    private boolean xlet;
    private boolean applet;
    private String debuggerAddressProperty;
    private boolean debug;
    protected PrintWriter fos = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        String os = System.getProperty("os.name");
        if (os.toLowerCase().indexOf("windows") >= 0) {
            arguments.add(this.home + File.separator + "bin" + File.separator + "emulator.exe");
        } else {
            arguments.add(this.home + File.separator + "bin" + File.separator + "emulator");
        }
        if (!$assertionsDisabled && this.device == null) {
            throw new AssertionError();
        }
        arguments.add("-Xdevice:" + this.device);
        if (!$assertionsDisabled && this.profile == null) {
            throw new AssertionError();
        }
        arguments.add("-Xapi:" + this.profile);
        if (this.debug) {
            arguments.add("-Xdebug");
            String debugAddress = null;
            try {
                debugAddress = Integer.toString(this.determineFreePort());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            arguments.add("-Xrunjdwp:transport=dt_socket,address=" + debugAddress + ",server=y,suspend=y");
            if (this.debuggerAddressProperty != null) {
                this.getProject().setProperty(this.debuggerAddressProperty, debugAddress);
            }
        }
        if (!this.xlet && !this.applet) {
            arguments.add("-classpath");
            arguments.add(this.createPath());
            arguments.add(this.mainclass);
            this.appendArguments(arguments);
        } else if (this.xlet) {
            arguments.add("-Xxlet");
            StringTokenizer xlets = new StringTokenizer(this.mainclass, ";");
            while (xlets.hasMoreElements()) {
                arguments.add("-name");
                arguments.add(xlets.nextElement());
                arguments.add("-path");
                arguments.add(this.createPath());
                if (this.args == null || this.args.length() == 0) continue;
                arguments.add("-args");
                this.appendArguments(arguments);
            }
        } else {
            this.generateHtml();
            arguments.add("-Xapplet:");
        }
        String[] arg = arguments.toArray(new String[0]);
        this.getProject().log("Application arguments:", 3);
        for (int i = 0; i < arg.length; ++i) {
            this.getProject().log("'" + arg[i] + "'", 3);
        }
        Process p = null;
        try {
            try {
                p = Runtime.getRuntime().exec(arg);
                StreamReader inputReader = new StreamReader(p.getInputStream(), 2);
                StreamReader errorReader = new StreamReader(p.getErrorStream(), 1);
                inputReader.start();
                errorReader.start();
                p.waitFor();
                inputReader.join();
                errorReader.join();
                p.destroy();
            }
            catch (ThreadDeath td) {
                p.destroy();
                throw td;
            }
            this.logFlush();
            if (p.exitValue() != 0) {
                throw new BuildException("Emulator execution failed!");
            }
        }
        catch (IOException ex) {
            throw new BuildException("Emulator execution failed!");
        }
        catch (InterruptedException ex) {
            throw new BuildException("Emulator execution failed!");
        }
    }

    private void generateHtml() throws BuildException {
        File f = new File(this.home, "epoc32\\winscw\\c\\private\\applet.html");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(f));
            pw.println("<HTML>");
            pw.println("<HEAD>");
            pw.println("<TITLE> A Testing Program for " + this.mainclass + " </TITLE>");
            pw.println("</HEAD>");
            pw.println("<BODY>");
            pw.println("<APPLET CODE=\"" + this.mainclass + ".class\" WIDTH=240 HEIGHT=320>");
            pw.println("</APPLET>");
            pw.println("</BODY>");
            pw.println("</HTML>");
        }
        catch (IOException ex) {
            throw new BuildException("HTML can not be writen");
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private String createPath() {
        Iterator it = this.filesets.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                sb.append("\"" + basedir.getAbsolutePath() + File.separatorChar + files[i] + "\"");
                if (i + 1 >= files.length) continue;
                sb.append(";");
            }
        }
        return sb.toString();
    }

    private void appendArguments(List args) {
        if (this.args == null || this.args.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.args, " ");
        while (st.hasMoreTokens()) {
            args.add(st.nextToken());
        }
    }

    private int determineFreePort() throws IOException {
        Socket sock = new Socket();
        sock.bind(null);
        int port = sock.getLocalPort();
        sock.close();
        return port;
    }

    private void outputLog(String line, int messageLevel) {
        if (this.fos == null) {
            this.log(line, messageLevel);
        } else {
            this.fos.println(line);
        }
    }

    private void logFlush() {
        if (this.fos != null) {
            this.fos.close();
        }
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public String getMainclass() {
        return this.mainclass;
    }

    public void setMainclass(String mainclass) {
        this.mainclass = mainclass;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getJvmargs() {
        return this.jvmargs;
    }

    public void setJvmargs(String jvmargs) {
        this.jvmargs = jvmargs;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public boolean isXlet() {
        return this.xlet;
    }

    public void setXlet(boolean xlet) {
        this.xlet = xlet;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    public String getDebuggerAddressProperty() {
        return this.debuggerAddressProperty;
    }

    public void setDebuggerAddressProperty(String debuggerAddressProperty) {
        this.debuggerAddressProperty = debuggerAddressProperty;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    static {
        $assertionsDisabled = !SJMCToolkitEmulatorExecTask.class.desiredAssertionStatus();
    }

    class StreamReader
    extends Thread {
        private BufferedReader din;
        private int messageLevel;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;

        public StreamReader(InputStream is, int messageLevel) {
            this.din = new BufferedReader(new InputStreamReader(is));
            this.messageLevel = messageLevel;
        }

        public void pumpStream() throws IOException {
            if (!this.endOfStream) {
                String line = this.din.readLine();
                if (line != null) {
                    SJMCToolkitEmulatorExecTask.this.outputLog(line, this.messageLevel);
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        StreamReader.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

