/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.support.GroovyProjectExtender;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.groovy.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyFileWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private transient GroovyProjectExtender extender;
    private transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public static GroovyFileWizardIterator create() {
        return new GroovyFileWizardIterator();
    }

    private GroovyFileWizardIterator() {
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        List<SourceGroup> list = GroovySources.getGroovySourceGroups(sources);
        SourceGroup[] sourceGroupArray = list.toArray(new SourceGroup[list.size()]);
        assert (sourceGroupArray != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{new ValidatingPanel(Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray))};
        }
        return new WizardDescriptor.Panel[]{new ValidatingPanel(JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray))};
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        assert (panelArray != null);
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String string = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        String string2 = GroovyFileWizardIterator.getSelectedPackageName(fileObject);
        DataObject dataObject2 = null;
        dataObject2 = string2 == null ? dataObject.createFromTemplate(dataFolder, string) : dataObject.createFromTemplate(dataFolder, string, Collections.singletonMap("package", string2));
        FileObject fileObject3 = dataObject2.getPrimaryFile();
        this.initExtender();
        if (this.extender != null && !this.extender.isGroovyEnabled()) {
            this.extender.enableGroovy();
        }
        return Collections.singleton(fileObject3);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels(wizardDescriptor);
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        ChangeListener[] changeListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    private GroovyProjectExtender initExtender() {
        Project project;
        if (this.extender == null && this.wiz != null && (project = Templates.getProject((WizardDescriptor)this.wiz)) != null) {
            this.extender = (GroovyProjectExtender)project.getLookup().lookup(GroovyProjectExtender.class);
        }
        return this.extender;
    }

    private static String getSelectedPackageName(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Sources sources = ProjectUtils.getSources((Project)project);
        List<SourceGroup> list = GroovySources.getGroovySourceGroups(sources);
        String string = null;
        for (int i = 0; i < list.size() && string == null; ++i) {
            string = FileUtil.getRelativePath((FileObject)list.get(i).getRootFolder(), (FileObject)fileObject);
        }
        if (string != null) {
            string = string.replaceAll("/", ".");
        }
        return string;
    }

    private class ValidatingPanel
    extends DelegatingWizardDescriptorPanel {
        public ValidatingPanel(WizardDescriptor.Panel panel) {
            super(panel);
        }

        public boolean isValid() {
            return true;
        }
    }
}

